/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DTPUtil {
    private static DTPUtil instance;
    private SessionStatus sessionStatus = null;
    private DesignerState designerState = null;
    private ModelOdaAdapter modelOdaAdapter = new ModelOdaAdapter();
    private static final String SAMPELDB_DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.sampledb";
    private static final String JDBC_DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.jdbc";
    static final /* synthetic */ boolean $assertionsDisabled;

    private DTPUtil() {
    }

    public static synchronized DTPUtil getInstance() {
        if (instance == null) {
            instance = new DTPUtil();
        }
        return instance;
    }

    public void updateDataSourceHandle(DesignSessionResponse response, OdaDataSourceHandle dataSourceHandle) throws OdaException {
        if (new EcoreUtil.EqualityHelper().equals((EObject)this.modelOdaAdapter.createDataSourceDesign(dataSourceHandle), (EObject)response.getDataSourceDesign())) {
            return;
        }
        this.initDesignSessionFields(response);
        this.isSessionOk();
        try {
            this.updateROMDesignerState(dataSourceHandle);
            this.modelOdaAdapter.updateDataSourceHandle(response.getDataSourceDesign(), dataSourceHandle);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void updateDataSetHandle(DesignSessionResponse response, OdaDataSetHandle dataSetHandle, boolean isSourceChanged) throws OdaException {
        if (new EcoreUtil.EqualityHelper().equals((EObject)this.modelOdaAdapter.createDataSetDesign(dataSetHandle), (EObject)response.getDataSetDesign())) {
            return;
        }
        this.initDesignSessionFields(response);
        this.isSessionOk();
        try {
            this.updateROMDesignerState(dataSetHandle);
            this.modelOdaAdapter.updateDataSetHandle(response.getDataSetDesign(), dataSetHandle, isSourceChanged);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public OdaDataSourceHandle createOdaDataSourceHandle(DesignSessionResponse response, ModuleHandle parentHandle) throws OdaException, SemanticException {
        this.initDesignSessionFields(response);
        this.isSessionOk();
        DataSourceDesign dataSourceDesign = response.getDataSourceDesign();
        if (dataSourceDesign.getOdaExtensionId().equals(SAMPELDB_DATA_SOURCE_ID)) {
            dataSourceDesign.setOdaExtensionId(JDBC_DATA_SOURCE_ID);
        }
        OdaDataSourceHandle dataSourceHandle = null;
        dataSourceHandle = this.modelOdaAdapter.createDataSourceHandle(dataSourceDesign, parentHandle);
        this.updateROMDesignerState(dataSourceHandle);
        return dataSourceHandle;
    }

    public OdaDataSetHandle createOdaDataSetHandle(DesignSessionResponse response, ModuleHandle parentHandle) throws OdaException, SemanticException {
        this.initDesignSessionFields(response);
        this.isSessionOk();
        OdaDataSetHandle dataSetHandle = null;
        dataSetHandle = this.modelOdaAdapter.createDataSetHandle(response.getDataSetDesign(), parentHandle);
        this.updateROMDesignerState(dataSetHandle);
        return dataSetHandle;
    }

    public DesignSessionRequest createDesignSessionRequest(OdaDataSourceHandle dataSourceHandle) {
        DesignSessionRequest designSessionRequest = DesignFactory.eINSTANCE.createDesignSessionRequest(this.modelOdaAdapter.createDataSourceDesign(dataSourceHandle));
        this.designerState = this.modelOdaAdapter.newOdaDesignerState(dataSourceHandle);
        if (this.designerState != null) {
            designSessionRequest.setDesignerState(this.designerState);
        }
        return designSessionRequest;
    }

    public DesignSessionRequest createDesignSessionRequest(OdaDataSetHandle dataSetHandle) {
        DataSetDesign dataSetDesign = this.modelOdaAdapter.createDataSetDesign(dataSetHandle);
        return this.createDesignSessionRequest(dataSetDesign, this.modelOdaAdapter.newOdaDesignerState(dataSetHandle));
    }

    public DesignSessionRequest createDesignSessionRequest(DataSetDesign requestDataSetDesign, DesignerState requestDesignerState) {
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest(requestDataSetDesign);
        this.designerState = requestDesignerState;
        newRequest.setDesignerState(requestDesignerState);
        return newRequest;
    }

    private void initDesignSessionFields(DesignSessionResponse response) {
        this.sessionStatus = response.getSessionStatus();
        this.designerState = response.getDesignerState();
    }

    private void isSessionOk() throws OdaException {
        if (!$assertionsDisabled && this.sessionStatus == null) {
            throw new AssertionError();
        }
        if (this.sessionStatus.getValue() != 0) {
            throw new OdaException(this.sessionStatus.getLiteral());
        }
    }

    private void updateROMDesignerState(Object obj) throws SemanticException {
        if (this.designerState == null || obj == null) {
            return;
        }
        if (obj instanceof OdaDataSourceHandle) {
            this.modelOdaAdapter.updateROMDesignerState(this.designerState, (OdaDataSourceHandle)obj);
        } else if (obj instanceof OdaDataSetHandle) {
            this.modelOdaAdapter.updateROMDesignerState(this.designerState, (OdaDataSetHandle)obj);
        }
    }

    static {
        $assertionsDisabled = !DTPUtil.class.desiredAssertionStatus();
        instance = null;
    }
}

