/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public final class DataSetProvider {
    private static DataSetProvider instance;
    private transient Hashtable htColumns = new Hashtable(10);
    private static Hashtable htDataSourceExtensions;
    private transient Hashtable sessionTable = new Hashtable(10);
    private static final char RENAME_SEPARATOR = '_';
    private static String UNNAME_PREFIX;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static DataSetProvider newInstance() {
        return new DataSetProvider();
    }

    public static DataSetProvider getCurrentInstance() {
        if (instance == null) {
            instance = DataSetProvider.newInstance();
        }
        return instance;
    }

    public DataSetViewData[] getColumns(String dataSetName, boolean refresh) {
        ModuleHandle handle = Utility.getReportModuleHandle();
        DataSetHandle dataSet = handle.findDataSet(dataSetName);
        if (dataSet == null) {
            return new DataSetViewData[0];
        }
        return this.getColumns(dataSet, refresh);
    }

    public DataSetViewData[] getColumns(DataSetHandle dataSet, boolean refresh) {
        return this.getColumns(dataSet, refresh, true, false);
    }

    public DataSetViewData[] getColumns(DataSetHandle dataSet, boolean refresh, boolean useColumnHints, boolean suppressErrorMessage) {
        DataSetViewData[] columns;
        block9: {
            if (dataSet == null) {
                return new DataSetViewData[0];
            }
            columns = (DataSetViewData[])this.htColumns.get(dataSet);
            if (!refresh && columns == null) {
                columns = this.getCachedColumns(dataSet);
            }
            if (columns == null || refresh) {
                columns = null;
                try {
                    boolean canExecute = true;
                    if (dataSet instanceof OdaDataSetHandle) {
                        String queryTxt = ((OdaDataSetHandle)dataSet).getQueryText();
                        boolean bl = canExecute = queryTxt != null && queryTxt.trim().length() > 0;
                    }
                    if (canExecute) {
                        DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
                        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
                        IQueryResults results = this.execute(dataSet, useColumnHints, true, 1, session);
                        if (results != null) {
                            results.close();
                        }
                        columns = (DataSetViewData[])this.htColumns.get(dataSet);
                        session.shutdown();
                    }
                }
                catch (BirtException e) {
                    if (suppressErrorMessage) break block9;
                    ExceptionHandler.handle(e);
                }
            }
        }
        if (columns == null) {
            columns = new DataSetViewData[]{};
            this.updateModel(dataSet, columns);
            this.htColumns.put(dataSet, columns);
        }
        return columns;
    }

    public DataSetViewData[] populateAllOutputColumns(DataSetHandle dataSetHandle) throws BirtException {
        DataSessionContext context = new DataSessionContext(3, dataSetHandle.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        IResultMetaData metaData = session.getDataSetMetaData(dataSetHandle, false);
        DataSetViewData[] items = new DataSetViewData[metaData.getColumnCount()];
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            items[i] = new DataSetViewData();
            items[i].setName(metaData.getColumnName(i + 1));
            items[i].setDataTypeName(metaData.getColumnTypeName(i + 1));
            items[i].setAlias(metaData.getColumnAlias(i + 1));
            items[i].setComputedColumn(metaData.isComputedColumn(i + 1));
            items[i].setPosition(i + 1);
            items[i].setDataType(metaData.getColumnType(i + 1));
        }
        this.updateModel(dataSetHandle, items);
        return items;
    }

    private final DataSetViewData[] getCachedColumns(DataSetHandle dataSet) {
        return null;
    }

    public void setModelOfDataSetHandle(DataSetHandle dataSet, DataSetViewData[] dsItemModel) {
        if (dataSet == null || dsItemModel == null) {
            return;
        }
        this.updateModel(dataSet, dsItemModel);
        this.htColumns.put(dataSet, dsItemModel);
    }

    public IQueryResults execute(DataSetHandle dataSet, DataRequestSession session) throws BirtException {
        return this.execute(dataSet, true, true, -1, session);
    }

    public IQueryResults execute(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters, int rowsToReturn, DataRequestSession session) throws BirtException {
        this.populateAllOutputColumns(dataSet);
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        QueryDefinition queryDefn = this.getQueryDefinition((IBaseDataSetDesign)dataSetDesign, rowsToReturn);
        IQueryResults resultSet = this.executeQuery(session, queryDefn);
        this.saveResultToDataItems(dataSet, resultSet);
        return resultSet;
    }

    public IQueryResults execute(DataSetHandle dataSet, QueryDefinition queryDefn, boolean useColumnHints, boolean useFilters, DataRequestSession session) throws BirtException {
        return this.execute(dataSet, queryDefn, useColumnHints, useFilters, false, session);
    }

    public IQueryResults execute(DataSetHandle dataSet, QueryDefinition queryDefn, boolean useColumnHints, boolean useFilters, boolean clearCache, DataRequestSession session) throws BirtException {
        this.populateAllOutputColumns(dataSet);
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (clearCache) {
            BaseDataSourceDesign dataSourceDesign = session.getModelAdaptor().adaptDataSource(dataSet.getDataSource());
            session.clearCache((IBaseDataSourceDesign)dataSourceDesign, (IBaseDataSetDesign)dataSetDesign);
        }
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        IQueryResults resultSet = this.executeQuery(session, queryDefn);
        this.saveResultToDataItems(dataSet, resultSet);
        return resultSet;
    }

    private void saveResultToDataItems(DataSetHandle dataSet, IQueryResults resultSet) throws BirtException {
        int n;
        IResultMetaData metaData = resultSet.getResultMetaData();
        int columnCount = 0;
        if (metaData != null) {
            columnCount = metaData.getColumnCount();
        }
        DataSetViewData[] columns = new DataSetViewData[columnCount];
        HashSet<String> orgColumnNameSet = new HashSet<String>();
        HashSet<String> uniqueColumnNameSet = new HashSet<String>();
        for (n = 0; n < columns.length; ++n) {
            orgColumnNameSet.add(metaData.getColumnName(n + 1));
        }
        for (n = 0; n < columns.length; ++n) {
            columns[n] = new DataSetViewData();
            columns[n].setParent(dataSet);
            columns[n].setDataType(metaData.getColumnType(n + 1));
            columns[n].setDataTypeName(metaData.getColumnTypeName(n + 1));
            columns[n].setPosition(n + 1);
            columns[n].setAlias(metaData.getColumnAlias(n + 1));
            columns[n].setComputedColumn(metaData.isComputedColumn(n + 1));
            String columnName = metaData.getColumnName(n + 1);
            String uniqueColumnName = this.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, n);
            columns[n].setDataSetColumnName(uniqueColumnName);
            uniqueColumnNameSet.add(uniqueColumnName);
            if (uniqueColumnName.equals(columnName)) continue;
            this.updateModelColumn(dataSet, columns[n]);
        }
        this.updateModel(dataSet, columns);
        this.htColumns.put(dataSet, columns);
    }

    private void updateModelColumn(DataSetHandle ds, DataSetViewData column) {
        PropertyHandle resultSetColumns = ds.getPropertyHandle("resultSet");
        if (resultSetColumns == null) {
            return;
        }
        Iterator iterator = resultSetColumns.iterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            ResultSetColumnHandle rsColumnHandle = (ResultSetColumnHandle)iterator.next();
            if (!$assertionsDisabled && rsColumnHandle.getPosition() == null) {
                throw new AssertionError();
            }
            if (rsColumnHandle.getPosition().intValue() != column.getPosition()) continue;
            if (rsColumnHandle.getColumnName() == null || rsColumnHandle.getColumnName().equals(column.getDataSetColumnName())) break;
            try {
                rsColumnHandle.setColumnName(column.getDataSetColumnName());
            }
            catch (SemanticException e) {}
            break;
        }
    }

    private IQueryResults executeQuery(DataRequestSession session, QueryDefinition queryDefn) throws BirtException {
        IQueryResults resultSet = session.executeQuery(queryDefn, null, null, null);
        return resultSet;
    }

    public final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, int rowsToReturn) {
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            List parameters = dataSetDesign.getParameters();
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                ParameterDefinition paramDefn = (ParameterDefinition)iter.next();
                if (!paramDefn.isInputMode() || paramDefn.getDefaultInputValue() == null) continue;
                InputParameterBinding binding = new InputParameterBinding(paramDefn.getName(), (IBaseExpression)new ScriptExpression(paramDefn.getDefaultInputValue().toString()));
                defn.addInputParamBinding(binding);
            }
            return defn;
        }
        return null;
    }

    public final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams) {
        return this.getQueryDefinition(dataSetDesign, bindingParams, -1);
    }

    private QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams, int rowsToReturn) {
        if (bindingParams == null || bindingParams.length == 0) {
            return this.getQueryDefinition(dataSetDesign, rowsToReturn);
        }
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            for (int i = 0; i < bindingParams.length; ++i) {
                ParamBindingHandle param = bindingParams[i];
                InputParameterBinding binding = new InputParameterBinding(param.getParamName(), (IBaseExpression)new ScriptExpression(param.getExpression()));
                defn.addInputParamBinding(binding);
            }
            return defn;
        }
        return null;
    }

    private String getUniqueName(HashSet orgColumnNameSet, HashSet newColumnNameSet, String columnName, int index) {
        String newColumnName;
        if (columnName == null || columnName.trim().length() == 0 || newColumnNameSet.contains(columnName)) {
            newColumnName = columnName == null || columnName.trim().length() == 0 ? UNNAME_PREFIX + '_' + String.valueOf(index + 1) : columnName + '_' + String.valueOf(index + 1);
            int i = 1;
            while (orgColumnNameSet.contains(newColumnName) || newColumnNameSet.contains(newColumnName)) {
                newColumnName = newColumnName + String.valueOf('_') + i;
                ++i;
            }
        } else {
            newColumnName = columnName;
        }
        return newColumnName;
    }

    public void updateModel(DataSetHandle ds, DataSetViewData[] columns) {
        PropertyHandle handle = ds.getPropertyHandle("columnHints");
        PropertyHandle resultSetColumnHandle = ds.getPropertyHandle("resultSetHints");
        Iterator iter = handle.iterator();
        if (iter != null) {
            block0: while (iter.hasNext()) {
                ColumnHintHandle hint = (ColumnHintHandle)iter.next();
                for (int n = 0; n < columns.length; ++n) {
                    String columnName = columns[n].getName();
                    if (resultSetColumnHandle != null && (columnName == null || columnName.trim().length() == 0)) {
                        Iterator resultIter = resultSetColumnHandle.iterator();
                        if (resultIter != null) {
                            while (resultIter.hasNext()) {
                                ResultSetColumnHandle column = (ResultSetColumnHandle)resultIter.next();
                                if (column.getPosition() != n + 1) continue;
                                columnName = column.getColumnName();
                                break;
                            }
                        }
                        if (columnName == null) {
                            columnName = "";
                        }
                        columns[n].setName(columnName);
                    }
                    if (!columns[n].getName().equals(hint.getColumnName())) continue;
                    columns[n].setDisplayName(hint.getDisplayName());
                    columns[n].setAlias(hint.getAlias());
                    columns[n].setHelpText(hint.getHelpText());
                    continue block0;
                }
            }
        }
    }

    public IBaseDataSetDesign createDataSetDesign(DataSetHandle dataSet) throws BirtException {
        DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        return session.getModelAdaptor().adaptDataSet(dataSet);
    }

    public IBaseDataSourceDesign createDataSourceDesign(DataSourceHandle dataSource) throws BirtException {
        DataSessionContext context = new DataSessionContext(3, dataSource.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        return session.getModelAdaptor().adaptDataSource(dataSource);
    }

    public DataSetViewData[] getCachedDataSetItemModel(DataSetHandle ds) {
        DataSetViewData[] result = (DataSetViewData[])this.htColumns.get(ds);
        if (result == null) {
            result = new DataSetViewData[]{};
        }
        return result;
    }

    public static IConfigurationElement findDataSetElement(String dataSetType, String dataSourceType) {
        IConfigurationElement dataSourceElem = DataSetProvider.findDataSourceElement(dataSourceType);
        if (dataSourceElem != null) {
            IExtension ext = dataSourceElem.getDeclaringExtension();
            IConfigurationElement[] elements = ext.getConfigurationElements();
            for (int n = 0; n < elements.length; ++n) {
                if (!elements[n].getAttribute("id").equals(dataSetType)) continue;
                return elements[n];
            }
        }
        return null;
    }

    public static IConfigurationElement findDataSourceElement(String dataSourceType) {
        if (!$assertionsDisabled && dataSourceType == null) {
            throw new AssertionError();
        }
        IConfigurationElement element = (IConfigurationElement)htDataSourceExtensions.get(dataSourceType);
        if (element == null) {
            int n;
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.designer.ui.odadatasource");
            for (n = 0; n < elements.length; ++n) {
                if (!elements[n].getAttribute("id").equals(dataSourceType)) continue;
                element = elements[n];
                htDataSourceExtensions.put(dataSourceType, element);
                break;
            }
            elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.datatools.connectivity.oda.design.ui.dataSource");
            for (n = 0; n < elements.length; ++n) {
                if (!elements[n].getAttribute("id").equals(dataSourceType)) continue;
                element = elements[n];
                htDataSourceExtensions.put(dataSourceType, element);
                break;
            }
        }
        return element;
    }

    public final IBaseDataSetDesign getDataSetDesign(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters) throws BirtException {
        if (dataSet != null) {
            DataRequestSession session = this.getDataRequestSession(dataSet);
            return this.getDataSetDesign(dataSet, useColumnHints, useFilters, session);
        }
        return null;
    }

    private IBaseDataSetDesign getDataSetDesign(DataRequestSession session, DataSetHandle dataSet, boolean useColumnHints, boolean useFilters) throws BirtException {
        if (dataSet != null) {
            return this.getDataSetDesign(dataSet, useColumnHints, useFilters, session);
        }
        return null;
    }

    private IBaseDataSetDesign getDataSetDesign(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters, DataRequestSession session) throws BirtException {
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        if (!(dataSet instanceof JointDataSetHandle)) {
            BaseDataSourceDesign dataSourceDesign = session.getModelAdaptor().adaptDataSource(dataSet.getDataSource());
            session.defineDataSource((IBaseDataSourceDesign)dataSourceDesign);
        }
        if (dataSet instanceof JointDataSetHandle) {
            this.defineSourceDataSets(session, dataSet, (IBaseDataSetDesign)dataSetDesign);
        }
        session.defineDataSet((IBaseDataSetDesign)dataSetDesign);
        return dataSetDesign;
    }

    private void defineSourceDataSets(DataRequestSession session, DataSetHandle dataSet, IBaseDataSetDesign dataSetDesign) throws BirtException {
        List dataSets = dataSet.getModuleHandle().getAllDataSets();
        for (int i = 0; i < dataSets.size(); ++i) {
            DataSetHandle dsHandle = (DataSetHandle)dataSets.get(i);
            if (dsHandle.getName() == null || !dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getLeftDataSetDesignName()) && !dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getRightDataSetDesignName())) continue;
            this.getDataSetDesign(session, dsHandle, true, true);
        }
    }

    public DataRequestSession getDataRequestSession(DataSetHandle dataSet) throws BirtException {
        if (this.sessionTable.get(dataSet.getName()) != null) {
            return (DataRequestSession)this.sessionTable.get(dataSet.getName());
        }
        DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        this.sessionTable.put(dataSet.getName(), session);
        return session;
    }

    public Collection getParametersFromDataSet(DataSetHandle dataSet) throws BirtException {
        return this.prepareQuery(dataSet).getParameterMetaData();
    }

    public IPreparedQuery prepareQuery(DataSetHandle dataSet) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        IBaseDataSetDesign dataSetDesign = this.getDataSetDesign(dataSet, true, true);
        QueryDefinition queryDefn = this.getQueryDefinition(dataSetDesign, -1);
        return session.prepare((IQueryDefinition)queryDefn, null);
    }

    public IPreparedQuery prepareQuery(DataSetHandle dataSet, IQueryDefinition query) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        this.getDataSetDesign(dataSet, true, true);
        return session.prepare(query, null);
    }

    public IPreparedQuery prepareQuery(DataSetHandle dataSet, IQueryDefinition query, boolean useColumnHints, boolean useFilters) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        this.getDataSetDesign(dataSet, useColumnHints, useFilters);
        return session.prepare(query, null);
    }

    public final IPreparedQuery prepareQuery(DataSetHandle dataSet, ParamBindingHandle[] bindingParams, boolean useColumnHints, boolean useFilters) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        IBaseDataSetDesign dataSetDesign = this.getDataSetDesign(dataSet, useColumnHints, useFilters);
        return session.prepare((IQueryDefinition)this.getQueryDefinition(dataSetDesign, bindingParams), null);
    }

    public static ClassLoader getCustomScriptClassLoader(ClassLoader parent) {
        String classPath = System.getProperty("workspace.projectclasspath");
        if (classPath == null || classPath.length() == 0) {
            return parent;
        }
        String[] classPathArray = classPath.split(";", -1);
        int count = classPathArray.length;
        URL[] urls = new URL[count];
        for (int i = 0; i < count; ++i) {
            File file = new File(classPathArray[i]);
            try {
                urls[i] = file.toURL();
                continue;
            }
            catch (MalformedURLException e) {
                urls[i] = null;
            }
        }
        return new URLClassLoader(urls, parent);
    }

    static {
        $assertionsDisabled = !DataSetProvider.class.desiredAssertionStatus();
        instance = null;
        htDataSourceExtensions = new Hashtable(10);
        UNNAME_PREFIX = "UNNAMED";
    }
}

