/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractFieldEditor
extends FieldEditor {
    protected boolean isLoaded = false;
    private boolean isDirty = false;
    private String oldValue = "";
    private String propValue = "";
    private String defaultUnit = "";

    public AbstractFieldEditor() {
    }

    public AbstractFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public void setDefaultUnit(String defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    public String getDefaultUnit() {
        return this.defaultUnit;
    }

    public void load() {
        if (this.getPreferenceStore() != null) {
            this.setPresentsDefaultValue(false);
            this.isLoaded = false;
            this.doLoad();
            this.isLoaded = true;
            this.refreshValidState();
        }
    }

    public void loadDefault() {
        if (this.getPreferenceStore() != null) {
            this.setPresentsDefaultValue(true);
            this.isLoaded = false;
            this.doLoadDefault();
            this.isLoaded = true;
            this.refreshValidState();
        }
    }

    protected void doStore() {
        if (this.propValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        if (this.isDirty()) {
            if (this.propValue.length() > 0) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), this.propValue);
            } else {
                this.getPreferenceStore().setValue(this.getPreferenceName(), null);
            }
        }
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getPropValue() {
        return this.propValue;
    }

    protected void setOldValue(String oldValue) {
        if (oldValue == null) {
            oldValue = "";
        }
        this.oldValue = oldValue;
        this.propValue = oldValue;
        this.markDirty(false);
    }

    protected void setPropValue(String newValue) {
        if (newValue == null) {
            newValue = "";
        }
        this.propValue = newValue;
    }

    protected abstract String getStringValue();

    protected void valueChanged(String name) {
        if (!this.isLoaded) {
            return;
        }
        String curValue = this.getPropValue();
        String newValue = this.getStringValue();
        this.setPresentsDefaultValue(false);
        if (!curValue.equals(newValue)) {
            this.fireValueChanged(name, curValue, newValue);
            this.setPropValue(newValue);
            this.markDirty(true);
        }
    }

    protected void markDirty(boolean value) {
        this.isDirty = value;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }
}

