/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.DataItemBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataColumnBindingDialog
extends DataItemBindingDialog {
    protected static final String DEFAULT_ITEM_NAME = "data column";
    protected static final String NEW_DATAITEM_TITLE = Messages.getString((String)"DataColumBindingDialog.title.CreateNewDataBinding");
    protected static final String EDIT_DATAITEM_TITLE = Messages.getString((String)"DataColumBindingDialog.title.EditDataBinding");

    public DataColumnBindingDialog() {
        super(NEW_DATAITEM_TITLE);
    }

    public void setInput(ReportItemHandle input) {
        this.setInput(input, null);
    }

    protected DesignElementHandle getBindingObject() {
        return this.input;
    }

    public void setInput(ReportItemHandle input, ComputedColumnHandle bindingHandle) {
        this.input = input;
        this.setAggregateOns(DEUtil.getGroups((DesignElementHandle)input));
        this.setDataTypes(ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET));
        if (bindingHandle != null) {
            this.setTitle(EDIT_DATAITEM_TITLE);
        }
        this.bindingColumn = bindingHandle;
        try {
            if (this.bindingColumn == null) {
                this.createColumnName(input, DEFAULT_ITEM_NAME);
                this.setTypeSelect(this.dataTypes[0]);
            } else {
                this.setName(this.bindingColumn.getName());
                this.setDisplayName(this.bindingColumn.getDisplayName());
                this.setTypeSelect(DATA_TYPE_CHOICE_SET.findChoice(this.bindingColumn.getDataType()).getDisplayName());
                this.setExpression(this.bindingColumn.getExpression());
                this.setAggregateOnSelect(this.bindingColumn.getAggregateOn());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    protected boolean isForceBinding() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        UIUtil.bindHelp(control, "org.eclipse.birt.cshelp.DataColumnBindingDialog_ID");
        return control;
    }
}

