/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportLibraryDialog
extends BaseDialog {
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String MSG_DIALOG_TITLE = Messages.getString((String)"ImportLibraryDialog.Title");
    private static final String MSG_DIALOG_MESSAGE = Messages.getString((String)"ImportLibraryAction.Message");
    private static final String MSG_DIALOG_NAMESPACE = Messages.getString((String)"ImportLibraryAction.Prefix");
    private static final String MSG_DIALOG_ERROR_CANNOT_BE_EMPTY = Messages.getString((String)"ImportLibraryAction.Error.CannotBeEmpty");
    private static final String MSG_DIALOG_ERROR_HAS_BEEN_USED = Messages.getString((String)"ImportLibraryAction.Error.HasBeenUsed");
    private static final String MSG_DIALOG_ERROR_HAS_DOT = Messages.getString((String)"ImportLibraryAction.Error.HasDot");
    private String namespace;
    private Text namespaceEditor;
    private CLabel messageLine;

    public ImportLibraryDialog(String namespace) {
        super(MSG_DIALOG_TITLE);
        this.namespace = namespace;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setText(MSG_DIALOG_MESSAGE);
        Composite inputArea = new Composite(composite, 0);
        inputArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        inputArea.setLayoutData((Object)new GridData(768));
        new Label(inputArea, 0).setText(MSG_DIALOG_NAMESPACE);
        this.namespaceEditor = new Text(inputArea, 2052);
        this.namespaceEditor.setLayoutData((Object)new GridData(768));
        this.namespaceEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportLibraryDialog.this.namespace = UIUtil.convertToModelString(ImportLibraryDialog.this.namespaceEditor.getText(), true);
                boolean canFinish = false;
                if (ImportLibraryDialog.this.namespace == null) {
                    ImportLibraryDialog.this.messageLine.setText(MSG_DIALOG_ERROR_CANNOT_BE_EMPTY);
                } else if (SessionHandleAdapter.getInstance().getReportDesignHandle().getLibrary(ImportLibraryDialog.this.namespace) != null) {
                    ImportLibraryDialog.this.messageLine.setText(MSG_DIALOG_ERROR_HAS_BEEN_USED);
                } else if (ImportLibraryDialog.this.namespace.indexOf(46) != -1) {
                    ImportLibraryDialog.this.messageLine.setText(MSG_DIALOG_ERROR_HAS_DOT);
                } else {
                    canFinish = true;
                    ImportLibraryDialog.this.messageLine.setText("");
                }
                if (canFinish) {
                    ImportLibraryDialog.this.messageLine.setImage(null);
                } else {
                    ImportLibraryDialog.this.messageLine.setImage(ERROR_ICON);
                }
                ImportLibraryDialog.this.getOkButton().setEnabled(canFinish);
            }
        });
        this.messageLine = new CLabel(composite, 0);
        this.messageLine.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected boolean initDialog() {
        this.namespaceEditor.setText(UIUtil.convertToGUIString(this.namespace));
        return true;
    }

    protected void okPressed() {
        this.setResult(this.namespace);
        super.okPressed();
    }
}

