/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectionChoiceDialog
extends BaseDialog {
    private Text labelEditor;
    private Text valueEditor;
    private SelectionChoice selectionChoice;
    private CLabel messageLine;
    private ISelectionChoiceValidator validator;

    public SelectionChoiceDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public SelectionChoiceDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    protected boolean initDialog() {
        Assert.isNotNull((Object)this.selectionChoice);
        this.labelEditor.setText(UIUtil.convertToGUIString(this.selectionChoice.getLabel()));
        this.valueEditor.setText(UIUtil.convertToGUIString(this.selectionChoice.getValue()));
        if (this.validator != null) {
            this.updateStatus();
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText("Display Text:");
        this.labelEditor = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.labelEditor.setLayoutData((Object)gd);
        new Label(composite, 0).setText("Value:");
        this.valueEditor = new Text(composite, 2048);
        this.valueEditor.setLayoutData((Object)new GridData(768));
        this.messageLine = new CLabel(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.messageLine.setLayoutData((Object)gd);
        if (this.validator != null) {
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectionChoiceDialog.this.updateStatus();
                }
            };
            this.labelEditor.addModifyListener(listener);
            this.valueEditor.addModifyListener(listener);
        }
        return composite;
    }

    protected void okPressed() {
        this.selectionChoice.setLabel(UIUtil.convertToModelString(this.labelEditor.getText(), false));
        this.selectionChoice.setValue(UIUtil.convertToModelString(this.valueEditor.getText(), false));
        this.setResult(this.selectionChoice);
        super.okPressed();
    }

    private void updateStatus() {
        String erroeMessage = this.validator.validate(UIUtil.convertToModelString(this.labelEditor.getText(), false), UIUtil.convertToModelString(this.valueEditor.getText(), false));
        if (erroeMessage != null) {
            this.messageLine.setText(erroeMessage);
            this.messageLine.setImage(ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK"));
            this.getOkButton().setEnabled(false);
        } else {
            this.messageLine.setText("");
            this.messageLine.setImage(null);
            this.getOkButton().setEnabled(true);
        }
    }

    public void setInput(SelectionChoice selectionChoice) {
        this.selectionChoice = selectionChoice;
    }

    public void setValidator(ISelectionChoiceValidator validator) {
        this.validator = validator;
    }

    public static interface ISelectionChoiceValidator {
        public String validate(String var1, String var2);
    }
}

