/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.net.URL;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ResourceFileLabelProvider
extends LabelProvider {
    private File rootFile = new File(this.getRootFilePath());
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

    private String getRootFilePath() {
        return ReportPlugin.getDefault().getResourcePreference();
    }

    public Image getImage(Object element) {
        if (element instanceof File) {
            if (((File)element).isDirectory()) {
                return IMG_FOLDER;
            }
            return IMG_FILE;
        }
        if (element instanceof ResourceEntry) {
            return ((ResourceEntry)element).getImage();
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof File) {
            if (element.equals(this.rootFile)) {
                String path = ((File)element).getPath();
                if (path == null || path.length() == 0) {
                    return "";
                }
                String retString = path.substring(path.lastIndexOf(File.separator) + 1);
                if (retString == null || retString.length() == 0) {
                    retString = path;
                }
                return retString;
            }
            return ((File)element).getName();
        }
        if (element instanceof ResourceEntry) {
            return ((ResourceEntry)element).getName();
        }
        return super.getText(element);
    }

    public String getToolTip(Object element) {
        if (element instanceof File) {
            if (element.equals(this.rootFile)) {
                return ((File)element).getAbsolutePath();
            }
            return ((File)element).getName();
        }
        if (element instanceof ResourceEntry) {
            URL url = ((ResourceEntry)element).getURL();
            if (url != null) {
                if (url.getPath().indexOf("/") == 0) {
                    return url.getPath().substring(1);
                }
                return url.getPath();
            }
            return "";
        }
        return super.getText(element);
    }
}

