/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;

public class TableCellSelectionHelper {
    public static Rectangle getSelectionRectangle(TableCellEditPart first, List selection) {
        Rectangle rect = new Rectangle();
        rect.x = first.getColumnNumber();
        rect.y = first.getRowNumber();
        int xdir = 0;
        int ydir = 0;
        int dx = rect.x + first.getColSpan() - 1;
        int dy = rect.y + first.getRowSpan() - 1;
        EditPart oparent = first.getParent();
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            TableCellEditPart sel;
            EditPart part = (EditPart)itr.next();
            if (!(part instanceof TableCellEditPart) || part.getParent() != oparent || (sel = (TableCellEditPart)part) == first) continue;
            if (xdir == 0) {
                if (sel.getColumnNumber() > rect.x) {
                    xdir = 1;
                    dx = sel.getColumnNumber();
                } else if (sel.getColumnNumber() < rect.x) {
                    xdir = -1;
                    dx = sel.getColumnNumber();
                }
            } else if (xdir > 0) {
                if (sel.getColumnNumber() > dx) {
                    dx = sel.getColumnNumber();
                } else if (sel.getColumnNumber() < rect.x) {
                    rect.x = sel.getColumnNumber();
                }
            } else if (xdir < 0) {
                if (sel.getColumnNumber() < dx) {
                    dx = sel.getColumnNumber();
                } else if (sel.getColumnNumber() > rect.x) {
                    rect.x = sel.getColumnNumber();
                }
            }
            if (ydir == 0) {
                if (sel.getRowNumber() > rect.y) {
                    ydir = 1;
                    dy = sel.getRowNumber();
                    continue;
                }
                if (sel.getRowNumber() >= rect.y) continue;
                ydir = -1;
                dy = sel.getRowNumber();
                continue;
            }
            if (ydir > 0) {
                if (sel.getRowNumber() > dy) {
                    dy = sel.getRowNumber();
                    continue;
                }
                if (sel.getRowNumber() >= rect.y) continue;
                rect.y = sel.getRowNumber();
                continue;
            }
            if (ydir >= 0) continue;
            if (sel.getRowNumber() < dy) {
                dy = sel.getRowNumber();
                continue;
            }
            if (sel.getRowNumber() <= rect.y) continue;
            rect.y = sel.getRowNumber();
        }
        rect.width = dx - rect.x;
        rect.height = dy - rect.y;
        return rect;
    }

    public static List getRectangleSelection(Rectangle rect, TableEditPart table) {
        ArrayList<TableCellEditPart> al = new ArrayList<TableCellEditPart>();
        int xstart = Math.min(rect.x, rect.x + rect.width);
        int xend = Math.max(rect.x, rect.x + rect.width);
        xstart = Math.max(1, xstart);
        xend = Math.min(table.getColumnCount(), xend);
        int ystart = Math.min(rect.y, rect.y + rect.height);
        int yend = Math.max(rect.y, rect.y + rect.height);
        ystart = Math.max(1, ystart);
        yend = Math.min(table.getRowCount(), yend);
        for (int i = xstart; i <= xend; ++i) {
            for (int j = ystart; j <= yend; ++j) {
                TableCellEditPart cell = table.getCell(j, i);
                if (al.contains((Object)cell)) continue;
                al.add(cell);
            }
        }
        return al;
    }

    public static boolean increaseSelectionRectangle(Rectangle rect, TableEditPart table) {
        Rectangle nRect = rect.getCopy();
        boolean refined = false;
        if (rect.width < 0) {
            for (int i = rect.x + rect.width; i <= rect.x; ++i) {
                boolean rlt;
                int j;
                if (rect.height < 0) {
                    for (j = rect.y + rect.height; j <= rect.y; ++j) {
                        rlt = TableCellSelectionHelper.checkAndIncreaseCellRectangle(table, j, i, nRect);
                        if (refined) continue;
                        refined = rlt;
                    }
                    continue;
                }
                for (j = rect.y; j <= rect.y + rect.height; ++j) {
                    rlt = TableCellSelectionHelper.checkAndIncreaseCellRectangle(table, j, i, nRect);
                    if (refined) continue;
                    refined = rlt;
                }
            }
        } else {
            for (int i = rect.x; i <= rect.x + rect.width; ++i) {
                boolean rlt;
                int j;
                if (rect.height < 0) {
                    for (j = rect.y + rect.height; j <= rect.y; ++j) {
                        rlt = TableCellSelectionHelper.checkAndIncreaseCellRectangle(table, j, i, nRect);
                        if (refined) continue;
                        refined = rlt;
                    }
                    continue;
                }
                for (j = rect.y; j <= rect.y + rect.height; ++j) {
                    rlt = TableCellSelectionHelper.checkAndIncreaseCellRectangle(table, j, i, nRect);
                    if (refined) continue;
                    refined = rlt;
                }
            }
        }
        rect.x = nRect.x;
        rect.y = nRect.y;
        rect.width = nRect.width;
        rect.height = nRect.height;
        return refined;
    }

    private static boolean checkAndIncreaseCellRectangle(TableEditPart table, int rowNumber, int columnNumber, Rectangle constraint) {
        boolean refined = false;
        if (rowNumber < 1 || rowNumber > table.getRowCount() || columnNumber < 1 || columnNumber > table.getColumnCount()) {
            return false;
        }
        TableCellEditPart cell = table.getCell(rowNumber, columnNumber);
        Point pt = new Point(cell.getColumnNumber() + cell.getColSpan() - 1, cell.getRowNumber());
        if (pt.x < 1) {
            pt.x = 1;
        }
        if (pt.x > table.getColumnCount()) {
            pt.x = table.getColumnCount();
        }
        refined = TableCellSelectionHelper.incResizeRectangle(constraint, pt);
        pt = new Point(cell.getColumnNumber(), cell.getRowNumber() + cell.getRowSpan() - 1);
        if (pt.y < 1) {
            pt.y = 1;
        }
        if (pt.y > table.getRowCount()) {
            pt.y = table.getRowCount();
        }
        boolean rlt = TableCellSelectionHelper.incResizeRectangle(constraint, pt);
        if (!refined) {
            refined = rlt;
        }
        return refined;
    }

    private static boolean incResizeRectangle(Rectangle rect, Point pt) {
        boolean resized = false;
        if (!TableCellSelectionHelper.isRectContains(rect, pt)) {
            if (rect.width < 0) {
                if (pt.x < rect.x + rect.width) {
                    rect.width = pt.x - rect.x;
                    resized = true;
                } else if (pt.x > rect.x) {
                    rect.width -= pt.x - rect.x;
                    rect.x = pt.x;
                    resized = true;
                }
            } else if (pt.x < rect.x) {
                rect.width += rect.x - pt.x;
                rect.x = pt.x;
                resized = true;
            } else if (pt.x > rect.x + rect.width) {
                rect.width = pt.x - rect.x;
                resized = true;
            }
            if (rect.height < 0) {
                if (pt.y < rect.y + rect.height) {
                    rect.height = pt.y - rect.y;
                    resized = true;
                } else if (pt.y > rect.y) {
                    rect.height -= pt.y - rect.y;
                    rect.y = pt.y;
                    resized = true;
                }
            } else if (pt.y < rect.y) {
                rect.height += rect.y - pt.y;
                rect.y = pt.y;
                resized = true;
            } else if (pt.y > rect.y + rect.height) {
                rect.height = pt.y - rect.y;
                resized = true;
            }
        }
        return resized;
    }

    public static boolean decreaseSelectionRectangle(Rectangle rect, TableEditPart table, int direction) {
        Rectangle nRect = rect.getCopy();
        boolean decreased = false;
        if (rect.width < 0) {
            for (int i = rect.x + rect.width; i <= rect.x; ++i) {
                boolean rlt;
                int j;
                if (rect.height < 0) {
                    for (j = rect.y + rect.height; j <= rect.y; ++j) {
                        rlt = TableCellSelectionHelper.checkAndDecreaseCellRectangle(table, j, i, nRect, direction);
                        if (decreased) continue;
                        decreased = rlt;
                    }
                    continue;
                }
                for (j = rect.y; j <= rect.y + rect.height; ++j) {
                    rlt = TableCellSelectionHelper.checkAndDecreaseCellRectangle(table, j, i, nRect, direction);
                    if (decreased) continue;
                    decreased = rlt;
                }
            }
        } else {
            for (int i = rect.x; i <= rect.x + rect.width; ++i) {
                boolean rlt;
                int j;
                if (rect.height < 0) {
                    for (j = rect.y + rect.height; j <= rect.y; ++j) {
                        rlt = TableCellSelectionHelper.checkAndDecreaseCellRectangle(table, j, i, nRect, direction);
                        if (decreased) continue;
                        decreased = rlt;
                    }
                    continue;
                }
                for (j = rect.y; j <= rect.y + rect.height; ++j) {
                    rlt = TableCellSelectionHelper.checkAndDecreaseCellRectangle(table, j, i, nRect, direction);
                    if (decreased) continue;
                    decreased = rlt;
                }
            }
        }
        rect.x = nRect.x;
        rect.y = nRect.y;
        rect.width = nRect.width;
        rect.height = nRect.height;
        return decreased;
    }

    private static boolean checkAndDecreaseCellRectangle(TableEditPart table, int rowNumber, int columnNumber, Rectangle constraint, int direction) {
        if (rowNumber < 1 || rowNumber > table.getRowCount() || columnNumber < 1 || columnNumber > table.getColumnCount()) {
            return false;
        }
        TableCellEditPart cell = table.getCell(rowNumber, columnNumber);
        Point pt1 = new Point(cell.getColumnNumber() + cell.getColSpan() - 1, cell.getRowNumber());
        if (pt1.x < 1) {
            pt1.x = 1;
        }
        if (pt1.x > table.getColumnCount()) {
            pt1.x = table.getColumnCount();
        }
        Point pt2 = new Point(cell.getColumnNumber(), cell.getRowNumber() + cell.getRowSpan() - 1);
        if (pt2.y < 1) {
            pt2.y = 1;
        }
        if (pt2.y > table.getRowCount()) {
            pt2.y = table.getRowCount();
        }
        return TableCellSelectionHelper.decResizeRectangle(constraint, pt1, pt2, direction);
    }

    private static boolean decResizeRectangle(Rectangle rect, Point pt1, Point pt2, int direction) {
        boolean con2;
        boolean resized = false;
        boolean con1 = TableCellSelectionHelper.isRectContains(rect, pt1);
        if (con1 ^ (con2 = TableCellSelectionHelper.isRectContains(rect, pt2))) {
            if (con2) {
                Point tmp = pt1.getCopy();
                pt1 = pt2;
                pt2 = tmp;
            }
            if (direction == 8 || direction == 16) {
                boolean rlt = TableCellSelectionHelper.decAdjustWidth(rect, pt1, pt2);
                if (rlt) {
                    resized = true;
                }
                if ((con1 = TableCellSelectionHelper.isRectContains(rect, pt1)) ^ (con2 = TableCellSelectionHelper.isRectContains(rect, pt2)) && (rlt = TableCellSelectionHelper.decAdjustHeight(rect, pt1, pt2))) {
                    resized = true;
                }
            } else {
                boolean rlt = TableCellSelectionHelper.decAdjustHeight(rect, pt1, pt2);
                if (rlt) {
                    resized = true;
                }
                if ((con1 = TableCellSelectionHelper.isRectContains(rect, pt1)) ^ (con2 = TableCellSelectionHelper.isRectContains(rect, pt2)) && (rlt = TableCellSelectionHelper.decAdjustWidth(rect, pt1, pt2))) {
                    resized = true;
                }
            }
        }
        return resized;
    }

    private static boolean decAdjustWidth(Rectangle rect, Point pt1, Point pt2) {
        boolean resized = false;
        if (rect.width < 0) {
            if (pt1.x < pt2.x) {
                rect.width += rect.x - pt1.x + 1;
                rect.x = pt1.x - 1;
                resized = true;
            } else if (pt1.x > pt2.x) {
                rect.width = pt1.x - rect.x + 1;
                resized = true;
            }
        } else if (rect.width > 0) {
            if (pt1.x < pt2.x) {
                rect.width = pt1.x - rect.x - 1;
                resized = true;
            } else if (pt1.x > pt2.x) {
                rect.width -= pt1.x - rect.x + 1;
                rect.x = pt1.x + 1;
                resized = true;
            }
        }
        return resized;
    }

    private static boolean decAdjustHeight(Rectangle rect, Point pt1, Point pt2) {
        boolean resized = false;
        if (rect.height < 0) {
            if (pt1.y < pt2.y) {
                rect.height += rect.y - pt1.y + 1;
                rect.y = pt1.y - 1;
                resized = true;
            } else if (pt1.y > pt2.y) {
                rect.height = pt1.y - rect.y + 1;
                resized = true;
            }
        } else if (rect.height > 0) {
            if (pt1.y < pt2.y) {
                rect.height = pt1.y - rect.y - 1;
                resized = true;
            } else if (pt1.y > pt2.y) {
                rect.height -= pt1.y - rect.y + 1;
                rect.y = pt1.y + 1;
                resized = true;
            }
        }
        return resized;
    }

    private static boolean isRectContains(Rectangle rect, Point pt) {
        if (rect.width < 0 ? pt.x < rect.x + rect.width || pt.x > rect.x : pt.x < rect.x || pt.x > rect.x + rect.width) {
            return false;
        }
        return !(rect.height < 0 ? pt.y < rect.y + rect.height || pt.y > rect.y : pt.y < rect.y || pt.y > rect.y + rect.height);
    }
}

