/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventFilter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ListenerElementVisitor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;

public class ModelEventManager
implements Listener {
    private boolean isPost = false;
    private List listenerList = new ArrayList();
    private ListenerElementVisitor visitor;
    private Object root;
    private ActivityStackListener commandStackListener = new ActivityStackListener(){

        public void stackChanged(ActivityStackEvent event) {
            ModelEventManager.this.postEvent(event);
        }
    };
    static /* synthetic */ Class class$org$eclipse$birt$report$designer$internal$ui$editors$parts$event$IModelEventFilter;

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        ArrayList temp = new ArrayList(this.listenerList);
        int size = temp.size();
        for (int i = 0; i < size; ++i) {
            IModelEventProcessor processor = (IModelEventProcessor)temp.get(i);
            if (processor instanceof IFastConsumerProcessor && ((IFastConsumerProcessor)processor).isOverdued()) {
                this.listenerList.remove(processor);
                continue;
            }
            Object filter = processor.getAdapter(class$org$eclipse$birt$report$designer$internal$ui$editors$parts$event$IModelEventFilter == null ? ModelEventManager.class$("org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventFilter") : class$org$eclipse$birt$report$designer$internal$ui$editors$parts$event$IModelEventFilter);
            if (filter instanceof IModelEventFilter && ((IModelEventFilter)filter).filterModelEvent(focus, ev)) {
                return;
            }
            processor.addElementEvent(focus, ev);
        }
        this.getListenerElementVisitor().addListener(focus);
    }

    private void postEvent(ActivityStackEvent event) {
        this.checkStatus();
        switch (event.getAction()) {
            case 1: 
            case 2: 
            case 3: {
                this.postModelEvent();
                break;
            }
            case 4: {
                this.clearEvent();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postModelEvent() {
        try {
            this.isPost = true;
            int size = this.listenerList.size();
            for (int i = 0; i < size; ++i) {
                IModelEventProcessor processor = (IModelEventProcessor)this.listenerList.get(i);
                processor.postElementEvent();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        finally {
            this.isPost = false;
        }
    }

    protected void clearEvent() {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            IModelEventProcessor processor = (IModelEventProcessor)this.listenerList.get(i);
            processor.clear();
        }
    }

    private void checkStatus() {
        if (this.isPost) {
            throw new RuntimeException("The event is post now");
        }
    }

    public void addModelEventProcessor(IModelEventProcessor processor) {
        if (!this.listenerList.contains(processor)) {
            this.listenerList.add(processor);
        }
    }

    public void removeModelEventProcessor(IModelEventProcessor processor) {
        this.listenerList.remove(processor);
    }

    public void dispose() {
        this.listenerList.clear();
        if (this.root instanceof DesignElementHandle) {
            this.visitor.removeListener((DesignElementHandle)this.root);
        }
        this.root = null;
        this.visitor = null;
    }

    private ListenerElementVisitor getListenerElementVisitor() {
        if (this.visitor == null) {
            this.visitor = new ListenerElementVisitor(this);
        }
        return this.visitor;
    }

    public void hookCommandStack(WrapperCommandStack stack) {
        stack.addCommandStackListener(this.commandStackListener);
    }

    public void unhookCommandStack(WrapperCommandStack stack) {
        stack.removeCommandStackListener(this.commandStackListener);
    }

    public void hookRoot(Object obj) {
        if (this.root == obj) {
            return;
        }
        this.unhookRoot(this.root);
        if (obj instanceof DesignElementHandle) {
            this.getListenerElementVisitor().addListener((DesignElementHandle)((DesignElementHandle)obj).getModuleHandle());
        }
        this.root = obj;
    }

    public void unhookRoot(Object obj) {
        if (obj instanceof DesignElementHandle) {
            this.getListenerElementVisitor().removeListener((DesignElementHandle)obj);
        }
    }
}

