/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;

public class DeleteGroupAction
extends MenuUpdateAction.DynamicItemAction {
    private static final String STACK_MSG_DELETE_GROUP = Messages.getString((String)"DeleteGroupAction.stackMsg.deleteGroup");
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.DeleteGroupAction";
    private GroupHandle handle;
    private ReportElementEditPart editPart;

    public DeleteGroupAction(ReportElementEditPart editPart, GroupHandle handle) {
        this.handle = handle;
        this.editPart = editPart;
        this.setId(ID);
        this.setText(DEUtil.getEscapedMenuItemText((String)handle.getDisplayLabel()));
    }

    public boolean isEnabled() {
        return this.handle.canDrop();
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Delete group action >> Run ...");
        }
        CommandStack stack = this.getActiveCommandStack();
        stack.startTrans(STACK_MSG_DELETE_GROUP);
        if (this.handle.canDrop()) {
            EditPartViewer viewer = this.editPart.getViewer();
            try {
                this.handle.drop();
                stack.commit();
            }
            catch (SemanticException e) {
                stack.rollbackAll();
                ExceptionHandler.handle(e);
            }
            viewer.select((EditPart)this.editPart);
        }
    }

    protected CommandStack getActiveCommandStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }
}

