/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.DataBindingDialog;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class EditBindingAction
extends InsertRowAction {
    public static final String ID = "org.eclipse.birt.report.designer.action.editBinding";

    public EditBindingAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.getString((String)"DesignerActionBarContributor.menu.element.editDataBinding"));
    }

    protected boolean calculateEnabled() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        return moduleHandle != null && (!moduleHandle.getVisibleDataSets().isEmpty() || this.getSelectedElement() != null && this.getSelectedElement().getDataSet() != null);
    }

    private ReportItemHandle getSelectedElement() {
        if (this.getTableEditPart() != null && this.getTableEditPart().getModel() instanceof ReportItemHandle) {
            return (ReportItemHandle)this.getTableEditPart().getModel();
        }
        if (this.getListEditPart() != null && this.getListEditPart().getModel() instanceof ReportItemHandle) {
            return (ReportItemHandle)this.getListEditPart().getModel();
        }
        return null;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Edit binding action >> Run ...");
        }
        TableEditPart editPart = this.getTableEditPart();
        ListEditPart listPart = this.getListEditPart();
        if (editPart != null || listPart != null) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"DesignerActionBarContributor.menu.element.editDataBinding"));
            DataBindingDialog dialog = new DataBindingDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (DesignElementHandle)this.getSelectedElement());
            if (dialog.open() == 0) {
                stack.commit();
            } else {
                stack.rollback();
            }
        }
    }
}

