/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.jface.action.Action;

public class InsertGroupHeaderFooterAction
extends Action {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupHeaderFooterAction";
    protected GroupHandle handle;
    public static final int HEADER = 1;
    public static final int FOOTER = 2;
    public static final String INSERT_HEADER_TEXT = Messages.getString((String)"InsertGroupHeaderFooterAction.Text.Header");
    public static final String INSERT_FOOTER_TEXT = Messages.getString((String)"InsertGroupHeaderFooterAction.Text.Footer");
    private SlotHandle slotHandle;
    private InsertAction insertAction;

    public InsertGroupHeaderFooterAction(GroupHandle grouphandle, int type) {
        this.setId(ID);
        this.handle = grouphandle;
        if (this.handle == null) {
            this.slotHandle = null;
            this.setText(Messages.getString((String)"NoneAction.text"));
            return;
        }
        switch (type) {
            case 1: {
                this.slotHandle = this.handle.getHeader();
                this.setText(INSERT_HEADER_TEXT);
                break;
            }
            case 2: {
                this.slotHandle = this.handle.getFooter();
                this.setText(INSERT_FOOTER_TEXT);
                break;
            }
            default: {
                this.slotHandle = null;
            }
        }
    }

    public boolean isEnabled() {
        ReportElementModel model;
        if (this.handle == null || this.slotHandle == null) {
            return false;
        }
        if (this.slotHandle.canContain("Row") && ((ReportElementHandle)(model = new ReportElementModel(this.slotHandle)).getElementHandle()).isValidReferenceForCompoundElement()) {
            this.insertAction = new InsertAction(model, "", "Row");
            return this.insertAction.isEnabled();
        }
        return false;
    }

    public void run() {
        if (this.insertAction != null) {
            this.insertAction.run();
        }
    }
}

