/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportDesignHandleAdapter;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class ReportElementEditPart
extends AbstractGraphicalEditPart
implements IModelAdapterHelper {
    private static final int DELAY_TIME = 1600;
    private DesignElementHandleAdapter peer;
    private AbstractGuideHandle guideHandle = null;
    private boolean isEdited = false;
    private boolean isDirty = true;

    public ReportElementEditPart(Object model) {
        if (Policy.TRACING_EDITPART_CREATE) {
            String[] result = ((Object)((Object)this)).getClass().getName().split("\\.");
            System.out.println(result[result.length - 1] + " >> Created for " + model);
        }
        this.setModel(model);
        this.peer = this.creatDesignElementHandleAdapter();
    }

    public DesignElementHandleAdapter creatDesignElementHandleAdapter() {
        HandleAdapterFactory.getInstance().remove(this.getModel());
        return HandleAdapterFactory.getInstance().getDesignElementHandleAdapter(this.getModel(), (IModelAdapterHelper)this);
    }

    public void performRequest(Request request) {
        if ("open".equals(request.getType()) || "create element".equals(request.getType())) {
            if (this.isEdited()) {
                return;
            }
            this.setEdited(true);
            this.performDirectEdit();
            this.setEdited(false);
        }
    }

    public void performDirectEdit() {
    }

    protected boolean isEdited() {
        return this.isEdited;
    }

    protected void setEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    protected AbstractGuideHandle createGuideHandle() {
        EditPart part = this.getParent();
        if (part instanceof ReportElementEditPart) {
            return ((ReportElementEditPart)part).getGuideHandle();
        }
        return null;
    }

    protected AbstractGuideHandle getGuideHandle() {
        if (this.guideHandle == null) {
            this.guideHandle = this.createGuideHandle();
        }
        return this.guideHandle;
    }

    public void addGuideFeedBack() {
        if (this.guideHandle == null) {
            this.guideHandle = this.createGuideHandle();
        }
        if (this.guideHandle != null && this.guideHandle != this.findHandle()) {
            this.clearGuideHandle();
            this.getHandleLayer().add((IFigure)this.guideHandle);
            this.guideHandle.invalidate();
            this.guideHandle.setCanDeleteGuide(true);
        } else if (this.guideHandle != null && this.guideHandle == this.findHandle()) {
            this.guideHandle.setCanDeleteGuide(false);
        } else if (this.guideHandle != null) {
            this.guideHandle.setCanDeleteGuide(true);
        }
    }

    private AbstractGuideHandle findHandle() {
        IFigure layer = this.getHandleLayer();
        List list = layer.getChildren();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof AbstractGuideHandle)) continue;
            return (AbstractGuideHandle)((Object)obj);
        }
        return null;
    }

    private void clearGuideHandle() {
        int i;
        IFigure layer = this.getHandleLayer();
        List list = layer.getChildren();
        ArrayList temp = new ArrayList();
        int size = list.size();
        for (i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof AbstractGuideHandle)) continue;
            temp.add(obj);
        }
        size = temp.size();
        for (i = 0; i < size; ++i) {
            IFigure figure = (IFigure)temp.get(i);
            layer.remove(figure);
        }
    }

    protected void removeGuideFeedBack() {
        if (this.guideHandle != null && this.guideHandle.getParent() == this.getHandleLayer()) {
            this.getHandleLayer().remove((IFigure)this.guideHandle);
        }
        this.guideHandle = null;
    }

    public void delayRemoveGuideFeedBack() {
        if (this.guideHandle != null) {
            this.guideHandle.setCanDeleteGuide(true);
        }
        Display.getCurrent().timerExec(1600, new Runnable(){

            public void run() {
                if (ReportElementEditPart.this.guideHandle != null && ReportElementEditPart.this.guideHandle.isCanDeleteGuide()) {
                    ReportElementEditPart.this.removeGuideFeedBack();
                }
            }
        });
    }

    private IFigure getHandleLayer() {
        super.getLayer((Object)"Handle Layer");
        LayerManager manager = (LayerManager)this.getViewer().getEditPartRegistry().get(LayerManager.ID);
        return manager.getLayer((Object)"Handle Layer");
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.refreshPageClip();
        this.getFigure().addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }

            public void mouseExited(MouseEvent me) {
                ReportElementEditPart.this.delayRemoveGuideFeedBack();
            }

            public void mouseHover(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }

            public void mouseMoved(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }
        });
        this.getFigure().setFocusTraversable(true);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeGuideFeedBack();
        super.deactivate();
        HandleAdapterFactory.getInstance().remove(this.getModel());
    }

    protected abstract void createEditPolicies();

    public DragTracker getDragTracker(Request req) {
        DragEditPartsTracker track = new DragEditPartsTracker((EditPart)this){

            protected boolean handleButtonDown(int button) {
                if (this.getCurrentViewer() instanceof DeferredGraphicalViewer) {
                    ((DeferredGraphicalViewer)this.getCurrentViewer()).initStepDat();
                }
                return super.handleButtonDown(button);
            }
        };
        return track;
    }

    public Rectangle getBounds() {
        return this.getReportElementHandleAdapt().getbounds();
    }

    public void setBounds(Rectangle r) {
        try {
            this.getReportElementHandleAdapt().setBounds(r);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Point getLocation() {
        return this.getReportElementHandleAdapt().getLocation();
    }

    public void setLocation(Point p) {
        try {
            this.getReportElementHandleAdapt().setLocation(p);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Dimension getSize() {
        return this.getReportElementHandleAdapt().getSize();
    }

    public void setSize(Dimension d) {
        try {
            this.getReportElementHandleAdapt().setSize(d);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    protected Font getFont(ReportItemHandle handle) {
        StyleHandle styleHandle = handle.getPrivateStyle();
        String family = (String)styleHandle.getFontFamilyHandle().getValue();
        String FontFamily = (String)DesignerConstants.familyMap.get(family = DEUtil.RemoveQuote((String)family));
        if (FontFamily == null) {
            FontFamily = family;
        }
        int fontSize = DEUtil.getFontSizeIntValue((DesignElementHandle)handle);
        int fontStyle = 0;
        String fontWeight = styleHandle.getFontWeight();
        String style = styleHandle.getFontStyle();
        if (fontWeight.equals("bold") || fontWeight.equals("bolder") || fontWeight.equals("700") || fontWeight.equals("800") || fontWeight.equals("900")) {
            fontStyle |= 1;
        }
        if (style.equals("italic") || style.equals("oblique")) {
            fontStyle |= 2;
        }
        Font font = FontManager.getFont((String)FontFamily, (int)fontSize, (int)fontStyle);
        return font;
    }

    protected Font getFont() {
        return this.getFont((ReportItemHandle)this.getModel());
    }

    public String getDisplayLabel() {
        return null;
    }

    public final void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFigure();
        this.refreshReportChildren(this);
        this.getFigure().repaint();
    }

    public void refreshChildren() {
        super.refreshChildren();
    }

    public void refreshReportChildren(ReportElementEditPart parent) {
        List list = parent.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Object part = list.get(i);
            if (!(part instanceof ReportElementEditPart) || ((ReportElementEditPart)((Object)part)).isDelete()) continue;
            ((ReportElementEditPart)((Object)part)).refreshFigure();
            this.refreshReportChildren((ReportElementEditPart)((Object)part));
        }
    }

    public abstract void refreshFigure();

    protected void refreshMargin() {
        if (this.getFigure() instanceof IReportElementFigure) {
            ((IReportElementFigure)this.getFigure()).setMargin(this.getModelAdapter().getMargin(null));
        }
    }

    protected void refreshBackground(DesignElementHandle handle) {
        this.refreshBackgroundColor(handle);
        this.refreshBackgroundImage(handle);
    }

    protected void refreshBackgroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("backgroundColor");
        if (handle instanceof MasterPageHandle) {
            this.getFigure().setOpaque(true);
        } else {
            this.getFigure().setOpaque(false);
        }
        if (obj != null) {
            int color = 0xFFFFFF;
            color = obj instanceof String ? ColorUtil.parseColor((String)((String)obj)) : (Integer)obj;
            this.getFigure().setBackgroundColor(ColorManager.getColor((int)color));
            this.getFigure().setOpaque(true);
        }
    }

    protected void refreshBackgroundImage(DesignElementHandle handle) {
        IReportElementFigure figure = (IReportElementFigure)this.getFigure();
        String backGroundImage = this.getBackgroundImage(handle);
        Object backGroundPosition = this.getBackgroundPosition(handle);
        int backGroundRepeat = this.getBackgroundRepeat(handle);
        if (backGroundImage == null) {
            figure.setImage(null);
        } else {
            Image image = null;
            try {
                image = ImageManager.getInstance().getImage(backGroundImage);
            }
            catch (SWTException e) {
                image = null;
            }
            if (image == null) {
                figure.setImage(null);
                return;
            }
            figure.setImage(image);
            figure.setRepeat(backGroundRepeat);
            if (backGroundPosition instanceof int[]) {
                figure.setAlignment(((int[])backGroundPosition)[0] | ((int[])backGroundPosition)[1]);
                figure.setPosition(new Point(-1, -1));
            } else if (backGroundPosition instanceof Point) {
                figure.setPosition((Point)backGroundPosition);
            } else if (backGroundPosition instanceof DimensionValue[]) {
                int percentX = (int)((DimensionValue[])backGroundPosition)[0].getMeasure();
                int percentY = (int)((DimensionValue[])backGroundPosition)[1].getMeasure();
                Rectangle area = this.getFigure().getClientArea();
                org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
                int x = (area.width - imageArea.width) * percentX / 100;
                int y = (area.height - imageArea.height) * percentY / 100;
                figure.setPosition(new Point(x, y));
            }
        }
    }

    public void markDirty(boolean bool) {
        this.isDirty = bool;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected DesignElementHandleAdapter getModelAdapter() {
        return this.peer;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getFigure().getSize().getCopy();
        return size;
    }

    public Insets getInsets() {
        return new Insets(this.getFigure().getInsets());
    }

    protected ReportItemtHandleAdapter getReportElementHandleAdapt() {
        return (ReportItemtHandleAdapter)this.getModelAdapter();
    }

    protected void refreshPageClip() {
        Object obj;
        if (this.getFigure() instanceof ReportElementFigure && (obj = this.getViewer().getProperty("Layout Size")) instanceof Rectangle) {
            ((ReportElementFigure)this.getFigure()).setPageClip((Rectangle)obj);
        }
    }

    protected void updateBaseBorder(DesignElementHandle handle, BaseBorder border) {
        border.bottomColor = handle.getPropertyHandle("borderBottomColor").getStringValue();
        border.bottomStyle = handle.getPropertyHandle("borderBottomStyle").getStringValue();
        border.bottomWidth = handle.getPropertyHandle("borderBottomWidth").getStringValue();
        border.topColor = handle.getPropertyHandle("borderTopColor").getStringValue();
        border.topStyle = handle.getPropertyHandle("borderTopStyle").getStringValue();
        border.topWidth = handle.getPropertyHandle("borderTopWidth").getStringValue();
        border.leftColor = handle.getPropertyHandle("borderLeftColor").getStringValue();
        border.leftStyle = handle.getPropertyHandle("borderLeftStyle").getStringValue();
        border.leftWidth = handle.getPropertyHandle("borderLeftWidth").getStringValue();
        border.rightColor = handle.getPropertyHandle("borderRightColor").getStringValue();
        border.rightStyle = handle.getPropertyHandle("borderRightStyle").getStringValue();
        border.rightWidth = handle.getPropertyHandle("borderRightWidth").getStringValue();
    }

    protected void refreshBorder(DesignElementHandle handle, BaseBorder border) {
        this.updateBaseBorder(handle, border);
        this.getFigure().setBorder((Border)border);
        this.refreshPageClip();
    }

    protected Insets getMasterPageInsets(DesignElementHandle handle) {
        return ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPageInsets(handle);
    }

    protected Dimension getMasterPageSize(DesignElementHandle handle) {
        return ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPageSize(handle);
    }

    protected int getForegroundColor(DesignElementHandle handle) {
        return this.getModelAdapter().getForegroundColor(handle);
    }

    protected int getBackgroundColor(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundColor(handle);
    }

    protected String getBackgroundImage(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundImage(handle);
    }

    protected Object getBackgroundPosition(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundPosition(handle);
    }

    protected int getBackgroundRepeat(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundRepeat(handle);
    }

    protected boolean isFigureLeft(Request request) {
        if (!(request instanceof SelectionRequest)) {
            return true;
        }
        SelectionRequest selctionRequest = (SelectionRequest)request;
        Point p = selctionRequest.getLocation();
        this.getFigure().translateToRelative((Translatable)p);
        Point center = this.getFigure().getBounds().getCenter();
        return center.x >= p.x;
    }

    public boolean isDelete() {
        boolean bool = false;
        if (this.getModel() instanceof DesignElementHandle && !(this.getModel() instanceof ModuleHandle)) {
            bool = ((DesignElementHandle)this.getModel()).getContainer() == null || ((DesignElementHandle)this.getModel()).getRoot() == null;
        }
        return bool;
    }

    public void notifyModelChange() {
        if (this.getParent() != null && this.getParent() instanceof ReportElementEditPart) {
            ((ReportElementEditPart)this.getParent()).notifyModelChange();
        }
    }

    protected void contentChange(Map info) {
        this.markDirty(true);
        this.refresh();
    }

    protected void propertyChange(Map info) {
        this.refreshVisuals();
    }

    public boolean isinterest(Object model) {
        return this.getModel().equals(model);
    }
}

