/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.CellBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.CellFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.CellDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;

public class TableCellEditPart
extends ReportElementEditPart {
    public TableCellEditPart(Object obj) {
        super(obj);
    }

    protected List getModelChildren() {
        return this.getCellAdapter().getChildren();
    }

    protected IFigure createFigure() {
        CellFigure figure = new CellFigure();
        ReportFlowLayout rflayout = new ReportFlowLayout();
        figure.setLayoutManager((LayoutManager)rflayout);
        figure.setOpaque(false);
        return figure;
    }

    protected Dimension getCellDimension() {
        int h = 0;
        int w = 0;
        TableEditPart tablePart = (TableEditPart)this.getParent();
        int rNumber = this.getRowNumber();
        int cNumber = this.getColumnNumber();
        if (rNumber > 0 && cNumber > 0) {
            for (int i = rNumber; i < rNumber + this.getRowSpan(); ++i) {
                h += tablePart.caleVisualHeight(i);
            }
            for (int j = cNumber; j < cNumber + this.getColSpan(); ++j) {
                w += tablePart.caleVisualWidth(j);
            }
        }
        return new Dimension(w, h);
    }

    public void refreshFigure() {
        CellBorder cborder = new CellBorder();
        if (this.getFigure().getBorder() instanceof CellBorder) {
            cborder.setBorderInsets(((CellBorder)this.getFigure().getBorder()).getBorderInsets());
        }
        this.refreshBorder(this.getCellAdapter().getHandle(), cborder);
        Insets ist = this.getCellAdapter().getPadding(this.getFigure().getInsets());
        ((CellBorder)this.getFigure().getBorder()).setPaddingInsets(ist);
        StyleHandle style = ((CellHandle)this.getModel()).getPrivateStyle();
        String hAlign = style.getTextAlign();
        String vAlign = style.getVerticalAlign();
        ReportFlowLayout rflayout = (ReportFlowLayout)this.getFigure().getLayoutManager();
        if ("center".equals(hAlign)) {
            rflayout.setMajorAlignment(0);
        } else if ("right".equals(hAlign)) {
            rflayout.setMajorAlignment(2);
        } else {
            rflayout.setMajorAlignment(1);
        }
        if ("middle".equals(vAlign)) {
            rflayout.setMinorAlignment(0);
        } else if ("bottom".equals(vAlign)) {
            rflayout.setMinorAlignment(2);
        } else {
            rflayout.setMinorAlignment(1);
        }
        rflayout.layout(this.getFigure());
        this.updateBlankString();
        this.refreshBackground((DesignElementHandle)this.getModel());
    }

    public void updateBlankString() {
        if (this.getModelChildren().size() == 0) {
            TableHandleAdapter tha = ((TableEditPart)this.getParent()).getTableAdapter();
            if (1 == this.getColumnNumber()) {
                RowHandleAdapter rha = HandleAdapterFactory.getInstance().getRowHandleAdapter(tha.getRow(this.getRowNumber()));
                ((CellFigure)this.getFigure()).setBlankString(rha.getTypeString());
            } else {
                ((CellFigure)this.getFigure()).setBlankString(null);
            }
        } else {
            ((CellFigure)this.getFigure()).setBlankString(null);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        return new CellDragTracker((EditPart)this);
    }

    public IFigure getLayer(Object key) {
        if (this.getParent() instanceof TableEditPart) {
            return ((TableEditPart)this.getParent()).getLayer(key);
        }
        return super.getLayer(key);
    }

    public int getRowNumber() {
        return this.getCellAdapter().getRowNumber();
    }

    public int getColumnNumber() {
        return this.getCellAdapter().getColumnNumber();
    }

    public int getColSpan() {
        return this.getCellAdapter().getColumnSpan();
    }

    public void setColumnSpan(int colSpan) {
        try {
            this.getCellAdapter().setColumnSpan(colSpan);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public int getRowSpan() {
        return this.getCellAdapter().getRowSpan();
    }

    public void setRowSpan(int rowSpan) {
        try {
            this.getCellAdapter().setRowSpan(rowSpan);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        return super.getTargetEditPart(request);
    }

    public Rectangle getBounds() {
        return this.getFigure().getBounds();
    }

    protected CellHandleAdapter getCellAdapter() {
        return (CellHandleAdapter)this.getModelAdapter();
    }

    public void showTargetFeedback(Request request) {
        if (this.getSelected() == 0 && this.isActive() && request.getType() == "selection") {
            if (this.isFigureLeft(request)) {
                this.getViewer().setCursor(ReportPlugin.getDefault().getLeftCellCursor());
            } else {
                this.getViewer().setCursor(ReportPlugin.getDefault().getRightCellCursor());
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getViewer().setCursor(null);
        }
        super.eraseTargetFeedback(request);
    }

    protected void addChildVisual(EditPart part, int index) {
        this.getViewer().setCursor(null);
        super.addChildVisual(part, index);
    }
}

