/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TextFigure;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.ui.PlatformUI;

public class TextDataEditPart
extends LabelEditPart {
    private static final String FIGURE_DEFAULT_TEXT = Messages.getString((String)"TextDataEditPart.Figure.Dafault");

    public TextDataEditPart(Object model) {
        super(model);
    }

    public void performDirectEdit() {
        TextDataHandle handle = (TextDataHandle)this.getModel();
        ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), handle.getValueExpr());
        dialog.setExpressionProvier(new ExpressionProvider((DesignElementHandle)handle));
        if (dialog.open() == 0) {
            try {
                ((TextDataHandle)this.getModel()).setValueExpr(dialog.getResult());
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                return;
            }
            this.refreshVisuals();
        }
    }

    protected String getText() {
        TextDataHandle handle = (TextDataHandle)this.getModel();
        String text = handle.getValueExpr();
        if (text == null || text.length() == 0) {
            text = FIGURE_DEFAULT_TEXT;
        }
        return text;
    }

    protected boolean hasText() {
        return !StringUtil.isBlank((String)((TextDataHandle)this.getModel()).getValueExpr());
    }

    protected IFigure createFigure() {
        TextFigure text = new TextFigure();
        return text;
    }

    public void refreshFigure() {
        super.refreshFigure();
        ((LabelFigure)this.getFigure()).setToolTipText(((TextDataHandle)this.getModel()).getValueExpr());
    }
}

