/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Cursor;

public class ColumnDragTracker
extends TableDragGuideTracker {
    public ColumnDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZEWE);
    }

    protected void resize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getLocation().x - this.getStartLocation().x;
        if (this.getStart() != this.getEnd()) {
            value = this.getTrueValue(value);
            part.resizeColumn(this.getStart(), this.getEnd(), value);
        } else {
            Dimension dimension = this.getDragWidth();
            if (value < dimension.width) {
                value = dimension.width;
            }
            TableHandleAdapter adp = HandleAdapterFactory.getInstance().getTableHandleAdapter(part.getModel());
            Dimension dm = adp.calculateSize();
            dm.width += value;
            try {
                adp.ajustSize(dm);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = ((TableEditPart)this.getSourceEditPart()).getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().x - this.getStartLocation().x;
        value = this.getTrueValue(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(value + p.x, bounds.y + insets.top, 2, bounds.height - (insets.top + insets.bottom));
    }

    protected Dimension getDragWidth() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        if (this.getStart() == this.getEnd()) {
            return new Dimension(part.getMinWidth(this.getStart()) - this.getColumnWidth(this.getStart()), Integer.MAX_VALUE);
        }
        return new Dimension(part.getMinWidth(this.getStart()) - this.getColumnWidth(this.getStart()), this.getColumnWidth(this.getEnd()) - part.getMinWidth(this.getEnd()));
    }

    protected void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }
}

