/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.swt.widgets.Display;

public class ReportCreationTool
extends CreationTool {
    private static final String MODEL_CREATE_ELEMENT_TRANS = Messages.getString((String)"ReportCreationTool.ModelTrans.CreateElement");
    private AbstractToolHandleExtends preHandle;
    private boolean isCreating = false;

    public ReportCreationTool(CreationFactory factory, AbstractToolHandleExtends preHandle) {
        super(factory);
        this.preHandle = preHandle;
    }

    protected void performCreation(int button) {
        this.isCreating = true;
        SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().startTrans(MODEL_CREATE_ELEMENT_TRANS);
        if (this.getTargetEditPart() != null && this.preHandle != null) {
            this.preHandle.setRequest(this.getCreateRequest());
            this.preHandle.setTargetEditPart(this.getTargetEditPart());
            Command command = this.getCurrentCommand();
            if (command != null && command.canExecute() && !this.preHandle.preHandleMouseUp()) {
                SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().rollback();
                this.handleFinished();
                return;
            }
        }
        super.performCreation(button);
        if (this.preHandle != null && !this.preHandle.postHandleCreation()) {
            SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().rollback();
            this.handleFinished();
            return;
        }
        SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().commit();
        this.selectAddedObject();
        this.isCreating = false;
    }

    public void performCreation(EditPart editPart) {
        if (editPart == null) {
            return;
        }
        this.setTargetEditPart(editPart);
        boolean validateCurr = ReportCreationTool.handleValidatePalette(this.getFactory().getObjectType(), this.getTargetEditPart());
        if (!validateCurr) {
            this.setTargetEditPart(editPart.getParent());
        }
        if (validateCurr || ReportCreationTool.handleValidatePalette(this.getFactory().getObjectType(), this.getTargetEditPart())) {
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            Rectangle rect = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rect);
            Point point = rect.getRight();
            point.performTranslate(1, 1);
            this.getCreateRequest().setLocation(point);
            this.setCurrentCommand(this.getCommand());
            this.performCreation(524288);
        }
        this.eraseTargetFeedback();
    }

    private void selectAddedObject() {
        Object model = this.getNewObjectFromRequest();
        EditPartViewer viewer = this.getCurrentViewer();
        ReportCreationTool.selectAddedObject(model, viewer);
    }

    public Request getTargetRequest() {
        return super.getTargetRequest();
    }

    public Object getNewObjectFromRequest() {
        return this.getCreateRequest().getExtendedData().get("newObject");
    }

    public static void selectAddedObject(Object model, EditPartViewer viewer) {
        ReportCreationTool.selectAddedObject(model, viewer, new Request((Object)"create element"));
    }

    public static void selectAddedObject(final Object model, final EditPartViewer viewer, final Request request) {
        if (model == null || viewer == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                Object editpart = viewer.getEditPartRegistry().get(model);
                if (!(editpart instanceof EditPart)) {
                    return;
                }
                viewer.flush();
                viewer.select((EditPart)editpart);
                if (((EditPart)editpart).understandsRequest(request)) {
                    ((EditPart)editpart).performRequest(request);
                }
                if (editpart != null) {
                    viewer.reveal((EditPart)editpart);
                }
            }
        });
    }

    protected static String getCreationType(String template) {
        String type = "";
        if ("Image".equalsIgnoreCase(template)) {
            type = "Image";
        } else if ("Table".equalsIgnoreCase(template)) {
            type = "Table";
        } else if ("TextData".equalsIgnoreCase(template)) {
            type = "TextData";
        } else if ("Text".equalsIgnoreCase(template) || "Date".equalsIgnoreCase(template) || "Created on".equalsIgnoreCase(template) || "Created by".equalsIgnoreCase(template) || "Filename".equalsIgnoreCase(template) || "Last printed".equalsIgnoreCase(template)) {
            type = "Text";
        } else if ("TotalPageCount".equalsIgnoreCase(template) || "Page".equalsIgnoreCase(template)) {
            type = "AutoText";
        } else if ("AuthorPageDate".equalsIgnoreCase(template) || "ConfidentalPage".equalsIgnoreCase(template) || "Grid".equalsIgnoreCase(template) || "Page X of Y".equalsIgnoreCase(template)) {
            type = "Grid";
        } else if ("Label".equalsIgnoreCase(template)) {
            type = "Label";
        } else if ("Data".equalsIgnoreCase(template)) {
            type = "Data";
        } else if ("List".equalsIgnoreCase(template)) {
            type = "List";
        } else if (template.startsWith("Extended")) {
            type = "ExtendedItem";
        }
        return type;
    }

    public static boolean handleValidatePalette(Object objectType, EditPart targetEditPart) {
        return objectType instanceof String && targetEditPart != null && DNDUtil.handleValidateTargetCanContainType((Object)targetEditPart.getModel(), (String)ReportCreationTool.getCreationType((String)objectType)) && DNDUtil.handleValidateTargetCanContainMore((Object)targetEditPart.getModel(), (int)1);
    }

    protected boolean handleMove() {
        boolean validateTrue = false;
        if (this.isCreating) {
            return true;
        }
        this.updateTargetUnderMouse();
        if (this.getTargetEditPart().getModel() instanceof LibraryHandle) {
            // empty if block
        }
        if (this.getTargetEditPart() != null) {
            validateTrue = ReportCreationTool.handleValidatePalette(this.getFactory().getObjectType(), this.getTargetEditPart());
        }
        if (validateTrue) {
            this.updateTargetRequest();
            this.setCurrentCommand(this.getCommand());
            this.showTargetFeedback();
        } else {
            this.setCurrentCommand(null);
        }
        return validateTrue;
    }
}

