/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorderHelper;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutHelper;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.FixTableLayoutCalculator;
import org.eclipse.birt.report.designer.util.ITableLayoutCalculator;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class TableLayout
extends XYLayout {
    private static final Insets INSETS_SINGLETON = new Insets();
    protected Map constraints = new HashMap();
    private WorkingData data = null;
    private TableEditPart owner;
    private boolean needlayout = true;
    private TableBorderHelper helper;

    public TableLayout() {
    }

    public TableLayout(TableEditPart part) {
        this.owner = part;
    }

    public void layout(IFigure container, boolean bool) {
        boolean temp = this.needlayout;
        this.layout(container);
        if (bool) {
            this.needlayout = temp;
        }
    }

    public void markDirty() {
        this.needlayout = true;
    }

    public TableBorderHelper getBorderHelper() {
        return this.helper;
    }

    public void layout(IFigure container) {
        if (this.data != null && this.data.columnWidths != null && this.data.columnWidths.length == this.getColumnCount() && this.data.rowHeights != null && this.data.rowHeights.length == this.getRowCount() && !this.needlayout || !this.owner.isActive()) {
            return;
        }
        this.helper = new TableBorderHelper(this.owner);
        this.helper.updateCellBorderInsets();
        this.data = new WorkingData();
        this.data.columnWidths = new TableLayoutData.ColumnData[this.getColumnCount()];
        this.data.rowHeights = new TableLayoutData.RowData[this.getRowCount()];
        this.init(this.data.columnWidths, this.data.rowHeights);
        List children = container.getChildren();
        this.initMinSize(children);
        this.initMergeMinsize(children);
        this.caleLayoutData(container);
        this.layoutTable(container);
        this.resetRowMinSize(this.data.rowHeights);
        this.initRowMinSize(children);
        this.initRowMergeMinsize(children);
        this.caleRowData();
        this.layoutTable(container);
        this.setConstraint(container, this.data);
        this.needlayout = false;
        int containerWidth = this.getOwner().getFigure().getParent().getClientArea().getSize().width;
        if (containerWidth < 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    TableLayout.this.getOwner().reLayout();
                }
            });
            return;
        }
        this.reselect();
    }

    private void reselect() {
        ArrayList list = new ArrayList(((StructuredSelection)this.getOwner().getViewer().getSelection()).toList());
        boolean hasCell = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof TableCellEditPart) && !(list.get(i) instanceof TableEditPart)) continue;
            hasCell = true;
            break;
        }
        if (hasCell) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    UIUtil.resetViewSelection(TableLayout.this.getOwner().getViewer(), false);
                }
            });
        }
    }

    private void layoutTable(IFigure container) {
        List children = container.getChildren();
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)children.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int columnNumber = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int columnSpan = cellPart.getColSpan();
            int x = this.getColumnWidth(1, columnNumber);
            int y = this.getRowHeight(1, rowNumber);
            int width = this.getColumnWidth(columnNumber, columnNumber + columnSpan);
            int height = this.getRowHeight(rowNumber, rowNumber + rowSpan);
            this.setBoundsOfChild(container, figure, new Rectangle(x, y, width, height));
        }
    }

    private int getRowHeight(int start, int end) {
        int retValue = 0;
        for (int i = start; i < end; ++i) {
            retValue += this.data.rowHeights[i - 1].height;
        }
        return retValue;
    }

    private int getColumnWidth(int start, int end) {
        int retValue = 0;
        for (int i = start; i < end; ++i) {
            retValue += this.data.columnWidths[i - 1].width;
        }
        return retValue;
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
        if (child.getLayoutManager() != null) {
            child.getLayoutManager().invalidate();
        }
        child.revalidate();
    }

    private void resetRowMinSize(TableLayoutData.RowData[] rowHeights) {
        int size = rowHeights.length;
        for (int i = 1; i < size + 1; ++i) {
            rowHeights[i - 1] = new TableLayoutData.RowData();
            rowHeights[i - 1].rowNumber = i;
            Object obj = this.getOwner().getRow(i);
            RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
            rowHeights[i - 1].height = adapt.getHeight();
            rowHeights[i - 1].isForce = adapt.isCustomHeight();
            DimensionHandle dim = ((RowHandle)adapt.getHandle()).getHeight();
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                rowHeights[i - 1].isPercentage = true;
                rowHeights[i - 1].percentageHeight = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                rowHeights[i - 1].isAuto = true;
            }
            rowHeights[i - 1].trueMinRowHeight = rowHeights[i - 1].isForce && !rowHeights[i - 1].isPercentage ? rowHeights[i - 1].height : rowHeights[i - 1].minRowHeight;
        }
    }

    private void initRowMinSize(List children) {
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)children.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int columnNumber = cellPart.getColumnNumber();
            int columnSpan = cellPart.getColSpan();
            int rowSpan = cellPart.getRowSpan();
            TableLayoutData.RowData rowData = this.data.findRowData(rowNumber);
            TableLayoutData.ColumnData columnData = this.data.findColumnData(columnNumber);
            int colWidth = columnData.width;
            if (columnSpan > 1) {
                for (int k = 1; k < columnSpan; ++k) {
                    TableLayoutData.ColumnData cData = this.data.findColumnData(columnNumber + k);
                    if (cData == null) continue;
                    colWidth += cData.width;
                }
            }
            Dimension dim = figure.getMinimumSize(colWidth, -1);
            if (dim.height > rowData.minRowHeight && rowSpan == 1) {
                rowData.minRowHeight = dim.height;
            }
            if (dim.height <= rowData.trueMinRowHeight || rowSpan != 1) continue;
            rowData.trueMinRowHeight = dim.height;
            rowData.isSetting = true;
        }
    }

    private void initRowMergeMinsize(List children) {
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        ArrayList<Integer> adjustRow = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)children.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int rowSpan = cellPart.getRowSpan();
            if (rowSpan == 1) continue;
            list.add(figure);
            if (rowSpan <= 1) continue;
            for (int j = rowNumber; j < rowNumber + rowSpan; ++j) {
                adjustRow.add(new Integer(j));
            }
        }
        this.caleRowMergeMinHeight(list, adjustRow, new ArrayList());
    }

    private void caleRowMergeMinHeight(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        int adjustMax = 0;
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)figures.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int rowSpan = cellPart.getRowSpan();
            Dimension minSize = figure.getMinimumSize(this.data.findColumnData((int)cellPart.getColumnNumber()).width, -1);
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            for (int j = rowNumber; j < rowNumber + rowSpan; ++j) {
                TableLayoutData.RowData rowData = this.data.findRowData(j);
                if (!hasAdjust.contains(new Integer(j))) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                    continue;
                }
                samMin += rowData.trueMinRowHeight;
                trueSamMin += rowData.trueMinRowHeight;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount == 0) continue;
            int value = minSize.height - samMin;
            int trueValue = minSize.height - trueSamMin;
            for (int j = 0; j < adjustCount; ++j) {
                int temp = 0;
                int trueTemp = 0;
                if (j == adjustCount - 1) {
                    temp = value / adjustCount + value % adjustCount;
                    trueTemp = trueValue / adjustCount + trueValue % adjustCount;
                } else {
                    temp = value / adjustCount;
                    trueTemp = trueValue / adjustCount;
                }
                TableLayoutData.RowData rowData = this.data.findRowData(adjustNumber[j]);
                temp = Math.max(temp, rowData.minRowHeight);
                trueTemp = Math.max(trueTemp, rowData.trueMinRowHeight);
                if (trueTemp <= trueAdjustMax) continue;
                adjustMax = temp;
                trueAdjustMax = trueTemp;
                adjustMaxNumber = adjustNumber[j];
            }
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.RowData rowData = this.data.findRowData(adjustMaxNumber);
            rowData.minRowHeight = adjustMax;
            rowData.trueMinRowHeight = trueAdjustMax;
            adjust.remove(new Integer(adjustMaxNumber));
            hasAdjust.add(new Integer(adjustMaxNumber));
            this.caleMergeMinHeight(figures, adjust, hasAdjust);
        }
    }

    private void caleRowData() {
        int i;
        if (this.data == null) {
            return;
        }
        int size = this.data.rowHeights.length;
        int[] dxRows = new int[size];
        int dxTotal = 0;
        for (i = 0; i < size; ++i) {
            dxRows[i] = this.data.rowHeights[i].height - this.data.rowHeights[i].trueMinRowHeight;
            dxTotal += dxRows[i];
        }
        for (i = 0; i < size; ++i) {
            if (dxRows[i] >= 0) continue;
            this.data.rowHeights[i].height = this.data.rowHeights[i].trueMinRowHeight;
        }
    }

    private void caleLayoutData(IFigure container) {
        int i;
        if (this.data == null) {
            return;
        }
        int size = this.data.rowHeights.length;
        int[] dxRows = new int[size];
        int dxTotal = 0;
        for (i = 0; i < size; ++i) {
            dxRows[i] = this.data.rowHeights[i].height - this.data.rowHeights[i].trueMinRowHeight;
            dxTotal += dxRows[i];
        }
        for (i = 0; i < size; ++i) {
            if (dxRows[i] >= 0) continue;
            this.data.rowHeights[i].height = this.data.rowHeights[i].trueMinRowHeight;
        }
        size = this.data.columnWidths.length;
        int containerWidth = this.getOwner().getFigure().getParent().getClientArea().getSize().width;
        containerWidth -= this.getFigureMargin(this.getOwner().getFigure()).getWidth();
        Object tadp = null;
        tadp = this.getOwner() instanceof GridEditPart ? HandleAdapterFactory.getInstance().getGridHandleAdapter(this.getOwner().getModel()) : HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getOwner().getModel());
        if (tadp != null) {
            String ww = tadp.getDefinedWidth();
            containerWidth = this.getDefinedWidth(ww, containerWidth);
        }
        int padding = this.getOwner().getFigure().getBorder().getInsets(this.getOwner().getFigure()).getWidth();
        containerWidth -= padding;
        containerWidth = Math.max(0, containerWidth);
        String[] definedWidth = new String[size];
        for (int i2 = 1; i2 < size + 1; ++i2) {
            Object obj = this.getOwner().getColumn(i2);
            ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(obj);
            definedWidth[i2 - 1] = adapt.getRawWidth();
        }
        FixTableLayoutCalculator calculator = new FixTableLayoutCalculator();
        calculator.setTableWidth((float)containerWidth);
        calculator.setColMinSize(20.0f);
        calculator.setDefinedColWidth(definedWidth);
        TableLayoutHelper.calculateColumnWidth(this.data.columnWidths, containerWidth, (ITableLayoutCalculator)calculator);
    }

    private Insets getFigureMargin(IFigure f) {
        if (f instanceof IReportElementFigure) {
            return ((IReportElementFigure)f).getMargin();
        }
        return INSETS_SINGLETON;
    }

    private int getDefinedWidth(String dw, int cw) {
        if (dw == null || dw.length() == 0) {
            return 0;
        }
        try {
            if (dw.endsWith("%")) {
                return (int)(Double.parseDouble(dw.substring(0, dw.length() - 1)) * (double)cw / 100.0);
            }
            return (int)Double.parseDouble(dw);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void initMinSize(List children) {
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)children.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int columnNumber = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int columnSpan = cellPart.getColSpan();
            Dimension dim = figure.getMinimumSize();
            TableLayoutData.RowData rowData = this.data.findRowData(rowNumber);
            TableLayoutData.ColumnData columnData = this.data.findColumnData(columnNumber);
            if (dim.height > rowData.minRowHeight && rowSpan == 1) {
                rowData.minRowHeight = dim.height;
            }
            if (dim.height > rowData.trueMinRowHeight && rowSpan == 1) {
                rowData.trueMinRowHeight = dim.height;
                rowData.isSetting = true;
            }
            if (dim.width > columnData.minColumnWidth && columnSpan == 1) {
                columnData.minColumnWidth = dim.width;
            }
            if (dim.width <= columnData.trueMinColumnWidth || columnSpan != 1) continue;
            columnData.trueMinColumnWidth = dim.width;
            columnData.isSetting = true;
        }
    }

    private void initMergeMinsize(List children) {
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        ArrayList<Integer> adjustRow = new ArrayList<Integer>();
        ArrayList<Integer> adjustColumn = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            int j;
            IFigure figure = (IFigure)children.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int columnNumber = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int columnSpan = cellPart.getColSpan();
            if (rowSpan == 1 && columnSpan == 1) continue;
            list.add(figure);
            if (rowSpan > 1) {
                for (j = rowNumber; j < rowNumber + rowSpan; ++j) {
                    adjustRow.add(new Integer(j));
                }
            }
            if (columnSpan <= 1) continue;
            for (j = columnNumber; j < columnNumber + columnSpan; ++j) {
                adjustColumn.add(new Integer(j));
            }
        }
        this.caleMergeMinHeight(list, adjustRow, new ArrayList());
        this.caleMergeMinWidth(list, adjustColumn, new ArrayList());
    }

    private void caleMergeMinHeight(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        int adjustMax = 0;
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)figures.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int rowNumber = cellPart.getRowNumber();
            int rowSpan = cellPart.getRowSpan();
            Dimension minSize = figure.getMinimumSize(this.data.findColumnData((int)cellPart.getColumnNumber()).width, -1);
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            for (int j = rowNumber; j < rowNumber + rowSpan; ++j) {
                TableLayoutData.RowData rowData = this.data.findRowData(j);
                if (!hasAdjust.contains(new Integer(j))) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                    continue;
                }
                samMin += rowData.trueMinRowHeight;
                trueSamMin += rowData.trueMinRowHeight;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount == 0) continue;
            int value = minSize.height - samMin;
            int trueValue = minSize.height - trueSamMin;
            for (int j = 0; j < adjustCount; ++j) {
                int temp = 0;
                int trueTemp = 0;
                if (j == adjustCount - 1) {
                    temp = value / adjustCount + value % adjustCount;
                    trueTemp = trueValue / adjustCount + trueValue % adjustCount;
                } else {
                    temp = value / adjustCount;
                    trueTemp = trueValue / adjustCount;
                }
                TableLayoutData.RowData rowData = this.data.findRowData(adjustNumber[j]);
                temp = Math.max(temp, rowData.minRowHeight);
                trueTemp = Math.max(trueTemp, rowData.trueMinRowHeight);
                if (trueTemp <= trueAdjustMax) continue;
                adjustMax = temp;
                trueAdjustMax = trueTemp;
                adjustMaxNumber = adjustNumber[j];
            }
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.RowData rowData = this.data.findRowData(adjustMaxNumber);
            rowData.minRowHeight = adjustMax;
            rowData.trueMinRowHeight = trueAdjustMax;
            adjust.remove(new Integer(adjustMaxNumber));
            hasAdjust.add(new Integer(adjustMaxNumber));
            this.caleMergeMinHeight(figures, adjust, hasAdjust);
        }
    }

    private void caleMergeMinWidth(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        int adjustMax = 0;
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)figures.get(i);
            TableCellEditPart cellPart = (TableCellEditPart)((Object)map.get(figure));
            int columnNumber = cellPart.getColumnNumber();
            int columnSpan = cellPart.getColSpan();
            Dimension minSize = figure.getMinimumSize();
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            for (int j = columnNumber; j < columnNumber + columnSpan; ++j) {
                TableLayoutData.ColumnData columnData = this.data.findColumnData(j);
                if (!hasAdjust.contains(new Integer(j))) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                    continue;
                }
                samMin += columnData.trueMinColumnWidth;
                trueSamMin += columnData.trueMinColumnWidth;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount == 0) continue;
            int value = minSize.width - samMin;
            int trueValue = minSize.width - trueSamMin;
            for (int j = 0; j < adjustCount; ++j) {
                int temp = 0;
                int trueTemp = 0;
                if (j == adjustCount - 1) {
                    temp = value / adjustCount + value % adjustCount;
                    trueTemp = trueValue / adjustCount + trueValue % adjustCount;
                } else {
                    temp = value / adjustCount;
                    trueTemp = trueValue / adjustCount;
                }
                TableLayoutData.ColumnData columnData = this.data.findColumnData(adjustNumber[j]);
                temp = Math.max(temp, columnData.minColumnWidth);
                trueTemp = Math.max(trueTemp, columnData.trueMinColumnWidth);
                if (trueTemp <= trueAdjustMax) continue;
                adjustMax = temp;
                trueAdjustMax = trueTemp;
                adjustMaxNumber = adjustNumber[j];
            }
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.ColumnData columnData = this.data.findColumnData(adjustMaxNumber);
            columnData.minColumnWidth = adjustMax;
            columnData.trueMinColumnWidth = trueAdjustMax;
            adjust.remove(new Integer(adjustMaxNumber));
            hasAdjust.add(new Integer(adjustMaxNumber));
            this.caleMergeMinWidth(figures, adjust, hasAdjust);
        }
    }

    private void init(TableLayoutData.ColumnData[] columnWidths, TableLayoutData.RowData[] rowHeights) {
        DimensionHandle dim;
        RowHandleAdapter adapt;
        Object obj;
        int i;
        int size = rowHeights.length;
        for (i = 1; i < size + 1; ++i) {
            rowHeights[i - 1] = new TableLayoutData.RowData();
            rowHeights[i - 1].rowNumber = i;
            obj = this.getOwner().getRow(i);
            adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(obj);
            rowHeights[i - 1].height = adapt.getHeight();
            rowHeights[i - 1].isForce = adapt.isCustomHeight();
            dim = ((RowHandle)adapt.getHandle()).getHeight();
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                rowHeights[i - 1].isPercentage = true;
                rowHeights[i - 1].percentageHeight = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                rowHeights[i - 1].isAuto = true;
            }
            rowHeights[i - 1].trueMinRowHeight = rowHeights[i - 1].isForce && !rowHeights[i - 1].isPercentage ? rowHeights[i - 1].height : rowHeights[i - 1].minRowHeight;
        }
        size = columnWidths.length;
        for (i = 1; i < size + 1; ++i) {
            columnWidths[i - 1] = new TableLayoutData.ColumnData();
            columnWidths[i - 1].columnNumber = i;
            obj = this.getOwner().getColumn(i);
            adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(obj);
            columnWidths[i - 1].width = adapt.getWidth();
            columnWidths[i - 1].isForce = adapt.isCustomWidth();
            dim = ((ColumnHandle)adapt.getHandle()).getWidth();
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                columnWidths[i - 1].isPercentage = true;
                columnWidths[i - 1].percentageWidth = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                columnWidths[i - 1].isAuto = true;
            }
            columnWidths[i - 1].trueMinColumnWidth = columnWidths[i - 1].isForce && !columnWidths[i - 1].isPercentage ? columnWidths[i - 1].width : columnWidths[i - 1].minColumnWidth;
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    public int getColumnCount() {
        return this.getOwner().getColumnCount();
    }

    public int getRowCount() {
        return this.getOwner().getRowCount();
    }

    public TableEditPart getOwner() {
        return this.owner;
    }

    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        String ww;
        this.layout(figure, true);
        IFigure table = figure.getParent().getParent().getParent();
        int widthExpand = table.getInsets().getWidth();
        int width = 0;
        int size = this.data.columnWidths.length;
        for (int i = 0; i < size; ++i) {
            width += this.data.columnWidths[i].trueMinColumnWidth;
        }
        Object tadp = null;
        tadp = this.getOwner() instanceof GridEditPart ? HandleAdapterFactory.getInstance().getGridHandleAdapter(this.getOwner().getModel()) : HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getOwner().getModel());
        if (tadp != null && (ww = tadp.getDefinedWidth()) != null && ww.length() > 0 && !ww.endsWith("%")) {
            try {
                int dwidth = Integer.parseInt(ww);
                if (dwidth > width + widthExpand) {
                    width = dwidth - widthExpand;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int height = 0;
        size = this.data.rowHeights.length;
        for (int i = 0; i < size; ++i) {
            height += this.data.rowHeights[i].height;
        }
        Dimension dim = new Dimension(width, height);
        return dim.expand(table.getInsets().getWidth(), table.getInsets().getHeight());
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.calculateMinimumSize(container, wHint, hHint);
    }

    public static class WorkingData {
        public TableLayoutData.ColumnData[] columnWidths;
        public TableLayoutData.RowData[] rowHeights;

        public TableLayoutData.RowData findRowData(int number) {
            return this.rowHeights[number - 1];
        }

        public TableLayoutData.ColumnData findColumnData(int number) {
            return this.columnWidths[number - 1];
        }
    }
}

