/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.dialogs.NewSectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TemplateReportItemPropertiesDialog;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CopyAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.CutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertInLayoutAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RenameAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class DefaultNodeProvider
implements INodeProvider {
    public static final String BODY = Messages.getString((String)"DefaultNodeProvider.Tree.Body");
    public static final String COMPONENTS = Messages.getString((String)"DefaultNodeProvider.Tree.Components");
    public static final String PAGESETUP = Messages.getString((String)"DefaultNodeProvider.Tree.PageSetup");
    public static final String DATASOURCES = Messages.getString((String)"DefaultNodeProvider.Tree.DataSources");
    public static final String DATASETS = Messages.getString((String)"DefaultNodeProvider.Tree.DataSets");
    public static final String STYLES = Messages.getString((String)"DefaultNodeProvider.Tree.Styles");
    public static final String THEMES = Messages.getString((String)"DefaultNodeProvider.Tree.Themes");
    public static final String IMAGES = Messages.getString((String)"DefaultNodeProvider.Tree.Images");
    public static final String PARAMETERS = Messages.getString((String)"DefaultNodeProvider.Tree.Parameters");
    public static final String SCRATCHPAD = Messages.getString((String)"DefaultNodeProvider.Tree.Scratch");
    public static final String MASTERPAGE = Messages.getString((String)"DefaultNodeProvider.Tree.MasterPages");
    public static final String COLUMNHEADING_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.ColumnHedings");
    public static final String DETAIL_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Detail");
    public static final String HEADER_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Header");
    public static final String FOOTER_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Footer");
    public static final String GROUPS_DISPALYNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Groups");
    public static final String MISSINGNAME = Messages.getString((String)"DefaultNodeProvider.Tree.Invalid");
    public static final String WARNING_DIALOG_TITLE = Messages.getString((String)"DefaultNodeProvider.WarningDialog.Title");
    public static final String WARNING_DIALOG_MESSAGE_EMPTY_LIST = Messages.getString((String)"DefaultNodeProvider.WarningDialog.EmptyList");
    private Comparator comparator;

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        CopyAction copyAction;
        CutAction cutAction;
        DeleteAction deleteAction;
        menu.add((IContributionItem)new Separator());
        InsertInLayoutAction insertAction = new InsertInLayoutAction(object);
        if (insertAction.isTypeAvailable()) {
            menu.add((IAction)insertAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
        RenameAction renameAction = new RenameAction(sourceViewer);
        if (renameAction.isEnabled()) {
            menu.add((IAction)renameAction);
        }
        if ((deleteAction = new DeleteAction(object)).isEnabled()) {
            menu.add((IAction)deleteAction);
        }
        if ((cutAction = new CutAction(object)).isEnabled()) {
            menu.add((IAction)cutAction);
        }
        if ((copyAction = new CopyAction(object)).isEnabled()) {
            menu.add((IAction)copyAction);
        }
        if (!(object instanceof ResultSetColumnHandle)) {
            menu.add((IAction)new PasteAction(object));
        }
        menu.add((IContributionItem)new Separator("additions-refresh"));
    }

    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model);
    }

    public Object[] getChildren(Object model) {
        if (model instanceof ReportElementModel && ((ReportElementModel)model).getSlotHandle() != null) {
            Object[] children = this.getChildrenBySlotHandle(((ReportElementModel)model).getSlotHandle());
            if (this.comparator != null) {
                Arrays.sort(children, this.comparator);
            }
            return children;
        }
        return new Object[0];
    }

    public Object getParent(Object model) {
        if (model instanceof ReportElementModel) {
            return ((ReportElementModel)model).getElementHandle();
        }
        if (model instanceof SlotHandle) {
            return ((SlotHandle)model).getElementHandle();
        }
        if (model instanceof ReportElementHandle) {
            ReportElementHandle handle = (ReportElementHandle)model;
            if (handle instanceof CellHandle || handle.getContainer() instanceof CellHandle || handle.getContainer() instanceof ParameterGroupHandle || handle instanceof RowHandle && handle.getContainer() instanceof GridHandle) {
                return handle.getContainer();
            }
            if (handle.getContainerSlotHandle() != null) {
                return new ReportElementModel(handle.getContainerSlotHandle());
            }
        }
        return null;
    }

    public Image getNodeIcon(Object model) {
        Image icon = null;
        String iconName = this.getIconName(model);
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
        }
        if (iconName != null) {
            icon = ReportPlatformUIImages.getImage(iconName);
        }
        if (icon == null && model instanceof DesignElementHandle) {
            icon = ReportPlatformUIImages.getImage(model);
        }
        return icon;
    }

    public String getNodeTooltip(Object model) {
        return null;
    }

    public String getIconName(Object model) {
        return null;
    }

    protected Object[] getChildrenBySlotHandle(SlotHandle slotHandle) {
        ArrayList<DesignElementHandle> list = new ArrayList<DesignElementHandle>();
        Iterator itor = slotHandle.iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            if (!(obj instanceof DesignElementHandle)) continue;
            DesignElementHandle eleHandle = (DesignElementHandle)obj;
            list.add(eleHandle);
        }
        return list.toArray();
    }

    public boolean performRequest(Object model, Request request) throws Exception {
        if (request.getType().equals("insert")) {
            Map extendsData = request.getExtendedData();
            SlotHandle slotHandle = (SlotHandle)extendsData.get("insert-slot");
            String type = (String)extendsData.get("insert-type");
            String position = (String)extendsData.get("insert-position");
            return this.performInsert(model, slotHandle, type, position, extendsData);
        }
        if (request.getType().equals("edit")) {
            return this.performEdit((ReportElementHandle)model);
        }
        if (request.getType().equals("delete")) {
            return false;
        }
        if (request.getType().equals("create-placeholder")) {
            return this.performCreatePlaceHolder((ReportElementHandle)model);
        }
        if (request.getType().equals("change-data-column")) {
            return this.performChangeDataColumn((ReportElementHandle)model);
        }
        if (request.getType().equals("transfer-placeholder")) {
            return this.performTransferPlaceHolder((TemplateElementHandle)model);
        }
        if (request.getType().equals("revert-to-reportitem")) {
            return this.performRevertToReportItem((DesignElementHandle)model);
        }
        if (request.getType().equals("revert-to-templateitem")) {
            return this.performRevertToTemplateItem((DesignElementHandle)model);
        }
        return false;
    }

    private boolean performRevertToTemplateItem(DesignElementHandle handle) {
        try {
            handle.revertToTemplate(ReportPlugin.getDefault().getCustomName("TemplateReportItem"));
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    private boolean performTransferPlaceHolder(TemplateElementHandle handle) {
        DesignElementHandle copiedHandle = handle.copyDefaultElement().getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
        try {
            ((TemplateReportItemHandle)handle).transformToReportItem((ReportItemHandle)copiedHandle);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    private boolean performRevertToReportItem(DesignElementHandle handle) {
        try {
            handle.revertToReportItem();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    private boolean checkNameExist(DesignElementHandle handle, String name) {
        DesignElementHandle element = handle.getModuleHandle().findElement(name);
        return element != null;
    }

    private boolean performChangeDataColumn(ReportElementHandle handle) {
        if (!(handle instanceof DataItemHandle)) {
            return false;
        }
        handle.getModuleHandle().getCommandStack().startTrans(null);
        ColumnBindingDialog dialog = new ColumnBindingDialog(true);
        dialog.setInput((ReportItemHandle)((DataItemHandle)handle));
        dialog.setGroupList(DEUtil.getGroups((DesignElementHandle)handle));
        if (dialog.open() == 0) {
            handle.getModuleHandle().getCommandStack().commit();
            return true;
        }
        handle.getModuleHandle().getCommandStack().rollbackAll();
        return false;
    }

    private boolean performCreatePlaceHolder(ReportElementHandle handle) {
        boolean bIsNameExist = false;
        TemplateElementHandle template = null;
        String name = ReportPlugin.getDefault().getCustomName("TemplateReportItem");
        if (name == null) {
            name = "";
        }
        String desc = "";
        try {
            do {
                TemplateReportItemPropertiesDialog dialog;
                if ((dialog = new TemplateReportItemPropertiesDialog(handle.getDefn().getDisplayName(), name, desc)).open() == 0) {
                    name = dialog.getName().trim();
                    desc = (String)dialog.getResult();
                    bIsNameExist = this.checkNameExist((DesignElementHandle)handle, name);
                    if (!bIsNameExist) {
                        template = handle.createTemplateElement(name);
                        template.setDescription(desc);
                        continue;
                    }
                    ExceptionHandler.openErrorMessageBox(Messages.getString((String)"performCreatePlaceHolder.errorMessage.title"), Messages.getString((String)"performCreatePlaceHolder.errorMessage.content"));
                    continue;
                }
                return false;
            } while (bIsNameExist);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        return ElementProcessorFactory.createProcessor(type).createElement(null);
    }

    protected DesignElementHandle createElement(SlotHandle slotHandle, String type) throws Exception {
        if (type == null) {
            List supportList = DEUtil.getElementSupportList((SlotHandle)slotHandle);
            if (supportList.size() == 0) {
                ExceptionHandler.openMessageBox(WARNING_DIALOG_TITLE, WARNING_DIALOG_MESSAGE_EMPTY_LIST, 8);
                return null;
            }
            if (supportList.size() == 1) {
                type = ((IElementDefn)supportList.get(0)).getName();
            } else {
                NewSectionDialog dialog = new NewSectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), supportList);
                if (dialog.open() == 1) {
                    return null;
                }
                type = (String)dialog.getResult()[0];
            }
        }
        return this.createElement(type);
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        DesignElementHandle elementHandle = this.createElement(slotHandle, type);
        if (extendData != null) {
            extendData.put("result", elementHandle);
        }
        if (elementHandle == null) {
            return false;
        }
        if (position == "current") {
            slotHandle.add(elementHandle);
        } else {
            int pos = DNDUtil.calculateNextPosition((Object)model, (int)DNDUtil.handleValidateTargetCanContain((Object)model, (Object)elementHandle, (boolean)true));
            if (pos > 0 && position == "above") {
                --pos;
            }
            if (pos == -1) {
                slotHandle.add(elementHandle);
            } else {
                slotHandle.add(elementHandle, pos);
            }
        }
        return !(elementHandle instanceof ExtendedItemHandle) || ElementProcessorFactory.createProcessor(elementHandle).editElement(elementHandle);
    }

    protected boolean performEdit(ReportElementHandle handle) {
        return false;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public void setSorter(Comparator comparator) {
        this.comparator = comparator;
    }
}

