/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public abstract class AttributePage
extends TabPage
implements Listener {
    public static final int QUICK_BUTTON_HEIGHT = Platform.getOS().equals("win32") ? 20 : 22;
    protected HashMap propertiesMap = new HashMap(7);
    protected List input = new ArrayList();
    private Set propertiesSet = new HashSet();
    private int refreshCount = 0;

    public AttributePage(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AttributePage.this.deRegisterListeners();
            }
        });
        this.buildUI();
    }

    public void setInput(List elements) {
        this.deRegisterListeners();
        this.input = elements;
        Object[] descriptors = this.propertiesMap.values().toArray();
        for (int i = 0; i < descriptors.length; ++i) {
            IPropertyDescriptor descriptor = (IPropertyDescriptor)descriptors[i];
            descriptor.setModelList(elements);
        }
        this.refreshValues(new HashSet(this.propertiesMap.keySet()));
        this.registerListeners();
    }

    protected void refreshValues(Set propertiesSet) {
        Object[] properties = propertiesSet.toArray();
        for (int i = 0; i < properties.length; ++i) {
            IPropertyDescriptor descriptor = (IPropertyDescriptor)this.propertiesMap.get(properties[i]);
            if (descriptor == null) continue;
            descriptor.resetUIData();
        }
        propertiesSet.clear();
    }

    protected void deRegisterListeners() {
        if (this.input == null) {
            return;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            Object obj = this.input.get(i);
            if (!(obj instanceof DesignElementHandle)) continue;
            DesignElementHandle element = (DesignElementHandle)obj;
            element.removeListener((Listener)this);
        }
    }

    protected void registerListeners() {
        if (this.input == null) {
            return;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            Object obj = this.input.get(i);
            if (!(obj instanceof DesignElementHandle)) continue;
            DesignElementHandle element = (DesignElementHandle)obj;
            element.addListener((Listener)this);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.refreshCount != this.input.size() - 1) {
            ++this.refreshCount;
            return;
        }
        int eventType = ev.getEventType();
        if (eventType == 3) {
            if (this.propertiesMap.containsKey("name")) {
                this.propertiesSet.add("name");
            }
        } else if (eventType == 5) {
            PropertyEvent event = (PropertyEvent)ev;
            String propertyName = event.getPropertyName();
            if ("textAlign".equals(propertyName)) {
                propertyName = "GUI_HORIZONTAL_ALIGN";
            }
            if (this.propertiesMap.containsKey(propertyName)) {
                this.propertiesSet.add(propertyName);
            }
        } else if (eventType == 6) {
            if (this.propertiesMap.containsKey("style")) {
                this.propertiesSet.add("style");
            }
        } else if (eventType == 15) {
            if (this.propertiesMap.containsKey("theme")) {
                this.propertiesSet.add("theme");
            }
        } else {
            return;
        }
        if (this.refreshCount == this.input.size() - 1) {
            this.refreshCount = 0;
            this.refreshValues(this.propertiesSet);
        }
    }

    protected abstract void buildUI();

    public void dispose() {
        this.deRegisterListeners();
        super.dispose();
    }
}

