/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.ICategoryPage;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BaseAttributePage
extends TabPage {
    private org.eclipse.swt.widgets.List categoryList;
    private Label categoryInfoLabel;
    private Composite infoPane;
    private ICategoryProvider categoryProvider;
    private static int s_lastSelectedIndex = 0;
    private static String s_lastSelectedTitle = null;
    private List input = new ArrayList();
    private HashMap pageMap;
    private ScrolledComposite sComposite;
    private TabPage currentPage = null;

    public BaseAttributePage(Composite parent, int style) {
        super(parent, style);
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString((String)"BasAttributePage.Label.Attributes"));
        this.categoryInfoLabel = new Label((Composite)this, 0);
        GridData gd = new GridData(768);
        this.categoryInfoLabel.setLayoutData((Object)gd);
        Label separator = new Label((Composite)this, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        this.categoryList = new org.eclipse.swt.widgets.List((Composite)this, 2820);
        gd = new GridData(1040);
        gd.widthHint = 150;
        this.categoryList.setLayoutData((Object)gd);
        this.categoryList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseAttributePage.this.categoryList.getSelection().length > 0) {
                    s_lastSelectedTitle = BaseAttributePage.this.categoryList.getSelection()[0];
                    s_lastSelectedIndex = BaseAttributePage.this.categoryList.getSelectionIndex();
                }
                BaseAttributePage.this.processListSelected();
            }
        });
        this.sComposite = new ScrolledComposite((Composite)this, 768);
        this.sComposite.setLayoutData((Object)new GridData(1808));
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.sComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                BaseAttributePage.this.computeSize();
            }
        });
        this.infoPane = new Composite((Composite)this.sComposite, 0);
        this.sComposite.setContent((Control)this.infoPane);
        this.infoPane.setLayout((Layout)new GridLayout());
    }

    private void computeSize() {
        this.sComposite.setMinSize(this.infoPane.computeSize(-1, -1));
        this.infoPane.layout();
    }

    private void processListSelected() {
        if (this.categoryProvider == null) {
            return;
        }
        String[] values = this.categoryList.getSelection();
        if (values == null || values.length == 0) {
            return;
        }
        this.categoryInfoLabel.setText(values[0]);
        TabPage page = this.getCategoryPane(this.categoryList.getSelectionIndex());
        if (page == null) {
            return;
        }
        page.setInput(this.input);
        this.showPage(page);
    }

    private void showPage(TabPage page) {
        if (page != this.currentPage) {
            if (this.currentPage != null) {
                ((GridData)this.currentPage.getLayoutData()).exclude = true;
                this.currentPage.setVisible(false);
            }
            ((GridData)page.getLayoutData()).exclude = false;
            page.setVisible(true);
            this.currentPage = page;
            this.computeSize();
        }
    }

    protected void selectStickyCategory() {
        boolean found = false;
        if (s_lastSelectedTitle != null) {
            String[] items = this.categoryList.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].equals(s_lastSelectedTitle)) continue;
                found = true;
                this.categoryList.select(i);
                break;
            }
        }
        if (!found) {
            if (s_lastSelectedIndex > this.categoryList.getItemCount() - 1) {
                this.categoryList.setSelection(this.categoryList.getItemCount() - 1);
            } else {
                this.categoryList.setSelection(s_lastSelectedIndex);
            }
        }
    }

    public void setInput(List input) {
        this.input = input;
        this.selectStickyCategory();
        this.processListSelected();
    }

    public void setCategoryProvider(ICategoryProvider categoryProvider) {
        this.categoryProvider = categoryProvider;
        if (categoryProvider == null) {
            this.categoryList.setItems(new String[0]);
            return;
        }
        ICategoryPage[] pages = categoryProvider.getCategories();
        if (pages.length != 0) {
            String[] categoryLabels = new String[pages.length];
            for (int i = 0; i < pages.length; ++i) {
                categoryLabels[i] = pages[i].getDisplayLabel();
            }
            this.categoryList.setItems(categoryLabels);
            if (this.categoryList.getItemCount() > 0) {
                this.categoryList.select(0);
            }
        } else {
            this.categoryList.setItems(new String[0]);
        }
    }

    private TabPage getCategoryPane(int index) {
        String key;
        TabPage page;
        if (this.pageMap == null) {
            this.pageMap = new HashMap(this.categoryProvider.getCategories().length);
        }
        if ((page = (TabPage)((Object)this.pageMap.get(key = Integer.toString(index)))) == null) {
            page = this.categoryProvider.getCategories()[index].createControl(this.infoPane, 0);
            page.setLayoutData(new GridData(1808));
            this.pageMap.put(key, page);
        }
        return page;
    }
}

