/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ParameterBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.DataSetColumnBindingsFormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BindingPage
extends AttributePage {
    private CCombo combo;
    private Button bindingButton;
    private static final String[] columnNames = new String[]{Messages.getString((String)"BindingPage.TableColumn.Parameter"), Messages.getString((String)"BindingPage.TableColumn.DataType"), Messages.getString((String)"BindingPage.TableColumn.Value")};
    private static final String NONE = Messages.getString((String)"BindingPage.None");
    private transient boolean enableAutoCommit = true;
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("DataSetParam").getMember("dataType").getAllowedChoices();
    private static final String DEFAULT_VALUE_LABEL = Messages.getString((String)"label.defaultValue");
    private static final String DATA_SET_LABEL = Messages.getString((String)"Element.ReportItem.dataSet");
    private static final String BUTTON_BINDING = Messages.getString((String)"parameterBinding.title");
    private DataSetColumnBindingsFormPage columnBindingsFormPage;
    private ModuleHandle model;

    public BindingPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 7;
        this.setLayout((Layout)layout);
        Label title = new Label((Composite)this, 0);
        title.setText(DATA_SET_LABEL);
        this.combo = new CCombo(this, 2056);
        this.combo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String value = BindingPage.this.combo.getText();
                if (value.equals(NONE)) {
                    value = null;
                }
                int ret = 0;
                if (!NONE.equals(BindingPage.this.getDataSetName()) || BindingPage.this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                    MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 2, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                    ret = prefDialog.open();
                }
                switch (ret) {
                    case 0: {
                        this.resetDataSetReference(value, true);
                        break;
                    }
                    case 1: {
                        this.resetDataSetReference(value, false);
                        break;
                    }
                    case 2: {
                        BindingPage.this.combo.setText(BindingPage.this.getDataSetName());
                    }
                }
            }

            private void resetDataSetReference(String value, boolean clearHistory) {
                try {
                    BindingPage.this.startTrans("");
                    DataSetHandle dataSet = null;
                    if (value != null) {
                        dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value);
                    }
                    BindingPage.this.getReportItemHandle().setDataSet(dataSet);
                    if (clearHistory) {
                        BindingPage.this.getReportItemHandle().getColumnBindings().clearValue();
                        BindingPage.this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
                    }
                    BindingPage.this.columnBindingsFormPage.generateAllBindingColumns();
                    BindingPage.this.commit();
                }
                catch (SemanticException e) {
                    BindingPage.this.rollback();
                    ExceptionHandler.handle(e);
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment((Control)title, 0, 131072);
        data.top = new FormAttachment((Control)title, 0, 0x1000000);
        data.right = new FormAttachment(50);
        this.combo.setLayoutData(data);
        this.bindingButton = new Button((Composite)this, 8);
        this.bindingButton.setText(BUTTON_BINDING);
        this.bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterBindingDialog dialog = new ParameterBindingDialog(UIUtil.getDefaultShell(), (DesignElementHandle)BindingPage.this.input.get(0));
                BindingPage.this.startTrans("");
                if (dialog.open() == 0) {
                    BindingPage.this.commit();
                } else {
                    BindingPage.this.rollback();
                }
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)this.combo, 0, 131072);
        data.top = new FormAttachment((Control)title, 0, 0x1000000);
        this.bindingButton.setLayoutData((Object)data);
        try {
            this.columnBindingsFormPage = new DataSetColumnBindingsFormPage((Composite)this, new DataSetColumnBindingsFormHandleProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 0, 1024);
        data.left = new FormAttachment((Control)title, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.columnBindingsFormPage.setLayoutData(data);
    }

    protected void refreshValues(Set propertiesSet) {
        String dataSetName;
        if (this.input.size() != 1) {
            this.combo.setEnabled(false);
            this.combo.deselectAll();
            return;
        }
        this.combo.setEnabled(true);
        String selectedDataSetName = this.combo.getText();
        String[] oldList = this.combo.getItems();
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        newList[0] = NONE;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        if (!((Object)Arrays.asList(oldList)).equals(Arrays.asList(newList))) {
            this.combo.setItems(newList);
            this.combo.setText(selectedDataSetName);
        }
        if (!(dataSetName = this.getDataSetName()).equals(selectedDataSetName)) {
            this.combo.deselectAll();
            this.combo.setText(dataSetName);
        }
        this.bindingButton.setEnabled(!dataSetName.equals(NONE));
        this.columnBindingsFormPage.setInput(this.input);
    }

    private ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)this.input.get(0);
    }

    private String getDataSetName() {
        if (this.getReportItemHandle().getDataSet() == null) {
            return NONE;
        }
        String dataSetName = this.getReportItemHandle().getDataSet().getQualifiedName();
        if (StringUtil.isBlank((String)dataSetName)) {
            dataSetName = NONE;
        }
        return dataSetName;
    }

    private ParamBindingHandle createBindingHandle(String name) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle();
        ParamBinding binding = StructureFactory.createParamBinding();
        binding.setParamName(name);
        propertyHandle.addItem((IStructure)binding);
        return (ParamBindingHandle)binding.getHandle((SimpleValueHandle)propertyHandle);
    }

    private PropertyHandle getPropertyHandle() {
        ReportItemHandle handle = (ReportItemHandle)this.input.get(0);
        return handle.getPropertyHandle("paramBindings");
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        ContentEvent ce;
        PropertyEvent event;
        String propertyName;
        if (ev.getEventType() == 5 && ("paramBindings".equals(propertyName = (event = (PropertyEvent)ev).getPropertyName()) || "dataSet".equals(propertyName))) {
            HashSet<String> set = new HashSet<String>();
            set.add(propertyName);
            this.refreshValues(set);
        }
        if (ev.getEventType() == 0 && ev instanceof ContentEvent && (ce = (ContentEvent)ev).getContent() instanceof DataSet) {
            this.refreshValues(null);
        }
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    private void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    private void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    private boolean canChangeDataSet(String newName) {
        String currentDataSetName = this.getDataSetName();
        if (NONE.equals(currentDataSetName)) {
            return true;
        }
        if (!currentDataSetName.equals(newName)) {
            return MessageDialog.openQuestion(null, (String)Messages.getString((String)"dataBinding.title.changeDataSet"), (String)Messages.getString((String)"dataBinding.message.changeDataSet"));
        }
        return false;
    }

    private void enableUI(boolean enabled) {
    }

    public void setInput(List elements) {
        if (elements.size() != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        super.setInput(elements);
        this.columnBindingsFormPage.setInput(elements);
        this.model = SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected void registerListeners() {
        super.registerListeners();
        SessionHandleAdapter.getInstance().getReportDesignHandle().addListener((Listener)this);
    }

    protected void deRegisterListeners() {
        super.deRegisterListeners();
        if (this.model != null) {
            this.model.removeListener((Listener)this);
        }
    }

    private class BindingContentProvider
    implements IStructuredContentProvider {
        private BindingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ParamBindingHandle handle;
            if (inputElement == null) {
                return new Object[0];
            }
            ReportItemHandle inputHandle = (ReportItemHandle)inputElement;
            DataSetHandle dataHandle = inputHandle.getDataSet();
            if (dataHandle == null) {
                return new Object[0];
            }
            ArrayList<ParamBindingHandle> bindingParametersList = new ArrayList<ParamBindingHandle>();
            ArrayList<String> bindingParametersNameList = new ArrayList<String>();
            ArrayList<Object[]> resultList = new ArrayList<Object[]>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                handle = (ParamBindingHandle)iterator.next();
                bindingParametersList.add(handle);
                bindingParametersNameList.add(handle.getParamName());
            }
            iterator = dataHandle.parametersIterator();
            while (iterator.hasNext()) {
                handle = (DataSetParameterHandle)iterator.next();
                Object[] result = new Object[]{handle, null};
                int index = bindingParametersNameList.indexOf(handle.getName());
                if (index != -1) {
                    result[1] = bindingParametersList.get(index);
                }
                resultList.add(result);
            }
            return resultList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BindingCellModifier
    implements ICellModifier {
        private BindingCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(columnNames[2]);
        }

        public Object getValue(Object element, String property) {
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            if (bindingParameter != null) {
                return bindingParameter.getExpression();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (value == null) {
                return;
            }
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            BindingPage.this.startTrans(Messages.getString((String)"BindingPage.MessageDlg.SaveParamBinding"));
            if (((String)value).length() == 0) {
                if (bindingParameter != null) {
                    try {
                        BindingPage.this.getPropertyHandle().removeItem(bindingParameter.getStructure());
                    }
                    catch (PropertyValueException e) {
                        ExceptionHandler.handle(e);
                        BindingPage.this.rollback();
                    }
                }
            } else {
                if (bindingParameter == null) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)((Object[])element)[0];
                    try {
                        bindingParameter = BindingPage.this.createBindingHandle(parameter.getName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                        BindingPage.this.rollback();
                    }
                }
                bindingParameter.setExpression((String)value);
            }
            BindingPage.this.commit();
        }
    }

    private class BindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BindingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            DataSetParameterHandle parameter = (DataSetParameterHandle)((Object[])element)[0];
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            switch (columnIndex) {
                case 0: {
                    if (parameter.getName() == null) break;
                    text = parameter.getName();
                    break;
                }
                case 1: {
                    if (parameter.getParameterDataType() == null) break;
                    text = ChoiceSetFactory.getDisplayNameFromChoiceSet(parameter.getParameterDataType(), DATA_TYPE_CHOICE_SET);
                    break;
                }
                case 2: {
                    if (bindingParameter != null && bindingParameter.getExpression() != null) {
                        text = bindingParameter.getExpression();
                        break;
                    }
                    if (parameter.getDefaultValue() == null) break;
                    text = parameter.getDefaultValue() + " " + DEFAULT_VALUE_LABEL;
                }
            }
            return text;
        }
    }
}

