/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.StyleCombo;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.StyleComboProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BordersPage
extends AttributePage {
    ColorBuilder builder;
    StyleCombo styleCombo;
    StyleCombo widthCombo;
    private Button btnTop;
    private Button btnBottom;
    private Button btnLeft;
    private Button btnRight;
    private static final String[] styles = new String[]{"solid", "dotted", "dashed", "double"};
    private static final String LABEL_STYLE = Messages.getString((String)"BordersPage.Label.Style");
    private static final String LABEL_COLOR = Messages.getString((String)"BordersPage.Label.Color");
    private static final String LABEL_WIDTH = Messages.getString((String)"BordersPage.Label.Width");
    private static final String LABEL_BORDER = Messages.getString((String)"BordersPage.Label.Borders");
    private SelectionAdapter listener;

    public BordersPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = BordersPage.this.getActionStack();
                stack.startTrans("");
                try {
                    BordersPage.this.setBorderProperties((Button)e.widget);
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    WidgetUtil.processError(BordersPage.this.getShell(), (Exception)((Object)e1));
                }
                stack.commit();
            }
        };
        this.setLayout((Layout)WidgetUtil.createGridLayout(6));
        Label label = new Label((Composite)this, 0);
        label.setText(LABEL_STYLE);
        this.styleCombo = new StyleCombo(this, 2048, new StyleComboProvider());
        this.styleCombo.setItems(styles);
        this.styleCombo.select(0);
        this.styleCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = BordersPage.this.getActionStack();
                stack.startTrans("");
                try {
                    BordersPage.this.setStylePropertyForEnableButton((String)BordersPage.this.styleCombo.getSelectedItem());
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    WidgetUtil.processError(BordersPage.this.getShell(), (Exception)((Object)e1));
                }
                stack.commit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(LABEL_COLOR);
        this.builder = new ColorBuilder(this, 0);
        this.builder.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "borderTopColor"));
        this.builder.setColorValue("black");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.builder.setLayoutData(data);
        this.builder.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 24) {
                    CommandStack stack = BordersPage.this.getActionStack();
                    stack.startTrans("");
                    try {
                        BordersPage.this.setColorPropertyForEnableButton(BordersPage.this.getColorBuilderValue());
                    }
                    catch (SemanticException e1) {
                        stack.rollback();
                        WidgetUtil.processError(BordersPage.this.getShell(), (Exception)((Object)e1));
                    }
                    stack.commit();
                }
            }
        });
        WidgetUtil.createGridPlaceholder(this, 2, true);
        label = new Label((Composite)this, 0);
        label.setText(LABEL_WIDTH);
        this.widthCombo = new StyleCombo(this, 2048, new StyleComboProvider());
        IChoiceSet choiceSet = ChoiceSetFactory.getElementChoiceSet("Style", "borderTopWidth");
        Object[] widths = this.getWidths(choiceSet);
        if (choiceSet != null) {
            this.widthCombo.setItems(widths);
            this.widthCombo.select(1);
        }
        this.widthCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = BordersPage.this.getActionStack();
                stack.startTrans("");
                try {
                    BordersPage.this.setWidthPropertyForEnableButton((String)BordersPage.this.widthCombo.getSelectedItem());
                }
                catch (SemanticException e1) {
                    stack.rollback();
                    WidgetUtil.processError(BordersPage.this.getShell(), (Exception)((Object)e1));
                }
                stack.commit();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        WidgetUtil.createGridPlaceholder(this, 4, true);
        label = new Label((Composite)this, 0);
        label.setText(LABEL_BORDER);
        Composite container2 = new Composite((Composite)this, 0);
        RowLayout rowLayout2 = new RowLayout(256);
        rowLayout2.wrap = false;
        rowLayout2.spacing = 7;
        container2.setLayout((Layout)rowLayout2);
        this.btnTop = new Button(container2, 2);
        this.btnTop.setToolTipText(Messages.getString((String)"BordersPage.Tooltip.Top"));
        this.btnTop.setImage(ReportPlatformUIImages.getImage("BORDER_TOP"));
        this.btnTop.addSelectionListener((SelectionListener)this.listener);
        this.btnBottom = new Button(container2, 2);
        this.btnBottom.setToolTipText(Messages.getString((String)"BordersPage.Tooltip.Bottom"));
        this.btnBottom.setImage(ReportPlatformUIImages.getImage("BORDER_BOTTOM"));
        this.btnBottom.addSelectionListener((SelectionListener)this.listener);
        this.btnLeft = new Button(container2, 2);
        this.btnLeft.setToolTipText(Messages.getString((String)"BordersPage.Tooltip.Left"));
        this.btnLeft.setImage(ReportPlatformUIImages.getImage("BORDER_LEFT"));
        this.btnLeft.addSelectionListener((SelectionListener)this.listener);
        this.btnRight = new Button(container2, 2);
        this.btnRight.setToolTipText(Messages.getString((String)"BordersPage.Tooltip.Right"));
        this.btnRight.setImage(ReportPlatformUIImages.getImage("BORDER_RIGHT"));
        this.btnRight.addSelectionListener((SelectionListener)this.listener);
    }

    private String[] getWidths(IChoiceSet choiceSet) {
        IChoice[] choices = choiceSet.getChoices();
        String[] strChoices = new String[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            strChoices[i] = choices[i].getName();
        }
        return strChoices;
    }

    private void setBorderProperties(Button btn) throws SemanticException {
        String styleProperty = null;
        String colorProperty = null;
        String widthProperty = null;
        String styleValue = null;
        String colorValue = null;
        String widthValue = null;
        if (btn == this.btnTop) {
            styleProperty = "borderTopStyle";
            colorProperty = "borderTopColor";
            widthProperty = "borderTopWidth";
        } else if (btn == this.btnBottom) {
            styleProperty = "borderBottomStyle";
            colorProperty = "borderBottomColor";
            widthProperty = "borderBottomWidth";
        } else if (btn == this.btnLeft) {
            styleProperty = "borderLeftStyle";
            colorProperty = "borderLeftColor";
            widthProperty = "borderLeftWidth";
        } else if (btn == this.btnRight) {
            styleProperty = "borderRightStyle";
            colorProperty = "borderRightColor";
            widthProperty = "borderRightWidth";
        }
        if (btn.getSelection()) {
            styleValue = this.styleCombo.getSelectedItem().toString();
            widthValue = (String)this.widthCombo.getSelectedItem();
            colorValue = this.getColorBuilderValue();
            this.setStylePropertyForEnableButton(styleValue);
            this.setColorPropertyForEnableButton(colorValue);
            this.setWidthPropertyForEnableButton(widthValue);
        } else {
            styleValue = null;
            widthValue = null;
            colorValue = null;
            this.setPropertyValue(styleProperty, styleValue);
            this.setPropertyValue(colorProperty, colorValue);
            this.setPropertyValue(widthProperty, widthValue);
        }
    }

    private String getColorBuilderValue() {
        RGB rgb = this.builder.getRGB();
        String colorValue = null;
        if (rgb != null) {
            int intValue = ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue);
            colorValue = ColorUtil.format((int)intValue, (int)0);
        } else {
            colorValue = null;
        }
        return colorValue;
    }

    private void setWidthPropertyForEnableButton(String widthValue) throws SemanticException {
        if (this.btnTop.getSelection()) {
            this.setPropertyValue("borderTopWidth", widthValue);
        }
        if (this.btnBottom.getSelection()) {
            this.setPropertyValue("borderBottomWidth", widthValue);
        }
        if (this.btnLeft.getSelection()) {
            this.setPropertyValue("borderLeftWidth", widthValue);
        }
        if (this.btnRight.getSelection()) {
            this.setPropertyValue("borderRightWidth", widthValue);
        }
    }

    private void setColorPropertyForEnableButton(String colorValue) throws SemanticException {
        if (this.btnTop.getSelection()) {
            this.setPropertyValue("borderTopColor", colorValue);
        }
        if (this.btnBottom.getSelection()) {
            this.setPropertyValue("borderBottomColor", colorValue);
        }
        if (this.btnLeft.getSelection()) {
            this.setPropertyValue("borderLeftColor", colorValue);
        }
        if (this.btnRight.getSelection()) {
            this.setPropertyValue("borderRightColor", colorValue);
        }
    }

    private void setStylePropertyForEnableButton(String styleValue) throws SemanticException {
        if (this.btnTop.getSelection()) {
            this.setPropertyValue("borderTopStyle", styleValue);
        }
        if (this.btnBottom.getSelection()) {
            this.setPropertyValue("borderBottomStyle", styleValue);
        }
        if (this.btnLeft.getSelection()) {
            this.setPropertyValue("borderLeftStyle", styleValue);
        }
        if (this.btnRight.getSelection()) {
            this.setPropertyValue("borderRightStyle", styleValue);
        }
    }

    private void setPropertyValue(String property, String value) throws SemanticException {
        PropertyProcessor processor = new PropertyProcessor("Style", property);
        processor.setStringValue(value, this.input);
    }

    public void setInput(List elements) {
        super.setInput(elements);
        this.restoreSelection(elements);
    }

    private void restoreSelection(List elements) {
        this.restoreBorderType(elements);
        this.restoreBorderColor(elements);
        this.restoreBorderWidth(elements);
        this.restoreBorderButton(elements);
    }

    private void restoreBorderButton(List elements) {
        PropertyProcessor processor = new PropertyProcessor("Style", "borderLeftStyle");
        String value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.btnLeft.setSelection(true);
        } else {
            this.btnLeft.setSelection(false);
        }
        processor = new PropertyProcessor("Style", "borderRightStyle");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.btnRight.setSelection(true);
        } else {
            this.btnRight.setSelection(false);
        }
        processor = new PropertyProcessor("Style", "borderTopStyle");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.btnTop.setSelection(true);
        } else {
            this.btnTop.setSelection(false);
        }
        processor = new PropertyProcessor("Style", "borderBottomStyle");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.btnBottom.setSelection(true);
        } else {
            this.btnBottom.setSelection(false);
        }
    }

    private void restoreBorderWidth(List elements) {
        PropertyProcessor processor = new PropertyProcessor("Style", "borderLeftWidth");
        String value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.widthCombo.setSelectedItem(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderRightWidth");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.widthCombo.setSelectedItem(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderTopWidth");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.widthCombo.setSelectedItem(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderBottomWidth");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.widthCombo.setSelectedItem(value);
            return;
        }
    }

    private void restoreBorderColor(List elements) {
        PropertyProcessor processor = new PropertyProcessor("Style", "borderLeftColor");
        String value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.builder.setColorValue(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderRightColor");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.builder.setColorValue(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderTopColor");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.builder.setColorValue(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderBottomColor");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.builder.setColorValue(value);
            return;
        }
    }

    private void restoreBorderType(List elements) {
        PropertyProcessor processor = new PropertyProcessor("Style", "borderLeftStyle");
        String value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.styleCombo.setSelectedItem(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderRightStyle");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.styleCombo.setSelectedItem(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderTopStyle");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.styleCombo.setSelectedItem(value);
            return;
        }
        processor = new PropertyProcessor("Style", "borderBottomStyle");
        value = processor.getLocalStringValue(elements);
        if (!"".equals(value)) {
            this.styleCombo.setSelectedItem(value);
            return;
        }
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        super.elementChanged(focus, ev);
    }
}

