/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormatNumberAttributePage
extends AttributePage {
    IFormatPage formatPage;

    public FormatNumberAttributePage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.formatPage = new FormatNumberPage(this, 0, 0);
        GridData data = new GridData(768);
        ((Composite)this.formatPage).setLayoutData((Object)data);
        this.formatPage.addFormatChangeListener(new IFormatChangeListener(){

            public void formatChange(FormatChangeEvent event) {
                if (FormatNumberAttributePage.this.formatPage.isDirty() && FormatNumberAttributePage.this.formatPage.isFormatModified()) {
                    FormatNumberAttributePage.this.doSave(event.getCategory(), event.getPattern());
                    if (event.getCategory() != null || event.getPattern() != null) {
                        FormatNumberAttributePage.this.doLoad();
                    }
                }
            }
        });
    }

    public void setInput(List elements) {
        super.setInput(elements);
        this.doLoad();
    }

    private void doLoad() {
        ((Composite)this.formatPage).setEnabled(true);
        String[] format = this.getFormatValue(this.input);
        if (format == null) {
            this.formatPage.setInput(null, null);
        } else {
            this.formatPage.setInput(format[0], format[1]);
        }
    }

    private void doSave(String category, String pattern) {
        SessionHandleAdapter.getInstance().getCommandStack().startTrans(Messages.getString((String)"FormatNumberAttributePage.Trans.SetNumberFormat"));
        Iterator iter = this.input.iterator();
        while (iter.hasNext()) {
            DesignElementHandle element = (DesignElementHandle)iter.next();
            try {
                if (category == null && pattern == null) {
                    element.setProperty("numberFormat", null);
                    continue;
                }
                element.getPrivateStyle().setNumberFormatCategory(category);
                element.getPrivateStyle().setNumberFormat(pattern);
            }
            catch (SemanticException e) {
                SessionHandleAdapter.getInstance().getCommandStack().rollbackAll();
                ExceptionHandler.handle(e);
            }
        }
        SessionHandleAdapter.getInstance().getCommandStack().commit();
    }

    private String[] getFormatValue(List input) {
        if (input.isEmpty()) {
            return null;
        }
        String baseCategory = ((DesignElementHandle)input.get(0)).getPrivateStyle().getNumberFormatCategory();
        String basePattern = ((DesignElementHandle)input.get(0)).getPrivateStyle().getNumberFormat();
        Iterator iter = input.iterator();
        while (iter.hasNext()) {
            DesignElementHandle handle = (DesignElementHandle)iter.next();
            String category = handle.getPrivateStyle().getNumberFormatCategory();
            String pattern = handle.getPrivateStyle().getNumberFormat();
            if ((baseCategory == null && category == null || baseCategory != null && baseCategory.equals(category)) && (basePattern == null && pattern == null || basePattern != null && basePattern.equals(pattern))) continue;
            return null;
        }
        return new String[]{baseCategory, basePattern};
    }

    protected void refreshValues(Set propertiesSet) {
        this.doLoad();
    }
}

