/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.LayoutTable;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.HighlightRuleBuilder;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class HighlightsPage
extends AttributePage {
    private TableViewer fTableViewer;
    private Button fAddButton;
    private Button fDeleteButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private PreviewLabel previewLabel;
    private HighlightHandleProvider provider = new HighlightHandleProvider();

    public HighlightsPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        GridLayout layout = UIUtil.createGridLayoutWithoutMargin(2, false);
        layout.horizontalSpacing = 10;
        this.setLayout((Layout)layout);
        Composite buttons = new Composite((Composite)this, 0);
        GridData data = new GridData(768);
        buttons.setLayoutData((Object)data);
        buttons.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(5, false));
        Label lb = new Label(buttons, 0);
        lb.setText(Messages.getString((String)"HighlightsPage.Label.Highlights"));
        lb.setLayoutData((Object)new GridData(800));
        this.fAddButton = new Button(buttons, 2048);
        this.fAddButton.setText(Messages.getString((String)"HighlightsPage.Button.Add"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fAddButton.computeSize((int)-1, (int)-1).x, 60);
        this.fAddButton.setLayoutData((Object)data);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPage.this.add();
            }
        });
        this.fDeleteButton = new Button(buttons, 2048);
        this.fDeleteButton.setText(Messages.getString((String)"HighlightsPage.Button.Delete"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fDeleteButton.computeSize((int)-1, (int)-1).x, 60);
        this.fDeleteButton.setLayoutData((Object)data);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPage.this.delete();
            }
        });
        this.fMoveUpButton = new Button(buttons, 2048);
        this.fMoveUpButton.setText(Messages.getString((String)"FormPage.Button.Up"));
        this.fMoveUpButton.setToolTipText(Messages.getString((String)"HighlightsPage.toolTipText.MoveUp"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fMoveUpButton.computeSize((int)-1, (int)-1).x, 60);
        this.fMoveUpButton.setLayoutData((Object)data);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPage.this.moveUp();
            }
        });
        this.fMoveDownButton = new Button(buttons, 2048);
        this.fMoveDownButton.setText(Messages.getString((String)"FormPage.Button.Down"));
        this.fMoveDownButton.setToolTipText(Messages.getString((String)"HighlightsPage.toolTipText.MoveDown"));
        data = new GridData(128);
        data.widthHint = Math.max(this.fMoveDownButton.computeSize((int)-1, (int)-1).x, 60);
        this.fMoveDownButton.setLayoutData((Object)data);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightsPage.this.moveDown();
            }
        });
        new Label((Composite)this, 0).setText(Messages.getString((String)"HighlightsPage.TableColumn.Preview"));
        LayoutTable table = new LayoutTable(this, new LayoutTable.ColumnsDescription(new String[]{Messages.getString((String)"HighlightsPage.TableColumn.Condition")}, true), 67584);
        table.setLayoutData(new GridData(1808));
        this.fTableViewer = new TableViewer(table.getTable());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new HighlightLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new HighlightContentProvider());
        this.fTableViewer.setSorter(null);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HighlightsPage.this.updateButtons();
                HighlightsPage.this.refreshTableItemView();
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HighlightsPage.this.edit();
            }
        });
        this.fTableViewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 127) {
                    HighlightsPage.this.delete();
                }
            }
        });
        this.previewLabel = new PreviewLabel(this, 2048);
        this.previewLabel.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.PreviewContent"));
        this.previewLabel.setLayoutData(new GridData(1808));
        this.updateButtons();
    }

    private void enableUI(boolean enabled) {
        if (this.fTableViewer != null) {
            this.fAddButton.setEnabled(enabled);
            this.fDeleteButton.setEnabled(enabled);
            this.fMoveUpButton.setEnabled(enabled);
            this.fMoveDownButton.setEnabled(enabled);
            this.fTableViewer.getTable().setEnabled(enabled);
            if (enabled) {
                this.updateButtons();
            }
        }
    }

    public void setInput(List elements) {
        if (elements.size() != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        super.setInput(elements);
        this.fTableViewer.setInput((Object)elements);
        this.refreshTableItemView();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.fTableViewer.getContentProvider() == null) {
            return;
        }
        if (this.fTableViewer != null) {
            this.fTableViewer.setInput((Object)this.input);
            this.refreshTableItemView();
        }
    }

    private void updateButtons() {
        this.fDeleteButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveUpButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() > 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount());
        this.fMoveDownButton.setEnabled(this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount() - 1);
    }

    private void refreshTableItemView() {
        for (int i = 0; i < this.fTableViewer.getTable().getItemCount(); ++i) {
            TableItem ti = this.fTableViewer.getTable().getItem(i);
            HighlightRuleHandle handle = (HighlightRuleHandle)ti.getData();
            ti.setText(0, this.provider.getColumnText(handle, 1));
        }
        if (this.fTableViewer.getTable().getSelectionIndex() >= 0) {
            this.updatePreview((HighlightRuleHandle)this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData());
        } else {
            this.updatePreview(null);
        }
    }

    private void updatePreview(HighlightRuleHandle hrhandle) {
        if (hrhandle != null) {
            String familyValue = this.getFontFamily(hrhandle);
            int sizeValue = this.getFontSize(hrhandle);
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setBold("bold".equals(hrhandle.getFontWeight()));
            this.previewLabel.setItalic("italic".equals(hrhandle.getFontStyle()));
            this.previewLabel.setForeground(ColorManager.getColor((int)hrhandle.getColor().getRGB()));
            this.previewLabel.setBackground(ColorManager.getColor((int)hrhandle.getBackgroundColor().getRGB()));
            this.previewLabel.setUnderline("underline".equals(hrhandle.getTextUnderline()));
            this.previewLabel.setLinethrough("line-through".equals(hrhandle.getTextLineThrough()));
            this.previewLabel.updateView();
        } else {
            this.previewLabel.restoreDefaultState();
            this.previewLabel.setForeground(ColorManager.getColor((int)-1));
            this.previewLabel.setBackground(ColorManager.getColor((int)-1));
            this.previewLabel.updateView();
        }
    }

    private String getFontFamily(HighlightRuleHandle hrhandle) {
        String rfm = hrhandle.getFontFamilyHandle().getStringValue();
        if (rfm == null || rfm.length() == 0) {
            rfm = this.provider.getDesignElementHandle() != null ? this.provider.getDesignElementHandle().getPrivateStyle().getFontFamilyHandle().getStringValue() : "serif";
        }
        return HighlightHandleProvider.getFontFamily(rfm);
    }

    private int getFontSize(HighlightRuleHandle hrhandle) {
        String rfs = hrhandle.getFontSize().getStringValue();
        if ((rfs == null || rfs.length() == 0) && this.provider.getDesignElementHandle() != null) {
            rfs = this.provider.getDesignElementHandle().getPrivateStyle().getFontSize().getStringValue();
        }
        return DEUtil.getFontSize((String)rfs);
    }

    private void add() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.Add"));
            HighlightRuleBuilder builder = new HighlightRuleBuilder(this.getShell(), Messages.getString((String)"HighlightsPage.Dialog.NewHighlight"), this.provider);
            builder.updateHandle(null, this.fTableViewer.getTable().getItemCount());
            builder.setDesignHandle(this.provider.getDesignElementHandle());
            if (builder.open() == 0) {
                int itemCount = this.fTableViewer.getTable().getItemCount();
                this.fTableViewer.getTable().deselectAll();
                this.fTableViewer.getTable().select(itemCount - 1);
                this.fTableViewer.getTable().setFocus();
                this.updateButtons();
                this.refreshTableItemView();
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
    }

    private void edit() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.Edit"));
            if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
                HighlightRuleBuilder builder = new HighlightRuleBuilder(this.getShell(), Messages.getString((String)"HighlightsPage.Dialog.EditHighlight"), this.provider);
                HighlightRuleHandle handle = (HighlightRuleHandle)this.fTableViewer.getTable().getItem(this.fTableViewer.getTable().getSelectionIndex()).getData();
                builder.updateHandle(handle, this.fTableViewer.getTable().getItemCount());
                builder.setDesignHandle(this.provider.getDesignElementHandle());
                int idx = this.fTableViewer.getTable().getSelectionIndex();
                if (builder.open() == 0) {
                    this.fTableViewer.getTable().select(idx);
                    this.fTableViewer.getTable().setFocus();
                    this.updateButtons();
                    this.refreshTableItemView();
                }
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.Delete"));
            if (this.fTableViewer.getTable().getSelectionIndex() >= 0 && this.fTableViewer.getTable().getSelectionIndex() < this.fTableViewer.getTable().getItemCount()) {
                int idx = this.fTableViewer.getTable().getSelectionIndex();
                this.provider.doDeleteItem(idx);
                if (idx >= this.fTableViewer.getTable().getItemCount()) {
                    --idx;
                }
                this.fTableViewer.getTable().select(idx);
                this.fTableViewer.getTable().setFocus();
                this.updateButtons();
                this.refreshTableItemView();
            }
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        finally {
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUp() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.MoveUp"));
            int index = this.fTableViewer.getTable().getSelectionIndex();
            this.provider.doSwapItem(index, -1);
            this.fTableViewer.getTable().select(index - 1);
            this.fTableViewer.getTable().setFocus();
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        finally {
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDown() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        try {
            stack.startTrans(Messages.getString((String)"HighlightsPage.trans.MoveDown"));
            int index = this.fTableViewer.getTable().getSelectionIndex();
            this.provider.doSwapItem(index, 1);
            this.fTableViewer.getTable().select(index + 1);
            this.fTableViewer.getTable().setFocus();
            stack.commit();
        }
        catch (Exception e) {
            stack.rollback();
            ExceptionHandler.handle(e);
        }
        finally {
            this.updateButtons();
            this.refreshTableItemView();
        }
    }

    class HighlightContentProvider
    implements IStructuredContentProvider {
        HighlightContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = HighlightsPage.this.provider.getElements(inputElement);
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof DesignElementHandle)) continue;
                DesignElementHandle element = (DesignElementHandle)elements[i];
                element.removeListener((org.eclipse.birt.report.model.api.core.Listener)HighlightsPage.this);
                element.addListener((org.eclipse.birt.report.model.api.core.Listener)HighlightsPage.this);
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
            Object[] elements = HighlightsPage.this.provider.getElements(HighlightsPage.this.input);
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof DesignElementHandle)) continue;
                DesignElementHandle element = (DesignElementHandle)elements[i];
                element.removeListener((org.eclipse.birt.report.model.api.core.Listener)HighlightsPage.this);
            }
        }
    }

    class HighlightLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        HighlightLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return HighlightsPage.this.provider.getColumnText(element, 1);
        }
    }
}

