/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HyperLinkPage
extends AttributePage {
    private static final String LABEL_LINK_TO = Messages.getString((String)"HyperLinkPage.Label.LnikTo");
    private static final String LABEL_NONE = Messages.getString((String)"HyperLinkPage.Label.None");
    private Text previewText;
    private boolean needRefresh = true;
    protected IChoiceSet choiceSet;

    public HyperLinkPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        this.setLayout((Layout)WidgetUtil.createGridLayout(3));
        Label label = new Label((Composite)this, 0);
        label.setText(LABEL_LINK_TO);
        this.previewText = new Text((Composite)this, 2056);
        GridData gd = new GridData();
        gd.widthHint = 250;
        this.previewText.setLayoutData((Object)gd);
        Button builder = new Button((Composite)this, 8);
        builder.setText("...");
        builder.setToolTipText(Messages.getString((String)"HyperLinkPage.toolTipText.Button"));
        builder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder dialog = new HyperlinkBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                HyperLinkPage.this.getActionStack().startTrans(Messages.getString((String)"HyperLinkPage.Menu.Save"));
                ActionHandle handle = HyperLinkPage.this.getActionHandle();
                if (handle == null) {
                    try {
                        handle = DEUtil.setAction((ReportItemHandle)((ReportItemHandle)HyperLinkPage.this.input.get(0)), (Action)StructureFactory.createAction());
                    }
                    catch (SemanticException e1) {
                        HyperLinkPage.this.getActionStack().rollback();
                        ExceptionHandler.handle(e1);
                        return;
                    }
                }
                dialog.setInput(handle);
                HyperLinkPage.this.needRefresh = false;
                boolean isOK = dialog.open() == 0;
                HyperLinkPage.this.needRefresh = true;
                if (isOK) {
                    HyperLinkPage.this.getActionStack().commit();
                    HyperLinkPage.this.refreshValues(null);
                } else {
                    HyperLinkPage.this.getActionStack().rollback();
                }
            }
        });
    }

    public void setInput(List elements) {
        this.deRegisterListeners();
        this.input = elements;
        Object[] descriptors = this.propertiesMap.values().toArray();
        for (int i = 0; i < descriptors.length; ++i) {
            IPropertyDescriptor descriptor = (IPropertyDescriptor)descriptors[i];
            descriptor.setModelList(elements);
        }
        this.refreshValues(null);
        this.registerListeners();
    }

    protected void refreshValues(Set propertiesSet) {
        if (this.needRefresh) {
            this.doLoad(this.getActionHandle());
        }
    }

    private ActionHandle getActionHandle() {
        return DEUtil.getActionHandle((ReportItemHandle)((ReportItemHandle)this.input.get(0)));
    }

    private void doLoad(ActionHandle handle) {
        if (handle != null) {
            String previewString = null;
            if ("hyperlink".equals(handle.getLinkType())) {
                previewString = handle.getURI();
            } else if ("bookmark-link".equals(handle.getLinkType())) {
                previewString = handle.getTargetBookmark();
            } else if ("drill-through".equals(handle.getLinkType())) {
                previewString = handle.getReportName();
                if (handle.getTargetBookmark() != null) {
                    previewString = previewString + ":" + handle.getTargetBookmark();
                }
            }
            if (previewString == null) {
                previewString = LABEL_NONE;
            }
            this.previewText.setText(previewString);
        } else {
            this.setDefaultUI();
        }
    }

    protected void setDefaultUI() {
        this.previewText.setText(LABEL_NONE);
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }
}

