/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ModulePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.IReportGraphicConstants;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LibraryPage
extends ModulePage {
    private Text namespace;
    private Label[] labels;

    public LibraryPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        super.buildUI();
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "ReportDesign", "iconFile", 3, 500);
        final Text prvImageText = (Text)((IPropertyDescriptor)this.propertiesMap.get("iconFile")).getControl();
        Button browse = new Button((Composite)this, 8);
        browse.setText(Messages.getString((String)"ReportPage.text.Browse"));
        GridData data = new GridData();
        data.widthHint = Math.max(browse.computeSize((int)-1, (int)-1).x, 60);
        browse.setLayoutData((Object)data);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(LibraryPage.this.getShell());
                dlg.setText(Messages.getString((String)"ReportPage.title.setPrewImg"));
                dlg.setFilterNames(IReportGraphicConstants.IMAGE_FILTER_NAMES);
                dlg.setFilterExtensions(IReportGraphicConstants.IMAGE_FILTER_EXTS);
                try {
                    String fileName = dlg.open();
                    if (fileName == null) {
                        return;
                    }
                    prvImageText.setText(fileName);
                    prvImageText.setFocus();
                }
                catch (Exception e1) {
                    return;
                }
            }
        });
        this.labels = new Label[3];
        this.labels[0] = WidgetUtil.createHorizontalLine(this, 5);
        this.labels[1] = new Label((Composite)this, 0);
        this.labels[1].setText(Messages.getString((String)"LibraryPage.Label.Namespace"));
        this.namespace = new Text((Composite)this, 2060);
        GridData gd = new GridData();
        gd.widthHint = 500;
        gd.horizontalSpan = 3;
        this.namespace.setLayoutData((Object)gd);
        this.labels[2] = WidgetUtil.createGridPlaceholder(this, 1, true);
    }

    protected void refreshValues(Set propertiesSet) {
        LibraryHandle handle;
        super.refreshValues(propertiesSet);
        boolean visible = false;
        if (this.input.size() == 1 && this.input.get(0) instanceof LibraryHandle && DEUtil.isIncluded((LibraryHandle)(handle = (LibraryHandle)this.input.get(0)))) {
            this.namespace.setText(handle.getNamespace());
            visible = true;
        }
        this.setControlVisible(visible);
    }

    private void setControlVisible(boolean visible) {
        this.namespace.setVisible(visible);
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setVisible(visible);
        }
    }
}

