/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;

public class DataSetColumnBindingsFormHandleProvider
implements IFormHandleProvider {
    private static final String ALL = Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.ALL");
    private static final String NONE = Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.NONE");
    private String[] columnNames = new String[]{Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.displayName"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Expression"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.AggregateOn")};
    private CellEditor[] editors;
    private static int[] columnWidth = new int[]{150, 150, 150, 150, 150};
    private ReportElementHandle bindingObject;
    private static final IChoice[] DATA_TYPE_CHOICES = DEUtil.getMetaDataDictionary().getStructure("DataSetParam").getMember("dataType").getAllowedChoices().getChoices();
    private List groupList = null;
    private IExpressionProvider expressionProvider;
    private TableViewer viewer;

    public ReportElementHandle getBindingObject() {
        return this.bindingObject;
    }

    public void setBindingObject(ReportElementHandle bindingObject) {
        this.bindingObject = bindingObject;
        this.groupList = DEUtil.getGroups((DesignElementHandle)bindingObject);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public String getTitle() {
        return Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.TableTitle");
    }

    public CellEditor[] getEditors(Table table) {
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        if (pos > -1) {
            if (this.bindingObject instanceof ReportItemHandle) {
                ((ReportItemHandle)this.bindingObject).getColumnBindings().getAt(pos).drop();
                return true;
            }
            if (this.bindingObject instanceof GroupHandle) {
                ((GroupHandle)this.bindingObject).getColumnBindings().getAt(pos).drop();
                return true;
            }
        }
        return false;
    }

    public boolean doAddItem(int pos) throws Exception {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog();
        dialog.setInput((ReportItemHandle)this.bindingObject);
        if (dialog.open() == 0 && this.viewer != null) {
            this.viewer.refresh(true);
            return true;
        }
        return false;
    }

    public boolean doEditItem(int pos) {
        ComputedColumnHandle bindingHandle = null;
        if (pos > -1) {
            if (this.bindingObject instanceof ReportItemHandle) {
                bindingHandle = (ComputedColumnHandle)((ReportItemHandle)this.bindingObject).getColumnBindings().getAt(pos);
            }
            if (this.bindingObject instanceof GroupHandle) {
                bindingHandle = (ComputedColumnHandle)((GroupHandle)this.bindingObject).getColumnBindings().getAt(pos);
            }
        }
        if (bindingHandle == null) {
            return false;
        }
        DataColumnBindingDialog dialog = new DataColumnBindingDialog();
        dialog.setInput((ReportItemHandle)this.bindingObject, bindingHandle);
        if (dialog.open() == 0 && this.viewer != null) {
            this.viewer.refresh(true);
            return true;
        }
        return false;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((ComputedColumnHandle)element).getName();
            }
            case 1: {
                return ((ComputedColumnHandle)element).getDisplayName();
            }
            case 2: {
                return this.getDataTypeDisplayName(((ComputedColumnHandle)element).getDataType());
            }
            case 3: {
                return ((ComputedColumnHandle)element).getExpression();
            }
            case 4: {
                String value = ((ComputedColumnHandle)element).getAggregrateOn();
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                String text = value == null ? (ExpressionUtil.hasAggregation((String)((ComputedColumnHandle)element).getExpression()) && groupType != "none" ? ALL : NONE) : value;
                return text;
            }
        }
        return null;
    }

    private String getDataTypeDisplayName(String dataType) {
        for (int i = 0; i < DATA_TYPE_CHOICES.length; ++i) {
            IChoice choice = DATA_TYPE_CHOICES[i];
            if (!choice.getName().equals(dataType)) continue;
            return choice.getDisplayName();
        }
        return dataType;
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[] && ((Object[])inputElement).length > 0) {
            return this.getElements(((Object[])inputElement)[0]);
        }
        if (inputElement instanceof List) {
            return this.getElements(((List)inputElement).get(0));
        }
        if (inputElement instanceof ReportItemHandle) {
            ReportItemHandle reportHandle = (ReportItemHandle)inputElement;
            this.bindingObject = reportHandle;
            ArrayList children = new ArrayList();
            Iterator iter = reportHandle.getColumnBindings().iterator();
            while (iter.hasNext()) {
                children.add(iter.next());
            }
            return children.toArray();
        }
        if (inputElement instanceof GroupHandle) {
            GroupHandle groupHandle = (GroupHandle)inputElement;
            this.bindingObject = groupHandle;
            ArrayList children = new ArrayList();
            Iterator iter = groupHandle.getColumnBindings().iterator();
            while (iter.hasNext()) {
                children.add(iter.next());
            }
            return children.toArray(new ComputedColumnHandle[children.size()]);
        }
        return new Object[0];
    }

    public boolean canModify(Object element, String property) {
        ComputedColumnHandle handle;
        return !this.columnNames[3].equals(property) || ExpressionUtil.hasAggregation((String)(handle = (ComputedColumnHandle)element).getExpression()) && !DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject).equals("none");
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        if (value == null) {
            return false;
        }
        int index = Arrays.asList(this.columnNames).indexOf(property);
        switch (index) {
            case 0: {
                if (((ComputedColumnHandle)data).getName() != null && ((ComputedColumnHandle)data).getName().equals(value.toString().trim())) break;
                ((ComputedColumnHandle)data).setName(value.toString());
                break;
            }
            case 1: {
                ((ComputedColumnHandle)data).setDataType(this.getDataType(value.toString()));
                break;
            }
            case 2: {
                if (((ComputedColumnHandle)data).getExpression() != null && ((ComputedColumnHandle)data).getExpression().equals((String)value)) break;
                ((ComputedColumnHandle)data).setExpression(value.toString());
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                if (ExpressionUtil.hasAggregation((String)((ComputedColumnHandle)data).getExpression())) {
                    if (groupType.equals("group")) {
                        ((ComputedColumnHandle)data).setAggregrateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)this.bindingObject).get(0)).getName());
                    } else if (groupType.equals("listing")) {
                        ((ComputedColumnHandle)data).setAggregrateOn(null);
                    }
                }
                if (ExpressionUtil.hasAggregation((String)((ComputedColumnHandle)data).getExpression()) && !groupType.equals("none")) break;
                ((ComputedColumnHandle)data).setAggregrateOn(null);
                break;
            }
            case 3: {
                if (ALL.equals(value.toString())) {
                    ((ComputedColumnHandle)data).setAggregrateOn(null);
                    break;
                }
                ((ComputedColumnHandle)data).setAggregrateOn(value.toString());
                break;
            }
        }
        return false;
    }

    private String getDataType(String value) {
        for (int i = 0; i < DATA_TYPE_CHOICES.length; ++i) {
            IChoice choice = DATA_TYPE_CHOICES[i];
            if (!choice.getDisplayName().equals(value)) continue;
            return choice.getName();
        }
        return value;
    }

    public boolean needRefreshed(NotificationEvent event) {
        PropertyEvent ev;
        String propertyName;
        return event.getEventType() == 5 && ("boundDataColumns".equals(propertyName = (ev = (PropertyEvent)event).getPropertyName()) || "dataSet".equals(propertyName));
    }

    public void generateAllBindingColumns() {
        if (this.bindingObject != null) {
            DataSetHandle datasetHandle = null;
            if (this.bindingObject instanceof ReportItemHandle) {
                datasetHandle = ((ReportItemHandle)this.bindingObject).getDataSet();
            } else if (this.bindingObject instanceof GroupHandle) {
                datasetHandle = ((ReportItemHandle)((GroupHandle)this.bindingObject).getContainer()).getDataSet();
            }
            if (datasetHandle != null) {
                try {
                    CachedMetaDataHandle cmdh = DataSetUIUtil.getCachedMetaDataHandle(datasetHandle);
                    Iterator iter = cmdh.getResultSet().iterator();
                    while (iter.hasNext()) {
                        ResultSetColumnHandle element = (ResultSetColumnHandle)iter.next();
                        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.bindingObject, (String)element.getColumnName());
                        bindingColumn.setDataType(element.getDataType());
                        String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                        List groupList = DEUtil.getGroups((DesignElementHandle)this.bindingObject);
                        if (!this.isExpressionExisit(DEUtil.getExpression((Object)element))) {
                            bindingColumn.setExpression(DEUtil.getExpression((Object)element));
                            if (this.bindingObject instanceof ReportItemHandle) {
                                ((ReportItemHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                                continue;
                            }
                            if (this.bindingObject instanceof GroupHandle) {
                                ((GroupHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                            }
                        }
                        if (!ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) continue;
                        if (groupType.equals("group")) {
                            bindingColumn.setAggregrateOn(((GroupHandle)groupList.get(0)).getName());
                            continue;
                        }
                        if (!groupType.equals("listing")) continue;
                        bindingColumn.setAggregrateOn(null);
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
        }
    }

    public void removedUnusedColumnBindings(List inputElement) {
        Object element;
        if (inputElement.size() > 0 && (element = inputElement.get(0)) instanceof ReportElementHandle) {
            try {
                if (element instanceof GroupHandle) {
                    DesignElementHandle parentHandle = ((GroupHandle)element).getContainer();
                    if (parentHandle instanceof ReportItemHandle) {
                        ((ReportItemHandle)parentHandle).removedUnusedColumnBindings();
                    }
                } else if (element instanceof ReportItemHandle) {
                    ((ReportItemHandle)element).removedUnusedColumnBindings();
                }
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isExpressionExisit(String expression) {
        if (this.bindingObject != null) {
            Iterator iter;
            if (this.bindingObject instanceof ReportItemHandle) {
                iter = ((ReportItemHandle)this.bindingObject).getColumnBindings().iterator();
                while (iter.hasNext()) {
                    if (!expression.equals(((ComputedColumnHandle)iter.next()).getExpression())) continue;
                    return true;
                }
            }
            if (this.bindingObject instanceof GroupHandle) {
                iter = ((GroupHandle)this.bindingObject).getColumnBindings().iterator();
                while (iter.hasNext()) {
                    if (!expression.equals(((ComputedColumnHandle)iter.next()).getExpression())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setExpressionProvider(IExpressionProvider expressionProvider) {
        this.expressionProvider = expressionProvider;
    }

    public void setTableViewer(TableViewer viewer) {
        this.viewer = viewer;
    }
}

