/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.dialogs.MapRuleBuilder;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class MapHandleProvider {
    private static final MapRuleHandle[] EMPTY = new MapRuleHandle[0];
    private DesignElementHandle elementHandle;

    public DesignElementHandle getDesignElementHandle() {
        return this.elementHandle;
    }

    public String getColumnText(Object element, int columnIndex) {
        MapRuleHandle handle = (MapRuleHandle)element;
        switch (columnIndex) {
            case 0: {
                String pv = handle.getDisplay();
                return pv == null ? "" : pv;
            }
            case 1: {
                String exp = this.resolveNull(handle.getTestExpression()) + " " + MapRuleBuilder.getNameForOperator(handle.getOperator());
                int vv = MapRuleBuilder.determineValueVisible(handle.getOperator());
                if (vv == 1) {
                    exp = exp + " " + this.resolveNull(handle.getValue1());
                } else if (vv == 2) {
                    exp = exp + " " + this.resolveNull(handle.getValue1()) + " , " + this.resolveNull(handle.getValue2());
                }
                return exp;
            }
        }
        return "";
    }

    private String resolveNull(String src) {
        if (src == null) {
            return "";
        }
        return src;
    }

    public boolean doSwapItem(int pos, int direction) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        if (direction < 0) {
            phandle.moveItem(pos, pos - 1);
        } else {
            phandle.moveItem(pos, pos + 1);
        }
        return true;
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        phandle.removeItem(pos);
        return true;
    }

    public MapRuleHandle doAddItem(MapRule rule, int pos) {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        try {
            phandle.addItem((IStructure)rule);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        StructureHandle handle = rule.getHandle((SimpleValueHandle)phandle, pos);
        return (MapRuleHandle)handle;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).size() > 0 ? ((List)inputElement).get(0) : null;
        }
        if (inputElement instanceof DesignElementHandle) {
            this.elementHandle = (DesignElementHandle)inputElement;
            PropertyHandle mapRules = this.elementHandle.getPropertyHandle("mapRules");
            ArrayList list = new ArrayList();
            Iterator itr = mapRules.iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                list.add(o);
            }
            return list.toArray(new MapRuleHandle[0]);
        }
        return EMPTY;
    }
}

