/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExpressionPropertyDescriptor
extends AbstractPropertyDescriptor {
    protected Text text;
    protected Button button;
    private Composite containerPane;
    private String deValue;
    private String newValue;

    public ExpressionPropertyDescriptor() {
    }

    public ExpressionPropertyDescriptor(PropertyProcessor processor) {
        super(processor);
    }

    public void resetUIData() {
        this.deValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        List lst = this.getModelList();
        if (lst == null) {
            this.button.setEnabled(false);
            this.text.setEnabled(false);
        }
        if (this.deValue == null) {
            this.deValue = "";
        }
        if (!this.text.getText().equals(this.deValue)) {
            this.text.setText(this.deValue);
        }
    }

    public Control getControl() {
        return this.containerPane;
    }

    public Control createControl(Composite parent) {
        this.containerPane = new Composite(parent, 0);
        this.containerPane.setLayout((Layout)new GridLayout());
        this.text = new Text(this.containerPane, 2882);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExpressionPropertyDescriptor.this.newValue = ExpressionPropertyDescriptor.this.text.getText();
                ExpressionPropertyDescriptor.this.processAction();
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ExpressionPropertyDescriptor.this.newValue = ExpressionPropertyDescriptor.this.text.getText();
                ExpressionPropertyDescriptor.this.processAction();
            }
        });
        this.button = new Button(this.containerPane, 8);
        this.button.setText(Messages.getString((String)"ExpressionPropertyDescriptor.text.Edit"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder builder = new ExpressionBuilder(ExpressionPropertyDescriptor.this.button.getShell(), ExpressionPropertyDescriptor.this.deValue);
                List lst = ExpressionPropertyDescriptor.this.getModelList();
                if (lst != null && lst.size() == 1) {
                    DesignElementHandle elementHandle = (DesignElementHandle)lst.get(0);
                    builder.setExpressionProvier(new ExpressionProvider(elementHandle));
                }
                if (builder.open() == 0) {
                    ExpressionPropertyDescriptor.this.newValue = builder.getResult();
                    ExpressionPropertyDescriptor.this.processAction();
                }
            }
        });
        return this.containerPane;
    }

    private void processAction() {
        String value = this.newValue;
        if (value != null && value.length() == 0) {
            value = null;
        }
        if (value == null && this.deValue != null || value != null && !value.equals(this.deValue)) {
            try {
                this.getPropertyProcessor().setStringValue(value, this.getModelList());
                this.text.setText(UIUtil.convertToGUIString(value));
            }
            catch (SemanticException e1) {
                this.text.setText(UIUtil.convertToGUIString(this.deValue));
                WidgetUtil.processError(this.text.getShell(), (Exception)((Object)e1));
            }
        }
    }
}

