/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.IValueChangedListener;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    private static final String DLG_TITLE_INVALID_NUMBER = Messages.getString((String)"Spinner.DialogTitle.InvalidNumber");
    private static final int BUTTON_WIDTH = 16;
    private Text text;
    private Button up;
    private Button down;
    private double minimum = 0.0;
    private double maximum = 9.0;
    private double step = 1.0;
    private NumberFormatter formatter = new NumberFormatter(SessionHandleAdapter.getInstance().getSessionHandle().getLocale());
    private List listeners = new ArrayList();
    private double validValue;
    private boolean isInErrrorHandle;

    public Spinner(Composite parent, int style) {
        super(parent, style);
        this.text = new Text((Composite)this, style | 4 | 0x800);
        this.up = new Button((Composite)this, style | 4 | 0x80);
        this.down = new Button((Composite)this, style | 4 | 0x400);
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.traverse(e);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 4) {
                    Spinner.this.fireValueChanged();
                }
                if (e.keyCode == 0x1000001) {
                    Spinner.this.up();
                    Spinner.this.fireValueChanged();
                }
                if (e.keyCode == 0x1000002) {
                    Spinner.this.down();
                    Spinner.this.fireValueChanged();
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    Spinner.this.fireValueChanged();
                }
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!Spinner.this.isInErrrorHandle) {
                    Spinner.this.fireValueChanged();
                }
            }
        });
        this.up.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.up();
                Spinner.this.fireValueChanged();
            }
        });
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.down();
                Spinner.this.fireValueChanged();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.resize();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                Spinner.this.focusIn();
            }
        });
        this.text.setFont(this.getFont());
        this.setSelection(this.minimum);
        this.initAccessible();
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                this.getHelp(e);
            }

            public void getHelp(AccessibleEvent e) {
                e.result = Spinner.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.up.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.down.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = Spinner.this.text.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = Spinner.this.toControl(new Point(e.x, e.y));
                e.childID = Spinner.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = Spinner.this.getBounds();
                Point pt = Spinner.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }

    protected void fireValueChanged() {
        if (!this.verify(this.text.getText())) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((IValueChangedListener)this.listeners.get(i)).valueChanged(this.getSelection());
        }
    }

    public void addValueChangeListener(IValueChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangedListener(IValueChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setFormatPattern(String pattern) {
        this.formatter.applyPattern(pattern);
    }

    private boolean verify(String value) {
        try {
            this.validValue = this.parse(value);
            if (this.validValue < this.minimum) {
                this.validValue = this.minimum;
            }
            if (this.validValue > this.maximum) {
                this.validValue = this.maximum;
            }
            this.text.setText(this.formatter.format(this.validValue));
            return true;
        }
        catch (ParseException ex) {
            this.isInErrrorHandle = true;
            ExceptionHandler.openErrorMessageBox(DLG_TITLE_INVALID_NUMBER, ex.getLocalizedMessage());
            this.isInErrrorHandle = false;
            this.text.setText(this.formatter.format(this.validValue));
            if (!this.text.isDisposed()) {
                this.focusIn();
            }
            return false;
        }
    }

    protected void traverse(Event e) {
        switch (e.detail) {
            case 32: {
                if (e.keyCode != 0x1000001) break;
                e.doit = true;
                e.detail = 0;
                this.up();
                break;
            }
            case 64: {
                if (e.keyCode != 0x1000002) break;
                e.doit = true;
                e.detail = 0;
                this.down();
            }
        }
    }

    protected void up() {
        this.setSelection(this.getSelection() + this.step);
        this.notifyListeners(13, new Event());
    }

    protected void down() {
        this.setSelection(this.getSelection() - this.step);
        this.notifyListeners(13, new Event());
    }

    protected void focusIn() {
        this.text.setFocus();
        this.text.setSelection(0, this.text.getText().length());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }

    public void setSelection(double selection) {
        if (selection < this.minimum) {
            selection = this.minimum;
        } else if (selection > this.maximum) {
            selection = this.maximum;
        }
        this.text.setText(this.formatter.format(selection));
        this.validValue = selection;
    }

    public double getSelection() {
        try {
            return this.parse(this.text.getText());
        }
        catch (ParseException e) {
            ExceptionHandler.handle(e);
            return this.minimum;
        }
    }

    public void setMaximum(double maximum) {
        this.checkWidget();
        this.maximum = maximum;
        this.resize();
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    protected void resize() {
        Point pt = this.computeSize(-1, -1);
        int textWidth = pt.x - 16;
        this.text.setBounds(0, 0, textWidth, pt.y);
        int buttonHeight = pt.y / 2;
        this.up.setBounds(textWidth, 0, 16, buttonHeight);
        this.down.setBounds(textWidth, pt.y - buttonHeight, 16, buttonHeight);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this.text);
        Point textExtent = gc.textExtent(this.formatter.format(this.maximum));
        gc.dispose();
        Point pt = this.text.computeSize(textExtent.x, textExtent.y);
        int width = pt.x + 16;
        int height = pt.y;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new SWTError(4);
        }
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.up.setEnabled(enabled);
        this.down.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public String getText() {
        return this.text.getText();
    }

    private double parse(String value) throws ParseException {
        if (StringUtil.isBlank((String)value)) {
            return 0.0;
        }
        return this.formatter.parse(value).doubleValue();
    }
}

