/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.IValueChangedListener;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.Spinner;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SpinnerPropertyDescriptor
extends AbstractPropertyDescriptor {
    protected Spinner spinner;
    protected Combo combo;
    protected Composite container;
    protected IChoiceSet choiceSet;

    public SpinnerPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        String comboValue;
        IChoice choice;
        boolean stateFlag;
        String value = this.getPropertyProcessor().getStringValue(this.getModelList());
        boolean bl = stateFlag = value == null == this.spinner.getEnabled();
        if (stateFlag) {
            this.spinner.setEnabled(value != null);
            this.combo.setEnabled(value != null);
        }
        if (value == null) {
            return;
        }
        String spinnerValue = this.getPropertyProcessor().getMeasureValue(this.getModelList());
        double doubleValue = Double.parseDouble(spinnerValue);
        if (Math.abs(this.spinner.getSelection() - doubleValue) > 0.01) {
            this.spinner.setSelection(doubleValue);
        }
        String[] displayNames = null;
        if (this.choiceSet == null) {
            this.choiceSet = ChoiceSetFactory.getElementChoiceSet(this.getPropertyProcessor().getElementName(), this.getPropertyProcessor().getProperty());
            displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
            this.combo.setItems(displayNames);
        }
        if (displayNames == null) {
            displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
        }
        if ((choice = this.choiceSet.findChoice(comboValue = this.getPropertyProcessor().getUnit(this.getModelList()))) == null) {
            this.combo.deselectAll();
            return;
        }
        if (!choice.getDisplayName().equals(this.combo.getText())) {
            this.combo.deselectAll();
            this.combo.setText(choice.getDisplayName());
        }
    }

    public Control getControl() {
        return this.spinner;
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        this.container.setLayout((Layout)layout);
        this.spinner = new Spinner(this.container, 0);
        this.spinner.setMaximum(100.0);
        this.spinner.setMinimum(-100.0);
        this.spinner.setStep(0.25);
        this.spinner.setSelection(0.0);
        this.spinner.setFormatPattern("0.00");
        this.spinner.addValueChangeListener(new IValueChangedListener(){

            public void valueChanged(double newValue) {
                SpinnerPropertyDescriptor.this.processAction();
            }
        });
        this.combo = new Combo(this.container, 2056);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpinnerPropertyDescriptor.this.processAction();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.spinner, 0, 1024);
        data.left = new FormAttachment((Control)this.spinner, 0, 16384);
        data.right = new FormAttachment((Control)this.spinner, 0, 131072);
        this.combo.setLayoutData((Object)data);
        return this.spinner;
    }

    private void processAction() {
        IChoice choice;
        String value = this.spinner.getText();
        if (this.choiceSet != null && (choice = this.choiceSet.findChoiceByDisplayName(this.combo.getText())) != null) {
            value = value + choice.getName();
        }
        try {
            this.getPropertyProcessor().setStringValue(value, this.getModelList());
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
        }
    }
}

