/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextPropertyDescriptor
extends AbstractPropertyDescriptor {
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private static final IChoiceSet CONTROL_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getChoiceSet("paramControl");
    protected Text text;
    private int style = 2048;
    private String deValue;

    public TextPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void resetUIData() {
        boolean stateFlag;
        String displayName;
        this.deValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        if ("dataType".equals(this.getPropertyProcessor().getProperty())) {
            displayName = DATA_TYPE_CHOICE_SET.findChoice(this.deValue).getDisplayName();
            if (displayName != null) {
                this.deValue = displayName;
            }
        } else if ("controlType".equals(this.getPropertyProcessor().getProperty()) && (displayName = CONTROL_TYPE_CHOICE_SET.findChoice(this.deValue).getDisplayName()) != null) {
            this.deValue = displayName;
        }
        if (this.getModelList().size() > 1) {
            this.text.setText("");
            this.text.setEnabled(false);
            return;
        }
        boolean bl = stateFlag = this.deValue == null == this.text.getEnabled();
        if (stateFlag) {
            this.text.setEnabled(this.deValue != null);
        }
        if (this.getPropertyProcessor().isReadOnly(this.getModelList())) {
            this.text.setEnabled(false);
        }
        if (this.deValue == null) {
            this.deValue = "";
        }
        if (!this.text.getText().equals(this.deValue)) {
            this.text.setText(this.deValue);
        }
    }

    public Control getControl() {
        return this.text;
    }

    public Control createControl(Composite parent) {
        this.text = new Text(parent, this.style);
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TextPropertyDescriptor.this.processAction();
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                TextPropertyDescriptor.this.processAction();
            }
        });
        return this.text;
    }

    private void processAction() {
        String value = this.text.getText();
        if (!value.equals(this.deValue)) {
            if ("controlType".equals(this.getPropertyProcessor().getProperty()) || "dataType".equals(this.getPropertyProcessor().getProperty())) {
                return;
            }
            try {
                this.getPropertyProcessor().setStringValue(value, this.getModelList());
            }
            catch (SemanticException e1) {
                this.text.setText(this.deValue);
                WidgetUtil.processError(this.text.getShell(), (Exception)((Object)e1));
            }
        }
    }
}

