/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dnd.DesignElementDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.IDropConstraint;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;

public class DesignerDropListener
extends DesignElementDropAdapter {
    private int canContain = 0;
    private Object newTarget;
    private Map dropConstraintMap;

    public DesignerDropListener(TreeViewer viewer) {
        super(viewer);
    }

    protected boolean validateTarget(Object target) {
        return true;
    }

    protected boolean validateTarget(Object target, Object transfer) {
        if (target != null) {
            List transferDropConstraintList = this.getDropConstraintList(target.getClass());
            Iterator iter = transferDropConstraintList.iterator();
            while (iter.hasNext()) {
                IDropConstraint constraint = (IDropConstraint)iter.next();
                switch (constraint.validate(transfer, target)) {
                    case 1: {
                        return true;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
        }
        if (DNDUtil.handleValidateTargetCanContainMore((Object)target, (int)DNDUtil.getObjectLength((Object)transfer))) {
            this.canContain = DNDUtil.handleValidateTargetCanContain((Object)target, (Object)transfer, (this.getCurrentLocation() != 3 ? 1 : 0) != 0);
            return this.canContain != 0;
        }
        return false;
    }

    public boolean performDrop(Object data) {
        return super.performDrop(data);
    }

    protected boolean moveData(Object transfer, Object target) {
        int position = this.getPosition(target);
        boolean result = DNDUtil.moveHandles((Object)transfer, (Object)this.newTarget, (int)position);
        if (result) {
            ((StructuredViewer)this.getViewer()).reveal(this.newTarget);
        }
        return result;
    }

    protected boolean ApplyTheme(ThemeHandle themeHandle, ModuleHandle moudelHandle) {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (!(themeHandle.getRoot() instanceof LibraryHandle)) {
            return false;
        }
        LibraryHandle library = (LibraryHandle)themeHandle.getRoot();
        try {
            if (UIUtil.includeLibrary(moduleHandle, library)) {
                UIUtil.applyTheme(themeHandle, moduleHandle, library);
            }
        }
        catch (ExtendsException e) {
            GUIException exception = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e, (String)"Library.DND.messages.outofsync");
            ExceptionHandler.handle((Throwable)exception);
            return false;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return false;
        }
        return true;
    }

    protected boolean copyData(Object transfer, Object target) {
        boolean result;
        block16: {
            int position = this.getPosition(target);
            result = false;
            Object transferFirstElement = this.getSingleTransferData(transfer);
            if (transferFirstElement != null && transferFirstElement instanceof DesignElementHandle) {
                DesignElementHandle sourceHandle = (DesignElementHandle)transferFirstElement;
                if (sourceHandle.getRoot() instanceof LibraryHandle) {
                    LibraryHandle library = (LibraryHandle)sourceHandle.getRoot();
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    try {
                        if (moduleHandle != library) {
                            if (UIUtil.includeLibrary(moduleHandle, library)) {
                                DNDUtil.addElementHandle((Object)this.newTarget, (DesignElementHandle)moduleHandle.getElementFactory().newElementFrom(sourceHandle, sourceHandle.getName()));
                                result = true;
                            }
                            break block16;
                        }
                        result = DNDUtil.copyHandles((Object)transfer, (Object)this.newTarget, (int)position);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                } else {
                    result = DNDUtil.copyHandles((Object)transfer, (Object)this.newTarget, (int)position);
                }
            } else if (transferFirstElement != null && transferFirstElement instanceof EmbeddedImageHandle) {
                EmbeddedImageHandle sourceEmbeddedImageHandle = (EmbeddedImageHandle)transferFirstElement;
                if (sourceEmbeddedImageHandle.getElementHandle().getRoot() instanceof LibraryHandle) {
                    LibraryHandle library = (LibraryHandle)sourceEmbeddedImageHandle.getElementHandle().getRoot();
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    try {
                        if (moduleHandle != library) {
                            if (UIUtil.includeLibrary(moduleHandle, library)) {
                                EmbeddedImage image = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)sourceEmbeddedImageHandle, (ModuleHandle)moduleHandle);
                                DNDUtil.addEmbeddedImageHandle((Object)this.newTarget, (EmbeddedImage)image);
                                result = true;
                            }
                            break block16;
                        }
                        result = DNDUtil.copyHandles((Object)transfer, (Object)this.newTarget, (int)position);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(e);
                    }
                } else {
                    result = DNDUtil.copyHandles((Object)transfer, (Object)this.newTarget, (int)position);
                }
            }
        }
        if (result) {
            ((StructuredViewer)this.getViewer()).reveal(this.newTarget);
        }
        return result;
    }

    private int getPosition(Object target) {
        this.newTarget = target;
        int position = DNDUtil.calculateNextPosition((Object)target, (int)this.canContain);
        if (position > -1) {
            this.newTarget = DNDUtil.getDesignElementHandle((Object)target).getContainerSlotHandle();
            if (this.getCurrentLocation() == 1) {
                --position;
            }
        }
        return position;
    }

    public void dragEnter(DropTargetEvent event) {
        if ((event.operations & 1) != 0 && (event.operations & 2) == 0) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    public void addDropConstraint(Class targetClass, IDropConstraint constraint) {
        this.getDropConstraintList(targetClass).add(constraint);
    }

    private List getDropConstraintList(Object key) {
        List targetClassList;
        if (this.dropConstraintMap == null) {
            this.dropConstraintMap = new HashMap();
        }
        if (this.dropConstraintMap.containsKey(key)) {
            targetClassList = (List)this.dropConstraintMap.get(key);
        } else {
            targetClassList = new ArrayList();
            this.dropConstraintMap.put(key, targetClassList);
        }
        return targetClassList;
    }

    private Object getSingleTransferData(Object template) {
        if (template instanceof Object[]) {
            return ((Object[])template)[0];
        }
        return template;
    }
}

