/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.core.model.views.outline.LibraryNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PublishLibraryToResourceFolderAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshModuleHandleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RemoveLibraryAction;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ReportDesignNodeProvider;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class LibraryNodeProvider
extends ReportDesignNodeProvider {
    public Object[] getChildren(Object model) {
        LibraryHandle handle = (LibraryHandle)model;
        ArrayList<Object> list = new ArrayList<Object>();
        if (handle.getNamespace() == null) {
            list.add(new ReportElementModel(handle.getDataSources()));
            list.add(new ReportElementModel(handle.getDataSets()));
            list.add(new ReportElementModel(handle.getParameters()));
            list.add(new ReportElementModel(handle.getComponents()));
            list.add(new ReportElementModel(handle.getMasterPages()));
            list.add(new ReportElementModel(handle.getThemes()));
            list.add(new EmbeddedImageNode((ModuleHandle)handle));
            list.add(new LibraryNode((ModuleHandle)handle));
        }
        return list.toArray();
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        Object[] inputs;
        menu.add((IAction)new RefreshModuleHandleAction(object));
        if (sourceViewer.getInput() instanceof Object[] && (inputs = (Object[])sourceViewer.getInput()).length == 1 && object instanceof LibraryHandle) {
            LibraryHandle handle = (LibraryHandle)object;
            if (handle.getNamespace() == null) {
                menu.add((IAction)new PublishLibraryToResourceFolderAction(object));
            }
            if (handle.getNamespace() != null) {
                menu.add((IAction)new RemoveLibraryAction(object));
            }
        }
    }

    public String getNodeDisplayName(Object model) {
        LibraryHandle handle = (LibraryHandle)model;
        if (handle.getName() != null && !handle.getName().equals("")) {
            return handle.getName();
        }
        if (handle.getNamespace() != null) {
            return handle.getNamespace();
        }
        return super.getNodeDisplayName(model);
    }

    public Object getParent(Object model) {
        LibraryHandle handle = (LibraryHandle)model;
        if (handle.getNamespace() == null) {
            return null;
        }
        return new LibraryNode(handle.getHostHandle());
    }

    public String getIconName(Object model) {
        LibraryHandle handle = (LibraryHandle)model;
        if (handle.getNamespace() != null) {
            return "Library Referenced";
        }
        return "Library";
    }
}

