/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.Arrays;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class StylesNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"StylesNodeProvider.action.New")));
        super.createContextMenu(sourceViewer, object, menu);
        menu.insertAfter("additions", (IContributionItem)new Separator());
        menu.insertAfter("additions", (IAction)new ImportCSSStyleAction(object));
    }

    public String getNodeDisplayName(Object object) {
        return STYLES;
    }

    public String getIconName(Object model) {
        return "Styles";
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        DesignElementFactory factory = DesignElementFactory.getInstance();
        if ("Style".equals(type)) {
            SharedStyleHandle handle = factory.newStyle(null);
            StyleBuilder builder = new StyleBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (ReportElementHandle)handle, StyleBuilder.DLG_TITLE_NEW);
            if (builder.open() == 1) {
                return null;
            }
            return handle;
        }
        return super.createElement(type);
    }

    public Object[] getChildren(Object model) {
        Object[] styles = ((ReportElementModel)model).getElementHandle().getModuleHandle().getStyles().getContents().toArray();
        Arrays.sort(styles, new AlphabeticallyComparator());
        return styles;
    }
}

