/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionDialogCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.GroupPropertyHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.ComboBoxColorCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.ComboBoxDimensionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DateTimeCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DimensionCellEditor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class PropertyEditorFactory {
    private static PropertyEditorFactory instance;
    private static String[] booleanValues;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PropertyEditorFactory() {
    }

    public static PropertyEditorFactory getInstance() {
        return instance;
    }

    public CellEditor createPropertyEditor(Composite parent, Object o) {
        Object editor = null;
        String[] unitsList = null;
        GroupPropertyHandleProvider handle = GroupPropertyHandleProvider.getInstance();
        if (handle.isReadOnly(o)) {
            return null;
        }
        String[] values = this.getChoiceNames(o);
        String value = ((GroupPropertyHandle)o).getStringValue();
        if (value == null) {
            value = "";
        }
        if (handle.isBooleanProperty(o)) {
            editor = handle.isEditable(o) ? new ComboBoxCellEditor(parent, booleanValues, 0) : new ComboBoxCellEditor(parent, booleanValues, 8);
            editor.setValue(value);
        } else if (handle.isColorProperty(o)) {
            editor = new ComboBoxColorCellEditor(parent, values, 8);
            editor.setValue(value);
        } else if (handle.isDateTimeProperty(o)) {
            editor = new DateTimeCellEditor(parent);
            editor.setValue(value);
        } else if (handle.isFontSizeProperty(o)) {
            editor = new ComboBoxDimensionCellEditor(parent, values);
            editor.setValue(value);
            IChoiceSet choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("units");
            unitsList = ChoiceSetFactory.getNamefromChoiceSet(choiceSet);
            ((ComboBoxDimensionCellEditor)((Object)editor)).setUnitsList(unitsList);
            DimensionValue dimensionValue = null;
            try {
                dimensionValue = DimensionValue.parse((String)value);
                if (dimensionValue != null) {
                    ((ComboBoxDimensionCellEditor)((Object)editor)).setUnits(dimensionValue.getUnits());
                }
            }
            catch (PropertyValueException e) {}
        } else if (handle.isDimensionProperty(o)) {
            IChoiceSet choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("units");
            values = ChoiceSetFactory.getNamefromChoiceSet(choiceSet);
            DimensionValue dimensionValue = null;
            try {
                dimensionValue = DimensionValue.parse((String)value);
            }
            catch (PropertyValueException e) {
                // empty catch block
            }
            editor = handle.isEditable(o) ? new DimensionCellEditor(parent, values, 8) : new DimensionCellEditor(parent, values, 0);
            editor.setValue(value);
            if (dimensionValue != null) {
                ((DimensionCellEditor)((Object)editor)).setUnits(dimensionValue.getUnits());
            }
        } else if (handle.isElementRefValue(o)) {
            GroupPropertyHandle propertyHandle = (GroupPropertyHandle)o;
            List handles = propertyHandle.getReferenceableElementList();
            values = new String[handles.size()];
            for (int i = 0; i < handles.size(); ++i) {
                values[i] = ((DesignElementHandle)handles.get(i)).getQualifiedName();
            }
            ElementPropertyDefn propDefn = (ElementPropertyDefn)propertyHandle.getPropertyDefn();
            ElementDefn elementDefn = (ElementDefn)propDefn.getTargetElementType();
            if (!$assertionsDisabled && elementDefn == null) {
                throw new AssertionError();
            }
            if ("Style".equals(elementDefn.getName())) {
                values = this.filterPreStyles(values);
            }
            editor = new ComboBoxCellEditor(parent, values);
            editor.setValue(value);
        } else if (handle.isExpressionProperty(o)) {
            editor = new ExpressionDialogCellEditor(parent, 8);
            editor.setValue(value);
        } else if (handle.isPassProperty(o)) {
            editor = new TextCellEditor(parent, 0x400000);
            editor.setValue(value);
        } else if (values.length > 0) {
            editor = handle.isEditable(o) ? new ComboBoxCellEditor(parent, values, 0) : new ComboBoxCellEditor(parent, values, 8);
            editor.setValue(value);
        } else {
            editor = new TextCellEditor(parent);
            editor.setValue(value);
        }
        return editor;
    }

    private String[] getChoiceNames(Object o) {
        IChoice[] choices;
        String[] values = null;
        if (o instanceof GroupPropertyHandle && ((GroupPropertyHandle)o).getPropertyDefn().getChoices() != null && (choices = ((GroupPropertyHandle)o).getPropertyDefn().getChoices().getChoices()).length > 0) {
            values = new String[choices.length];
            for (int i = 0; i < choices.length; ++i) {
                values[i] = choices[i].getName();
            }
        }
        if (values == null) {
            return new String[0];
        }
        return values;
    }

    public String getName(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof GroupPropertyHandle) {
            return ((GroupPropertyHandle)o).getPropertyDefn().getName();
        }
        return "nullname";
    }

    public String getTooltip(Object o) {
        return null;
    }

    public String getDisplayName(Object model) {
        if (model instanceof GroupPropertyHandle) {
            return ((GroupPropertyHandle)model).getPropertyDefn().getDisplayName();
        }
        return "";
    }

    private String[] filterPreStyles(String[] items) {
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        for (int i = 0; i < preStyles.size(); ++i) {
            preStyleNames.add(((PredefinedStyle)preStyles.get(i)).getName());
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            if (preStyleNames.indexOf(items[i]) != -1) continue;
            sytleNames.add(items[i]);
        }
        return sytleNames.toArray(new String[0]);
    }

    static {
        $assertionsDisabled = !PropertyEditorFactory.class.desiredAssertionStatus();
        instance = new PropertyEditorFactory();
        booleanValues = new String[]{"false", "true"};
    }
}

