/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.AlphabeticallyViewSorter;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionDialogCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.PropertyEditorFactory;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetContentProvider;
import org.eclipse.birt.report.designer.internal.ui.views.property.ReportPropertySheetLabelProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ReportPropertySheetPage
extends Page
implements IPropertySheetPage,
Listener,
IColleague {
    private static final String COLUMN_TITLE_PROPERTY = Messages.getString((String)"ReportPropertySheetPage.Column.Title.Property");
    private static final String COLUMN_TITLE_VALUE = Messages.getString((String)"ReportPropertySheetPage.Column.Title.Value");
    private TableTreeViewer viewer;
    private ReportPropertySheetContentProvider contentProvider;
    private ReportPropertySheetLabelProvider labelProvider;
    private ISelection selection;
    private CellEditor cellEditor;
    private TableTree tableTree;
    private TableTreeEditor tableTreeEditor;
    private int columnToEdit = 1;
    private ICellEditorListener editorListener;
    private Object model;
    private List list;

    public void createControl(Composite parent) {
        this.viewer = new TableTreeViewer(parent, 65536);
        this.tableTree = this.viewer.getTableTree();
        this.tableTree.getTable().setHeaderVisible(true);
        this.tableTree.getTable().setLinesVisible(true);
        this.addColumns();
        this.contentProvider = new ReportPropertySheetContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ReportPropertySheetLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setColumnProperties(new String[]{COLUMN_TITLE_PROPERTY, COLUMN_TITLE_VALUE});
        AlphabeticallyViewSorter sorter = new AlphabeticallyViewSorter();
        sorter.setAscending(true);
        this.viewer.setSorter((ViewerSorter)sorter);
        this.hookControl();
        this.tableTreeEditor = new TableTreeEditor(this.tableTree);
        this.createEditorListener();
        this.handleGlobalAction();
        SessionHandleAdapter.getInstance().getMediator().addColleague((IColleague)this);
        this.expandToDefaultLevel();
    }

    private void expandToDefaultLevel() {
        this.viewer.expandToLevel(2);
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                ReportPropertySheetPage.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
                ReportPropertySheetPage.this.applyValue();
            }
        };
    }

    private void hookControl() {
        this.tableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ReportPropertySheetPage.this.handleSelect((TableTreeItem)e.item);
            }
        });
        this.tableTree.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TableTreeItem item = ReportPropertySheetPage.this.tableTree.getItem(pt);
                if (item != null) {
                    ReportPropertySheetPage.this.handleSelect(item);
                }
            }
        });
        this.tableTree.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ReportPropertySheetPage.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    ReportPropertySheetPage.this.viewer.setInput(ReportPropertySheetPage.this.viewer.getInput());
                }
            }
        });
    }

    protected void redo() {
        try {
            if (SessionHandleAdapter.getInstance().getCommandStack().canRedo()) {
                SessionHandleAdapter.getInstance().getCommandStack().redo();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    private void deactivateCellEditor() {
        this.tableTreeEditor.setEditor(null, null, this.columnToEdit);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
    }

    protected void handleSelect(TableTreeItem selection) {
        TableTreeItem[] sel;
        if (this.cellEditor != null) {
            this.applyValue();
            this.deactivateCellEditor();
        }
        if ((sel = new TableTreeItem[]{selection}).length != 0) {
            this.activateCellEditor(sel[0]);
        }
    }

    private void applyValue() {
        block4: {
            if (!this.cellEditor.isDirty()) {
                return;
            }
            if (this.model instanceof GroupPropertyHandle) {
                try {
                    ((GroupPropertyHandle)this.model).setValue(this.cellEditor.getValue());
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                    TableTreeItem[] sel = this.viewer.getTableTree().getSelection();
                    if (sel.length == 0) break block4;
                    this.activateCellEditor(sel[0]);
                }
            }
        }
    }

    private void activateCellEditor(TableTreeItem sel) {
        if (sel.isDisposed()) {
            return;
        }
        this.model = sel.getData();
        this.tableTree.showSelection();
        this.cellEditor = this.createCellEditor(this.model);
        if (this.cellEditor == null) {
            return;
        }
        this.tableTreeEditor.setEditor(this.cellEditor.getControl());
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableTreeEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableTreeEditor.grabHorizontal = layout.grabHorizontal;
        this.tableTreeEditor.minimumWidth = layout.minimumWidth;
        this.tableTreeEditor.setEditor(control, sel, this.columnToEdit);
        this.cellEditor.setFocus();
    }

    private CellEditor createCellEditor(Object data) {
        CellEditor editor = null;
        if (data instanceof GroupPropertyHandle && ((GroupPropertyHandle)data).isVisible() && (editor = PropertyEditorFactory.getInstance().createPropertyEditor((Composite)this.tableTree.getTable(), data)) instanceof ExpressionDialogCellEditor) {
            Object dataSetList = null;
            Object[] arrays = this.list.toArray();
            int len = arrays.length;
            if (len > 0) {
                ((ExpressionDialogCellEditor)editor).setExpressionProvider(new ExpressionProvider((DesignElementHandle)arrays[0]));
            }
        }
        return editor;
    }

    private void addColumns() {
        Table table = this.tableTree.getTable();
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(COLUMN_TITLE_PROPERTY);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(COLUMN_TITLE_VALUE);
        ColumnWeightData c1Layout = new ColumnWeightData(40, false);
        ColumnWeightData c2Layout = new ColumnWeightData(60, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)c1Layout);
        layout.addColumnData((ColumnLayoutData)c2Layout);
        table.setLayout((Layout)layout);
    }

    public Control getControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.deactivateCellEditor();
    }

    public void handleSelectionChanged(ISelection selection) {
        if (this.selection != null && this.selection.equals(selection)) {
            return;
        }
        this.selection = selection;
        this.deRegisterListeners();
        this.list = this.getModelList(selection);
        GroupElementHandle handle = DEUtil.getMultiSelectionHandle((List)this.list);
        if (handle != null && !handle.isSameType()) {
            this.viewer.setInput(null);
            return;
        }
        this.viewer.setInput((Object)handle);
        this.registerListeners();
        this.expandToDefaultLevel();
    }

    private List getModelList(ISelection selection) {
        List<Object> list = new ArrayList();
        if (selection == null) {
            return list;
        }
        if (!(selection instanceof StructuredSelection)) {
            return list;
        }
        StructuredSelection structured = (StructuredSelection)selection;
        if (structured.getFirstElement() instanceof ReportElementEditPart) {
            Iterator it = structured.iterator();
            while (it.hasNext()) {
                ReportElementEditPart object = (ReportElementEditPart)((Object)it.next());
                if (object instanceof DummyEditpart) {
                    list.clear();
                    list.add(object.getModel());
                    break;
                }
                list.add(object.getModel());
            }
        } else {
            list = structured.toList();
        }
        return list;
    }

    protected void deRegisterListeners() {
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        if (input instanceof DesignElementHandle) {
            DesignElementHandle element = (DesignElementHandle)input;
            element.removeListener((Listener)this);
        }
    }

    protected void registerListeners() {
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        if (input instanceof GroupElementHandle) {
            GroupElementHandle element = (GroupElementHandle)input;
            ((DesignElementHandle)element.getElements().get(0)).addListener((Listener)this);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (!this.viewer.getTableTree().isDisposed()) {
            this.viewer.refresh(true);
            this.expandToDefaultLevel();
        }
    }

    private void handleGlobalAction() {
        for (int i = 0; i < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length; ++i) {
            String id = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createStackAction(id, SessionHandleAdapter.getInstance().getCommandStack()));
        }
    }

    public void dispose() {
        SessionHandleAdapter.getInstance().getMediator().removeColleague((IColleague)this);
        this.unregisterListeners();
        super.dispose();
    }

    protected void unregisterListeners() {
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input == null) {
            return;
        }
        if (input instanceof GroupElementHandle) {
            GroupElementHandle element = (GroupElementHandle)input;
            ((DesignElementHandle)element.getElements().get(0)).removeListener((Listener)this);
        }
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            ArrayList selections = new ArrayList();
            selections.add(null);
            selections.addAll(request.getSelectionModelList());
            ArrayList<Object> nullList = new ArrayList<Object>();
            nullList.add(null);
            selections.removeAll(nullList);
            this.handleSelectionChanged((ISelection)new StructuredSelection(selections));
        }
    }
}

