/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DialogInfo;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.MonthCombo;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerTable;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerTime;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.SpinnerYear;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeDialogInfo;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeFormat;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TimeOptionDialog
extends SelectionStatusDialog
implements IPropertyChangeListener {
    private SpinnerYear year = null;
    private Combo month = null;
    private SpinnerTime time = null;
    private SpinnerTable day = null;
    private Combo combo = null;
    private Combo zoneCombo = null;
    private String format = "yyyy-MM-dd HH:mm:ss";
    private Calendar cale = Calendar.getInstance((TimeZone)TimeZone.getDefault());
    private String timeZone = "";
    private static final String LABEL_FORMAT = Messages.getString((String)"TimeOptionDialog.Label.Format");
    private static final String LABEL_TIMEZONE = Messages.getString((String)"TimeOptionDialog.Label.TimeZone");

    public TimeOptionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.initComponent(shell);
    }

    public void create() {
        super.create();
        this.initActions();
        this.updateComponent();
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    public Object getFirstResult() {
        return super.getFirstResult();
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void setImage(Image image) {
        super.setImage(image);
    }

    protected void setResult(int position, Object element) {
        super.setResult(position, element);
    }

    public void setStatusLineAboveButtons(boolean aboveButtons) {
        super.setStatusLineAboveButtons(aboveButtons);
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, defaultButton);
    }

    private void initComponent(Shell shell) {
        shell.setSize(500, 220);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(ColorConstants.blue);
        Composite compo = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)compo.getLayout();
        layout.numColumns = 3;
        Composite leftLabel = new Composite(compo, 2048);
        Composite rightLabel = new Composite(compo, 2048);
        this.createRightComponent(rightLabel);
        this.createLeftComponent(leftLabel);
        return compo;
    }

    private void createLeftComponent(Composite composite) {
        this.year = new SpinnerYear(composite, 0);
        this.month = new MonthCombo(composite, 8);
        this.month.setFont(FontManager.getFont((String)"Dialog", (int)12, (int)1));
        for (int i = 1; i <= 12; ++i) {
            this.month.add(String.valueOf(i));
        }
        this.month.setSize(50, 20);
        this.month.select(0);
        this.time = new SpinnerTime(composite, 0);
        this.day = new SpinnerTable(composite, 0);
        this.month.setLocation(this.year.getSize().x + 2, 0);
        this.time.setLocation(this.year.getSize().x + this.month.getSize().x + 4, 0);
        this.day.setLocation(0, this.year.getSize().y + 1);
        this.day.pack();
        composite.pack();
    }

    private void createRightComponent(Composite composite) {
        Label formatLabel = new Label(composite, 0x1000004);
        formatLabel.setText(LABEL_FORMAT);
        formatLabel.setBounds(0, 2, 60, 30);
        this.combo = new Combo(composite, 12);
        List list = TimeFormat.getDefaultFormat().getSupportList();
        String[] items = new String[list.size()];
        list.toArray(items);
        this.combo.setBounds(60, 2, 150, 200);
        this.combo.setItems(items);
        this.combo.select(0);
        Label zoneLabel = new Label(composite, 0x1000000);
        zoneLabel.setText(LABEL_TIMEZONE);
        zoneLabel.setBounds(0, 102, 60, 30);
        this.zoneCombo = new Combo(composite, 12);
        items = TimeZone.getAvailableIDs();
        this.zoneCombo.setBounds(60, 102, 150, 1000);
        this.zoneCombo.setItems(items);
        this.zoneCombo.select(0);
    }

    public boolean setInfo(DialogInfo dialogInfo) {
        if (!(dialogInfo instanceof TimeDialogInfo)) {
            return false;
        }
        TimeDialogInfo timeInfo = (TimeDialogInfo)dialogInfo;
        this.timeZone = timeInfo.getTimeZoneID();
        this.format = timeInfo.getFormat();
        this.cale.setTimeInMillis(timeInfo.getTime());
        return true;
    }

    public DialogInfo getInfo() {
        TimeDialogInfo info = new TimeDialogInfo();
        info.setTime(this.cale.getTimeInMillis());
        info.setTimeZoneID(this.timeZone);
        info.setFormat(this.format);
        return info;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getProperty();
        if (name.equals("yearchange")) {
            int year = (Integer)event.getNewValue();
            this.cale.set(1, year);
            this.day.setCalendar(this.cale);
        } else if (name.equals("daychange")) {
            int day = (Integer)event.getNewValue();
            this.cale.set(5, day);
        } else if (name.equals("hourchange")) {
            int hour = (Integer)event.getNewValue();
            this.cale.set(11, hour);
        } else if (name.equals("minchange")) {
            int min = (Integer)event.getNewValue();
            this.cale.set(12, min);
        } else if (name.equals("secchange")) {
            int sec = (Integer)event.getNewValue();
            this.cale.set(13, sec);
        }
    }

    private void initActions() {
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo source = (Combo)e.getSource();
                TimeOptionDialog.this.format = source.getText();
            }
        });
        this.zoneCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo source = (Combo)e.getSource();
                TimeOptionDialog.this.updateTimeForTimeZone(TimeOptionDialog.this.timeZone, source.getText());
                TimeOptionDialog.this.timeZone = source.getText();
            }
        });
        this.month.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo source = (Combo)e.getSource();
                TimeOptionDialog.this.cale.set(2, Integer.parseInt(source.getText()) - 1);
                TimeOptionDialog.this.day.setCalendar(TimeOptionDialog.this.cale);
            }
        });
        this.year.addPropertyChangeListener(this);
        this.time.addPropertyChangeListener(this);
        this.day.addPropertyChangeListener(this);
    }

    private void updateComponent() {
        this.combo.select(this.combo.indexOf(this.format));
        this.zoneCombo.select(this.zoneCombo.indexOf(this.timeZone));
        this.month.select(this.month.indexOf(String.valueOf(this.cale.get(2) + 1)));
        this.year.setYear(this.cale.get(1));
        this.day.setCalendar(this.cale);
        this.time.setTimeInfo(new SpinnerTime.SpinnerTimeInfo(this.cale.get(11), this.cale.get(12), this.cale.get(13)));
    }

    public boolean updateTimeForTimeZone(String oldID, String newID) {
        long time = this.cale.getTimeInMillis();
        TimeZone oldZone = TimeZone.getTimeZone((String)oldID);
        TimeZone newZone = TimeZone.getTimeZone((String)newID);
        int oldOff = oldZone.getRawOffset();
        int newOff = newZone.getRawOffset();
        this.cale.setTimeInMillis(time += (long)(newOff - oldOff));
        return true;
    }
}

