/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ReportGraphicsViewComposite;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class WizardTemplateChoicePage
extends WizardPage {
    private static final String MESSAGE_DESCRIPTION = Messages.getString((String)"WizardTemplateChoicePage.label.Description");
    private static final String MESSAGE_PREVIEW = Messages.getString((String)"WizardTemplateChoicePage.label.Preview");
    private static final String MESSAGE_REPORT_TEMPLATES = Messages.getString((String)"WizardTemplateChoicePage.label.ReportTemplates");
    private static final String MESSAGE_SHOW_CHEATSHEET = Messages.getString((String)"WizardTemplateChoicePage.label.ShowCheatSheets");
    private static final String TITLE_SIDE_BY_SIDE_CHART_LISTING = Messages.getString((String)"WizardTemplateChoicePage.title.SideBySideChartListing");
    private static final String TITLE_CHART_LISTING = Messages.getString((String)"WizardTemplateChoicePage.title.ChartListing");
    private static final String TITLE_GROUPED_LISTING = Messages.getString((String)"WizardTemplateChoicePage.title.GroupedListing");
    private static final String TITLE_SIMPLE_LISTING = Messages.getString((String)"WizardTemplateChoicePage.title.SimpleListing");
    private static final String TITLE_BLANK_REPORT = Messages.getString((String)"WizardTemplateChoicePage.title.BlankReport");
    private static final String TITLE_DUAL_COLUMN_CHART_LISTING = Messages.getString((String)"WizardTemplateChoicePage.title.DualColumnChartListing");
    private static final String TITLE_DUAL_COLUMN_LISTING = Messages.getString((String)"WizardTemplateChoicePage.title.DualColumnListing");
    private static final String TITLE_FIRST_REPORT = Messages.getString((String)"WizardTemplateChoicePage.title.FirstReport");
    private static final String DESCRIPTION_SIDE_BY_SIDE_CHART_LISTING = Messages.getString((String)"WizardTemplateChoicePage.message.SideBySideChartListing");
    private static final String DESCRIPTION_CHART_LISTING = Messages.getString((String)"WizardTemplateChoicePage.message.ChartListing");
    private static final String DESCRIPTION_GROUPED_LISTING = Messages.getString((String)"WizardTemplateChoicePage.message.GroupedListing");
    private static final String DESCRIPTION_SIMPLE_LISTING = Messages.getString((String)"WizardTemplateChoicePage.message.SimpleListing");
    private static final String DESCRIPTION_BLANK_REPORT = Messages.getString((String)"WizardTemplateChoicePage.message.BlankReport");
    private static final String DESCRIPTION_DUAL_COLUMN_CHART_LISTING = Messages.getString((String)"WizardTemplateChoicePage.message.DualColumnChartListing");
    private static final String DESCRIPTION_DUAL_COLUMN_LISTING = Messages.getString((String)"WizardTemplateChoicePage.message.DualColumnListing");
    private static final String DESCRIPTION_FIRST_REPORT = Messages.getString((String)"WizardTemplateChoicePage.message.FirstReport");
    private static final String PREDEFINED_TEMPLATE_DIRECTORY = UIUtil.getHomeDirectory();
    private org.eclipse.swt.widgets.List templateList;
    private ImageCanvas previewCanvas;
    private Button chkBox;
    private Label description;
    Image thumbnailImage;
    protected Template[] preDefinedTemplates = new Template[]{new Template(TITLE_BLANK_REPORT, DESCRIPTION_BLANK_REPORT, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/blank_report.rptdesign", "/templates/blank_report.gif", ""), new Template(TITLE_FIRST_REPORT, DESCRIPTION_FIRST_REPORT, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/blank_report.rptdesign", "/templates/first_report.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.firstreport"), new Template(TITLE_SIMPLE_LISTING, DESCRIPTION_SIMPLE_LISTING, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/simple_listing.rptdesign", "/templates/simple_listing.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.simplelisting"), new Template(TITLE_GROUPED_LISTING, DESCRIPTION_GROUPED_LISTING, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/grouped_listing.rptdesign", "/templates/grouped_listing.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.groupedlisting"), new Template(TITLE_DUAL_COLUMN_LISTING, DESCRIPTION_DUAL_COLUMN_LISTING, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/dual_column_listing.rptdesign", "/templates/dual_column_listing.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.dualcolumnlisting"), new Template(TITLE_CHART_LISTING, DESCRIPTION_CHART_LISTING, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/chart_listing.rptdesign", "/templates/chart_listing.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.chartlisting"), new Template(TITLE_DUAL_COLUMN_CHART_LISTING, DESCRIPTION_DUAL_COLUMN_CHART_LISTING, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/dual_column_chart_listing.rptdesign", "/templates/dual_column_chart_listing.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.dualchartlisting"), new Template(TITLE_SIDE_BY_SIDE_CHART_LISTING, DESCRIPTION_SIDE_BY_SIDE_CHART_LISTING, PREDEFINED_TEMPLATE_DIRECTORY, "/templates/sidebyside_chart_listing.rptdesign", "/templates/sidebyside_chart_listing.gif", "org.eclipse.birt.report.designer.ui.cheatsheet.sidebysidechartlisting")};
    protected List templates = new ArrayList();
    protected int selectedIndex;
    protected Map imageMap;
    private Composite previewPane;
    private Composite previewThumbnail;
    private Listener templateListener = new Listener(){

        public void handleEvent(Event event) {
            WizardTemplateChoicePage.this.selectedIndex = WizardTemplateChoicePage.this.templateList.getSelectionIndex();
            WizardTemplateChoicePage.this.description.setText(((Template)WizardTemplateChoicePage.this.templates.get(WizardTemplateChoicePage.this.selectedIndex)).getTemplateDescription());
            WizardTemplateChoicePage.this.previewPane.layout();
            Template selTemplate = (Template)WizardTemplateChoicePage.this.templates.get(WizardTemplateChoicePage.this.selectedIndex);
            String key = selTemplate.getPictureName();
            Image img = null;
            if (key != null && !"".equals(key.trim())) {
                key = selTemplate.getPictureFullName();
                img = (Image)WizardTemplateChoicePage.this.imageMap.get(key);
                if (img == null) {
                    img = ReportPlugin.getImage(key);
                    WizardTemplateChoicePage.this.imageMap.put(key, img);
                }
                WizardTemplateChoicePage.this.previewCanvas.setVisible(true);
                WizardTemplateChoicePage.this.previewThumbnail.setVisible(false);
                WizardTemplateChoicePage.this.previewCanvas.clear();
                WizardTemplateChoicePage.this.previewCanvas.loadImage(img);
                WizardTemplateChoicePage.this.previewCanvas.showOriginal();
            } else if (selTemplate.getThumbnail() != null && selTemplate.getThumbnail().length != 0) {
                WizardTemplateChoicePage.this.previewCanvas.setVisible(true);
                WizardTemplateChoicePage.this.previewThumbnail.setVisible(false);
                byte[] thumbnailData = selTemplate.getThumbnail();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(thumbnailData);
                if (WizardTemplateChoicePage.this.thumbnailImage != null) {
                    WizardTemplateChoicePage.this.thumbnailImage.dispose();
                    WizardTemplateChoicePage.this.thumbnailImage = null;
                }
                WizardTemplateChoicePage.this.thumbnailImage = new Image(null, (InputStream)inputStream);
                WizardTemplateChoicePage.this.previewCanvas.clear();
                WizardTemplateChoicePage.this.previewCanvas.loadImage(WizardTemplateChoicePage.this.thumbnailImage);
            } else {
                WizardTemplateChoicePage.this.previewCanvas.setVisible(false);
                WizardTemplateChoicePage.this.previewThumbnail.setVisible(true);
                Control[] children = WizardTemplateChoicePage.this.previewThumbnail.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    children[i].dispose();
                }
                ReportGraphicsViewComposite thumbnail = new ReportGraphicsViewComposite(WizardTemplateChoicePage.this.previewThumbnail, 0, ((Template)WizardTemplateChoicePage.this.templates.get(WizardTemplateChoicePage.this.selectedIndex)).getReportDesignHandle());
                WizardTemplateChoicePage.this.previewThumbnail.layout();
            }
            WizardTemplateChoicePage.this.chkBox.setEnabled(!((Template)WizardTemplateChoicePage.this.templates.get(WizardTemplateChoicePage.this.selectedIndex)).getCheatSheetId().equals("") && !((Template)WizardTemplateChoicePage.this.templates.get(WizardTemplateChoicePage.this.selectedIndex)).getCheatSheetId().equals("org.eclipse.birt.report.designer.ui.cheatsheet.firstreport"));
        }
    };

    public WizardTemplateChoicePage(String pageName) {
        super(pageName);
        this.imageMap = new HashMap();
        this.templates.addAll(Arrays.asList(this.preDefinedTemplates));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.NewReportCopyWizard_ID");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label label0 = new Label(composite, 0);
        label0.setText(MESSAGE_REPORT_TEMPLATES);
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(MESSAGE_PREVIEW);
        GridData data = new GridData(1);
        previewLabel.setLayoutData((Object)data);
        this.templateList = new org.eclipse.swt.widgets.List(composite, 2304);
        this.createCustomTemplateList();
        Iterator it = this.templates.iterator();
        while (it.hasNext()) {
            this.templateList.add(((Template)it.next()).getName());
        }
        data = new GridData(1041);
        data.widthHint = 200;
        this.templateList.setLayoutData((Object)data);
        this.previewPane = new Composite(composite, 0);
        data = new GridData(1808);
        this.previewPane.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.previewPane.setLayout((Layout)gridLayout);
        Composite previewComposite = new Composite(this.previewPane, 2048);
        data = new GridData(1);
        data.heightHint = 229;
        data.widthHint = 184;
        previewComposite.setLayoutData((Object)data);
        previewComposite.setLayout((Layout)new FormLayout());
        this.previewCanvas = new ImageCanvas(previewComposite);
        this.previewThumbnail = new Composite(previewComposite, 0);
        FormData formData = new FormData(184, 229);
        formData.left = new FormAttachment((Control)previewComposite);
        formData.top = new FormAttachment((Control)previewComposite);
        this.previewCanvas.setLayoutData(formData);
        this.previewThumbnail.setLayoutData((Object)formData);
        this.previewThumbnail.setLayout((Layout)new FillLayout());
        Label descriptionTitle = new Label(this.previewPane, 0);
        descriptionTitle.setText(MESSAGE_DESCRIPTION);
        data = new GridData(768);
        descriptionTitle.setLayoutData((Object)data);
        this.description = new Label(this.previewPane, 64);
        data = new GridData(768);
        data.widthHint = 184;
        data.horizontalIndent = 20;
        this.description.setLayoutData((Object)data);
        new Label(this.previewPane, 0);
        this.chkBox = new Button(composite, 32);
        this.chkBox.setText(MESSAGE_SHOW_CHEATSHEET);
        this.chkBox.setSelection(ReportPlugin.readCheatSheetPreference());
        this.chkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardTemplateChoicePage.this.chkBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardTemplateChoicePage.this.chkBox.getSelection());
            }
        });
        this.hookListeners();
        this.templateList.select(0);
        this.templateListener.handleEvent(new Event());
        this.setControl((Control)composite);
    }

    private void createCustomTemplateList() {
        String root = ReportPlugin.getDefault().getTemplatePreference();
        File templateDirectory = new File(root, File.separator);
        if (templateDirectory.isDirectory()) {
            if (!templateDirectory.exists()) {
                templateDirectory.mkdirs();
            }
            File[] filesArray = templateDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".rpttemplate");
                }
            });
            for (int i = 0; i < filesArray.length; ++i) {
                try {
                    this.templates.add(new Template(root, filesArray[i].getName()));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void hookListeners() {
        this.templateList.addListener(13, this.templateListener);
    }

    public Template getTemplate() {
        return (Template)this.templates.get(this.selectedIndex);
    }

    public Template getBlankTemplate() {
        return (Template)this.templates.get(0);
    }

    public boolean getShowCheatSheet() {
        if (((Template)this.templates.get(this.selectedIndex)).getCheatSheetId().equals("org.eclipse.birt.report.designer.ui.cheatsheet.firstreport")) {
            return true;
        }
        return this.chkBox.getSelection();
    }

    public void dispose() {
        super.dispose();
        Iterator it = this.templates.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof Template)) continue;
            ((Template)item).dispose();
        }
        if (this.thumbnailImage != null) {
            this.thumbnailImage.dispose();
            this.thumbnailImage = null;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }

    public class TemplateType {
        public static final int BLANK_REPORT = 0;
        public static final int SIMPLE_LISTING = 1;
        public static final int GROUPED_LISTING = 2;
        public static final int CHART_LISTING = 3;
        public static final int CROSSTAB = 4;
        public static final int MAILING_LABELS = 5;
        public static final int FREE_FORMAT = 6;
        public static final int GROUPED_LISTING_HEADING_OUTSIDE = 7;
        public static final int DUALCHART_LISTING = 8;
        public static final int LETTER = 9;
        public static final int SIDEBYSIDE_CHART_LISTING = 10;
        public static final int DUAL_COLUMN_CHART_LISTING = 11;
        public static final int DASHBOARD_REPORT = 12;
    }

    public class Template {
        Map files = new HashMap();
        private String name;
        private String templateDescription;
        private String root;
        private String reportName;
        private String pictureName;
        private String cheatSheetId;
        private ReportDesignHandle reportDesign;
        private byte[] thumbnail;

        public Template(String name, String description, String root, String reportName, String pictureName, String cheatSheetId) {
            this.name = name;
            this.templateDescription = description;
            this.root = root;
            this.reportName = reportName;
            this.pictureName = pictureName;
            this.cheatSheetId = cheatSheetId;
            this.thumbnail = null;
        }

        public Template(String root, String reportName) throws DesignFileException {
            this.root = root;
            this.reportName = reportName;
            String fullName = this.getReportFullName();
            this.reportDesign = (ReportDesignHandle)this.files.get(fullName);
            if (this.reportDesign == null) {
                this.reportDesign = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(fullName);
                this.files.put(fullName, this.reportDesign);
            }
            this.name = this.reportDesign.getDisplayName() == null ? UIUtil.getSimpleFileName(this.reportDesign.getFileName()) : this.reportDesign.getDisplayName();
            this.templateDescription = this.reportDesign.getStringProperty("description");
            if (this.templateDescription == null) {
                this.templateDescription = "";
            }
            this.pictureName = this.reportDesign.getIconFile() == null ? "" : this.reportDesign.getIconFile();
            this.cheatSheetId = this.reportDesign.getCheatSheet() == null ? "" : this.reportDesign.getCheatSheet();
            this.thumbnail = this.reportDesign.getThumbnail();
            this.reportName = reportName;
        }

        public byte[] getThumbnail() {
            return this.thumbnail;
        }

        public String getCheatSheetId() {
            return this.cheatSheetId;
        }

        public void setCheatSheetId(String cheatSheetId) {
            this.cheatSheetId = cheatSheetId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPictureName() {
            return this.pictureName;
        }

        public void setPictureName(String pictureName) {
            this.pictureName = pictureName;
        }

        public String getReportName() {
            return this.reportName;
        }

        public void setReportName(String reportName) {
            this.reportName = reportName;
        }

        public String getTemplateDescription() {
            return this.templateDescription;
        }

        public void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        public ReportDesignHandle getReportDesignHandle() {
            return this.reportDesign;
        }

        public void dispose() {
            Iterator it = this.files.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry item = it.next();
                if (!(item instanceof ReportDesignHandle)) continue;
                ((ReportDesignHandle)item).close();
            }
        }

        private String getFullPath(String root, String fileName) {
            Assert.isLegal((root != null ? 1 : 0) != 0);
            Assert.isLegal((fileName != null ? 1 : 0) != 0);
            String fullPath = new String(root);
            if (fullPath.indexOf("\\") < 0) {
                if (!fullPath.endsWith("/")) {
                    fullPath = fullPath + "/";
                }
            } else if (!fullPath.endsWith("\\")) {
                fullPath = fullPath + "\\";
            }
            fullPath = fullPath + fileName;
            fullPath = fullPath.replaceAll("\\\\", "\\");
            fullPath = fullPath.replaceAll("//", "/");
            return fullPath;
        }

        public String getReportFullName() {
            return this.getFullPath(this.root, this.reportName);
        }

        public String getPictureFullName() {
            return this.getFullPath(this.root, this.pictureName);
        }
    }
}

