/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ComputedColumnExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BindingExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ColumnBindingDialog
extends BaseDialog {
    private static final String MSG_ADD = Messages.getString((String)"ColumnBindingDialog.Text.Add");
    private static final String MSG_EDIT = Messages.getString((String)"ColumnBindingDialog.Text.Edit");
    private static final String MSG_DELETE = Messages.getString((String)"ColumnBindingDialog.Text.Del");
    private static final String DEFAULT_COLUMN_NAME = "[result_set_col_name]";
    private static final String dummyChoice = "dummy";
    public static final String DEFAULT_DLG_TITLE = Messages.getString((String)"ColumnBindingDialog.DialogTitle");
    private static final String ALL = Messages.getString((String)"ColumnBindingDialog.All");
    private static final String NONE_AGGREGATEON = Messages.getString((String)"ColumnBindingDialog.AGGREGATEON.NONE");
    private static final String CHOICE_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.FromContainer");
    private static final String CHOICE_NONE = Messages.getString((String)"ColumnBindingDialog.NONE");
    private static final String LABEL_COLUMN_BINDINGS = Messages.getString((String)"ColumnBindingDialog.Label.DataSet");
    private static final String WARN_COLUMN_BINDINGS = Messages.getString((String)"ColumnBingingDialog.Label.Warn");
    private static final String COLUMN_NAME = Messages.getString((String)"ColumnBindingDialog.Column.Name");
    private static final String COLUMN_DISPLAYNAME = Messages.getString((String)"ColumnBindingDialog.Column.displayName");
    private static final String COLUMN_DATATYPE = Messages.getString((String)"ColumnBindingDialog.Column.DataType");
    private static final String COLUMN_EXPRESSION = Messages.getString((String)"ColumnBindingDialog.Column.Expression");
    private static final String COLUMN_AGGREGATEON = Messages.getString((String)"ColumnBindingDialog.Column.AggregateOn");
    private static final String INPUT_PROPMT = Messages.getString((String)"ColumnBindingDialog.InputPrompt");
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    private static final IChoice[] dataTypes = DATA_TYPE_CHOICE_SET.getChoices(null);
    private static final String[] dataTypeDisplayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET);
    private boolean canSelect = false;
    protected ReportItemHandle inputElement;
    private TableViewer bindingTable;
    private ExpressionCellEditor expressionCellEditor;
    private String selectedColumnName = null;
    private String NullChoice = null;
    private int selectIndex;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            List elementsList = ColumnBindingDialog.this.getBindingList((DesignElementHandle)inputElement);
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == ColumnBindingDialog.dummyChoice) {
                if (columnIndex == 1) {
                    return INPUT_PROPMT;
                }
                return "";
            }
            ComputedColumnHandle handle = (ComputedColumnHandle)element;
            String text = null;
            switch (columnIndex) {
                case 1: {
                    text = handle.getName();
                    break;
                }
                case 2: {
                    text = handle.getDisplayName();
                    break;
                }
                case 3: {
                    text = ChoiceSetFactory.getDisplayNameFromChoiceSet(handle.getDataType(), DATA_TYPE_CHOICE_SET);
                    break;
                }
                case 4: {
                    text = handle.getExpression();
                    break;
                }
                case 5: {
                    String value = handle.getAggregrateOn();
                    String groupType = DEUtil.getGroupControlType((DesignElementHandle)ColumnBindingDialog.this.inputElement);
                    if (value == null) {
                        if (ExpressionUtil.hasAggregation((String)handle.getExpression()) && groupType != "none") {
                            text = ALL;
                            break;
                        }
                        text = NONE_AGGREGATEON;
                        break;
                    }
                    if (groupType == "none") {
                        text = NONE_AGGREGATEON;
                        handle.setAggregateOn(null);
                        break;
                    }
                    text = value;
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private String highLightName = null;
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            ComputedColumnHandle handle;
            if (property == null || element == ColumnBindingDialog.dummyChoice && !COLUMN_NAME.equals(property)) {
                return false;
            }
            return !COLUMN_AGGREGATEON.equals(property) || ExpressionUtil.hasAggregation((String)(handle = (ComputedColumnHandle)element).getExpression()) && !DEUtil.getGroupControlType((DesignElementHandle)ColumnBindingDialog.this.inputElement).equals("none");
        }

        public Object getValue(Object element, String property) {
            if (element == ColumnBindingDialog.dummyChoice) {
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)ColumnBindingDialog.this.inputElement, (String)ColumnBindingDialog.DEFAULT_COLUMN_NAME);
                column.setExpression("");
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)ColumnBindingDialog.this.inputElement);
                if (ExpressionUtil.hasAggregation((String)column.getExpression())) {
                    if (groupType.equals("group")) {
                        column.setAggregrateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)ColumnBindingDialog.this.inputElement).get(0)).getName());
                    } else if (groupType.equals("listing")) {
                        column.setAggregrateOn(null);
                    }
                }
                if (!ExpressionUtil.hasAggregation((String)column.getExpression()) || groupType.equals("none")) {
                    column.setAggregrateOn(null);
                }
                ColumnBindingDialog.this.addBinding(column);
                ColumnBindingDialog.this.highLightName = column.getName();
                return "";
            }
            ComputedColumnHandle handle = (ComputedColumnHandle)element;
            String value = null;
            if (COLUMN_NAME.equals(property)) {
                value = handle.getName();
            } else if (COLUMN_DISPLAYNAME.equals(property)) {
                value = handle.getDisplayName();
            } else {
                if (COLUMN_DATATYPE.equals(property)) {
                    IChoice type = DATA_TYPE_CHOICE_SET.findChoice(handle.getDataType());
                    if (type != null) {
                        for (int i = 0; i < dataTypeDisplayNames.length; ++i) {
                            if (!dataTypeDisplayNames[i].equals(type.getDisplayName())) continue;
                            return new Integer(i);
                        }
                    }
                    return new Integer(0);
                }
                if (COLUMN_EXPRESSION.equals(property)) {
                    value = handle.getExpression();
                } else if (COLUMN_AGGREGATEON.equals(property)) {
                    value = handle.getAggregrateOn();
                    if (value != null) {
                        for (int i = 1; i < ColumnBindingDialog.this.groups.length; ++i) {
                            if (!value.equals(ColumnBindingDialog.this.groups[i])) continue;
                            return new Integer(i);
                        }
                    }
                    return new Integer(0);
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            try {
                if (COLUMN_NAME.equals(property)) {
                    String newName = UIUtil.convertToModelString((String)value, true);
                    if (element == ColumnBindingDialog.dummyChoice) {
                        if (newName == null) {
                            return;
                        }
                    } else {
                        ComputedColumnHandle columnHandle = (ComputedColumnHandle)element;
                        boolean selectedNameChanged = false;
                        if (columnHandle.getName() != null && columnHandle.getName().equals(ColumnBindingDialog.this.selectedColumnName)) {
                            selectedNameChanged = true;
                        }
                        if (ColumnBindingDialog.this.highLightName != null && ColumnBindingDialog.this.highLightName.equals(((ComputedColumnHandle)element).getName()) && !ColumnBindingDialog.this.highLightName.equals(newName)) {
                            ColumnBindingDialog.this.bindingTable.getTable().getItem(ColumnBindingDialog.this.bindingTable.getTable().getSelectionIndex()).setForeground(1, Display.getDefault().getSystemColor(24));
                        }
                        if (columnHandle.getName() == null || !columnHandle.getName().equals(newName)) {
                            ((ComputedColumnHandle)element).setName(newName);
                        }
                        if (selectedNameChanged) {
                            ColumnBindingDialog.this.selectedColumnName = newName;
                        }
                    }
                } else {
                    ComputedColumnHandle bindingHandle = (ComputedColumnHandle)element;
                    if (COLUMN_DATATYPE.equals(property)) {
                        bindingHandle.setDataType(dataTypes[(Integer)value].getName());
                    } else if (COLUMN_EXPRESSION.equals(property)) {
                        if (bindingHandle.getExpression() == null || !bindingHandle.getExpression().equals((String)value)) {
                            bindingHandle.setExpression((String)value);
                            String groupType = DEUtil.getGroupControlType((DesignElementHandle)ColumnBindingDialog.this.inputElement);
                            if (ExpressionUtil.hasAggregation((String)bindingHandle.getExpression())) {
                                if (groupType.equals("group")) {
                                    bindingHandle.setAggregrateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)ColumnBindingDialog.this.inputElement).get(0)).getName());
                                } else if (groupType.equals("listing")) {
                                    bindingHandle.setAggregrateOn(null);
                                }
                            }
                            if (!ExpressionUtil.hasAggregation((String)bindingHandle.getExpression()) || groupType.equals("none")) {
                                bindingHandle.setAggregrateOn(null);
                            }
                        }
                    } else if (COLUMN_AGGREGATEON.equals(property)) {
                        if ((Integer)value == 0) {
                            bindingHandle.setAggregrateOn(null);
                        } else {
                            bindingHandle.setAggregrateOn(ColumnBindingDialog.this.groups[(Integer)value]);
                        }
                    } else if (COLUMN_DISPLAYNAME.equals(property)) {
                        String newDisplayName = UIUtil.convertToModelString((String)value, true);
                        if (bindingHandle.getDisplayName() == null || !bindingHandle.getDisplayName().equals(newDisplayName)) {
                            bindingHandle.setDisplayName(newDisplayName);
                        }
                    }
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            ColumnBindingDialog.this.refreshBindingTable();
        }
    };
    private List groupList = Collections.EMPTY_LIST;
    private String[] groups;
    protected Button btnDel;
    protected Button btnEdit;
    protected Button btnAdd;
    protected ExpressionProvider expressionProvider;

    public ColumnBindingDialog() {
        super(DEFAULT_DLG_TITLE);
    }

    public ColumnBindingDialog(String title) {
        super(title);
    }

    public ColumnBindingDialog(boolean canSelect) {
        super(DEFAULT_DLG_TITLE);
        this.canSelect = canSelect;
    }

    public ColumnBindingDialog(Shell parent, boolean canSelect) {
        this(parent, DEFAULT_DLG_TITLE, canSelect);
    }

    public ColumnBindingDialog(Shell parent, String title, boolean canSelect) {
        super(parent, title);
        this.canSelect = canSelect;
    }

    public void setInput(ReportItemHandle input) {
        Assert.isNotNull((Object)input);
        this.inputElement = input;
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)input.getContainer());
        this.NullChoice = container != null && (container.getDataSet() != null || container.columnBindingsIterator().hasNext()) ? CHOICE_FROM_CONTAINER : CHOICE_NONE;
    }

    protected Control createDialogArea(Composite parent) {
        int i;
        GridData gd;
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ColumnBindingDialog_ID");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        if (this.canSelect) {
            Composite composite = new Composite(parentComposite, 0);
            composite.setLayoutData((Object)new GridData(768));
            composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
            CLabel warnLabel = new CLabel(composite, 0);
            warnLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            warnLabel.setText(WARN_COLUMN_BINDINGS);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            warnLabel.setLayoutData((Object)gd);
            Label label = new Label(composite, 0);
            label.setText(LABEL_COLUMN_BINDINGS);
            label.setLayoutData((Object)new GridData(1));
            final CCombo combo = new CCombo(composite, 2056);
            combo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
            String[] dataSets = ChoiceSetFactory.getDataSets();
            String[] newList = new String[dataSets.length + 1];
            newList[0] = this.NullChoice;
            System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
            combo.setItems(newList);
            String dataSetName = this.getDataSetName();
            combo.deselectAll();
            if (dataSetName != null) {
                combo.setText(dataSetName);
            } else {
                combo.select(0);
            }
            combo.setLayoutData(new GridData(768));
            gd = new GridData();
            gd.widthHint = 250;
            combo.setLayoutData(gd);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int rCode;
                    String value = null;
                    if (combo.getSelectionIndex() != 0) {
                        value = combo.getText();
                    }
                    if ((rCode = ColumnBindingDialog.this.canChangeDataSet(value)) == 2) {
                        String newName = ColumnBindingDialog.this.getDataSetName();
                        if (newName != null) {
                            combo.setText(newName);
                        } else {
                            combo.select(0);
                        }
                    } else {
                        try {
                            DataSetHandle dataSet = null;
                            if (value != null) {
                                dataSet = ColumnBindingDialog.this.inputElement.getModuleHandle().findDataSet(value);
                            }
                            ColumnBindingDialog.this.inputElement.setDataSet(dataSet);
                            ColumnBindingDialog.this.getParameterBindingPropertyHandle().clearValue();
                            if (rCode == 0) {
                                ColumnBindingDialog.this.inputElement.getColumnBindings().clearValue();
                            }
                            ColumnBindingDialog.this.generateBindingColumns();
                            ColumnBindingDialog.this.setHihtLightColumn();
                        }
                        catch (SemanticException e) {
                            ExceptionHandler.handle(e);
                        }
                    }
                }
            });
        }
        Composite contentComposite = new Composite(parentComposite, 0);
        contentComposite.setLayoutData((Object)new GridData(1808));
        contentComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        final Table table = new Table(contentComposite, 0x10804 | (this.canSelect ? 32 : 0));
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.verticalSpan = 3;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int itemCount = table.getItemCount();
                    if (ColumnBindingDialog.this.selectIndex == itemCount) {
                        return;
                    }
                    if (ColumnBindingDialog.this.selectIndex == itemCount - 1) {
                        ColumnBindingDialog.this.selectIndex--;
                    }
                    try {
                        ColumnBindingDialog.this.handleDelEvent();
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError(ColumnBindingDialog.this.getShell(), e1);
                    }
                    ColumnBindingDialog.this.refreshBindingTable();
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnBindingDialog.this.selectIndex = table.getSelectionIndex();
                ColumnBindingDialog.this.updateButtons();
            }
        });
        String[] columns = null;
        int[] columnWidth = null;
        this.expressionCellEditor = new ExpressionCellEditor((Composite)table);
        columns = new String[]{null, COLUMN_NAME, COLUMN_DISPLAYNAME, COLUMN_DATATYPE, COLUMN_EXPRESSION, COLUMN_AGGREGATEON};
        columnWidth = new int[]{this.canSelect ? 25 : 20, 150, 150, 70, 150, 150};
        this.groups = new String[this.groupList.size() + 1];
        this.groups[0] = ALL;
        for (i = 0; i < this.groupList.size(); ++i) {
            this.groups[i + 1] = ((GroupHandle)this.groupList.get(i)).getName();
        }
        CellEditor[] cellEditors = new CellEditor[]{null, new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, dataTypeDisplayNames), this.expressionCellEditor, new ComboBoxCellEditor((Composite)table, this.groups, 8)};
        for (i = 0; i < columns.length; ++i) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
        }
        if (this.canSelect) {
            this.bindingTable = new CheckboxTableViewer(table);
            ((CheckboxTableViewer)this.bindingTable).addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof ComputedColumnHandle) {
                        ComputedColumnHandle handle = (ComputedColumnHandle)event.getElement();
                        if (handle.getName().equals(ColumnBindingDialog.this.selectedColumnName)) {
                            ColumnBindingDialog.this.selectedColumnName = null;
                        } else {
                            ColumnBindingDialog.this.selectedColumnName = handle.getName();
                        }
                        ColumnBindingDialog.this.updateSelection();
                        ColumnBindingDialog.this.updateButtons();
                    } else {
                        ((CheckboxTableViewer)ColumnBindingDialog.this.bindingTable).setChecked((Object)ColumnBindingDialog.dummyChoice, false);
                    }
                }
            });
        } else {
            this.bindingTable = new TableViewer(table);
        }
        this.bindingTable.setCellEditors(cellEditors);
        this.bindingTable.setColumnProperties(columns);
        this.bindingTable.setContentProvider((IContentProvider)this.contentProvider);
        this.bindingTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.bindingTable.setInput((Object)this.inputElement);
        this.bindingTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ColumnBindingDialog.this.bindingTable.getSelection().isEmpty()) {
                    Object obj = ((IStructuredSelection)ColumnBindingDialog.this.bindingTable.getSelection()).getFirstElement();
                    if (obj == ColumnBindingDialog.dummyChoice && !ColumnBindingDialog.this.existHighLightColumn()) {
                        ColumnBindingDialog.this.bindingTable.refresh();
                        ColumnBindingDialog.this.setHihtLightColumn();
                    } else if (obj instanceof ComputedColumnHandle) {
                        if (ColumnBindingDialog.this.expressionProvider != null) {
                            ColumnBindingDialog.this.expressionCellEditor.setExpressionProvider(ColumnBindingDialog.this.expressionProvider);
                        } else {
                            ComputedColumnHandle column = (ComputedColumnHandle)obj;
                            BindingExpressionProvider provider = new BindingExpressionProvider(column.getElementHandle());
                            provider.addFilter(new ComputedColumnExpressionFilter(ColumnBindingDialog.this.bindingTable));
                            ColumnBindingDialog.this.expressionCellEditor.setExpressionProvider(provider);
                        }
                    }
                }
                ColumnBindingDialog.this.updateButtons();
            }
        });
        this.btnAdd = new Button(contentComposite, 8);
        this.btnAdd.setText(MSG_ADD);
        GridData data = new GridData();
        data.widthHint = Math.max(60, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnBindingDialog.this.handleAddEvent();
                ColumnBindingDialog.this.refreshBindingTable();
                if (table.getItemCount() > 0) {
                    ColumnBindingDialog.this.selectIndex = table.getItemCount() - 1;
                }
                ColumnBindingDialog.this.updateButtons();
            }
        });
        this.btnEdit = new Button(contentComposite, 8);
        this.btnEdit.setText(MSG_EDIT);
        data = new GridData();
        data.widthHint = Math.max(60, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnBindingDialog.this.handleEditEvent();
                ColumnBindingDialog.this.refreshBindingTable();
            }
        });
        this.btnDel = new Button(contentComposite, 8);
        this.btnDel.setText(MSG_DELETE);
        data = new GridData(1026);
        data.widthHint = Math.max(60, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pos;
                if (ColumnBindingDialog.this.bindingTable.isCellEditorActive()) {
                    ColumnBindingDialog.this.bindingTable.cancelEditing();
                }
                if ((pos = ColumnBindingDialog.this.bindingTable.getTable().getSelectionIndex()) == -1) {
                    ColumnBindingDialog.this.bindingTable.getTable().setFocus();
                    return;
                }
                ColumnBindingDialog.this.selectIndex = pos;
                int itemCount = ColumnBindingDialog.this.bindingTable.getTable().getItemCount();
                if (ColumnBindingDialog.this.selectIndex == itemCount - 1) {
                    ColumnBindingDialog.this.selectIndex--;
                }
                try {
                    ColumnBindingDialog.this.handleDelEvent();
                }
                catch (Exception e1) {
                    WidgetUtil.processError(ColumnBindingDialog.this.getShell(), e1);
                }
                ColumnBindingDialog.this.refreshBindingTable();
            }
        });
        return parentComposite;
    }

    protected void handleAddEvent() {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog();
        dialog.setInput(this.inputElement);
        dialog.setExpressionProvider(this.expressionProvider);
        if (dialog.open() == 0 && this.bindingTable != null) {
            this.refreshBindingTable();
            this.bindingTable.getTable().setSelection(this.bindingTable.getTable().getItemCount() - 1);
        }
    }

    protected void handleEditEvent() {
        ComputedColumnHandle bindingHandle = null;
        int pos = this.bindingTable.getTable().getSelectionIndex();
        if (pos > -1) {
            bindingHandle = (ComputedColumnHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getColumnBindings().getAt(pos);
        }
        if (bindingHandle == null) {
            return;
        }
        DataColumnBindingDialog dialog = new DataColumnBindingDialog();
        dialog.setInput(this.inputElement, bindingHandle);
        dialog.setExpressionProvider(this.expressionProvider);
        if (dialog.open() == 0 && this.bindingTable != null) {
            this.bindingTable.getTable().setSelection(pos);
        }
    }

    protected void handleDelEvent() {
        int pos = this.bindingTable.getTable().getSelectionIndex();
        if (pos > -1) {
            try {
                ComputedColumnHandle handle = (ComputedColumnHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement).getColumnBindings().getAt(pos);
                this.deleteRow(handle);
            }
            catch (Exception e1) {
                ExceptionHandler.handle(e1);
            }
        }
    }

    private boolean existHighLightColumn() {
        if (this.highLightName == null) {
            return false;
        }
        for (int i = 0; i < this.bindingTable.getTable().getItemCount(); ++i) {
            TableItem item = this.bindingTable.getTable().getItem(i);
            if (!item.getText(1).equals(this.highLightName)) continue;
            return true;
        }
        return false;
    }

    private void setHihtLightColumn() {
        if (this.highLightName == null) {
            return;
        }
        for (int i = 0; i < this.bindingTable.getTable().getItemCount(); ++i) {
            TableItem item = this.bindingTable.getTable().getItem(i);
            if (item.getText(1).equals(this.highLightName)) {
                item.setForeground(1, Display.getDefault().getSystemColor(9));
                this.bindingTable.getTable().setSelection(i);
                continue;
            }
            item.getForeground(1).equals((Object)Display.getDefault().getSystemColor(9));
            item.setForeground(1, Display.getDefault().getSystemColor(24));
        }
    }

    protected boolean initDialog() {
        if (this.canSelect && this.inputElement instanceof DataItemHandle) {
            this.selectedColumnName = ((DataItemHandle)this.inputElement).getResultSetColumn();
            this.updateSelection();
        }
        this.updateButtons();
        return super.initDialog();
    }

    protected void okPressed() {
        if (this.canSelect) {
            this.setResult(this.selectedColumnName);
            if (this.inputElement instanceof DataItemHandle) {
                try {
                    ((DataItemHandle)this.inputElement).setResultSetColumn(this.selectedColumnName);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
        super.okPressed();
    }

    private void deleteRow(ComputedColumnHandle handle) {
        try {
            if (handle.getName().equals(this.selectedColumnName)) {
                this.selectedColumnName = null;
            }
            handle.drop();
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void generateBindingColumns() throws SemanticException {
        List columnList = DataUtil.generateComputedColumns(this.inputElement);
        if (columnList.size() > 0) {
            Iterator iter = columnList.iterator();
            while (iter.hasNext()) {
                this.addBinding((ComputedColumn)iter.next());
            }
        }
        this.refreshBindingTable();
    }

    private void refreshBindingTable() {
        this.bindingTable.refresh();
        if (this.canSelect) {
            this.updateSelection();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean okEnable = false;
        if (!this.canSelect || this.selectedColumnName != null) {
            okEnable = true;
        }
        this.getOkButton().setEnabled(okEnable);
        int min = 0;
        int max = this.bindingTable.getTable().getItemCount() - 1;
        if (min <= this.selectIndex && this.selectIndex <= max) {
            this.btnDel.setEnabled(true);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnDel.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        }
        this.bindingTable.getTable().select(this.selectIndex);
    }

    private ComputedColumnHandle getSelectColumnHandle() {
        if (this.selectedColumnName != null) {
            for (int i = 0; i < this.bindingTable.getTable().getItemCount(); ++i) {
                ComputedColumnHandle handle = (ComputedColumnHandle)this.bindingTable.getElementAt(i);
                if (!this.selectedColumnName.equals(handle.getName())) continue;
                return handle;
            }
        }
        return null;
    }

    private void updateSelection() {
        if (this.canSelect) {
            ((CheckboxTableViewer)this.bindingTable).setAllChecked(false);
            ((CheckboxTableViewer)this.bindingTable).setGrayed((Object)dummyChoice, true);
            if (this.getSelectColumnHandle() != null) {
                ((CheckboxTableViewer)this.bindingTable).setChecked((Object)this.getSelectColumnHandle(), true);
            }
        }
    }

    protected void addBinding(ComputedColumn column) {
        try {
            DEUtil.addColumn((DesignElementHandle)DEUtil.getBindingHolder((DesignElementHandle)this.inputElement), (ComputedColumn)column, (boolean)false);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    protected List getBindingList(DesignElementHandle inputElement) {
        return DEUtil.getVisiableColumnBindingsList((DesignElementHandle)inputElement);
    }

    private int canChangeDataSet(String newName) {
        String currentDataSetName = this.getDataSetName();
        if (currentDataSetName == null && !this.inputElement.columnBindingsIterator().hasNext()) {
            return 0;
        }
        if (currentDataSetName == newName || currentDataSetName != null && currentDataSetName.equals(newName)) {
            return 2;
        }
        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return prefDialog.open();
    }

    private String getDataSetName() {
        if (this.inputElement.getDataSet() == null) {
            return null;
        }
        String dataSetName = this.inputElement.getDataSet().getQualifiedName();
        if (StringUtil.isBlank((String)dataSetName)) {
            dataSetName = null;
        }
        return dataSetName;
    }

    private PropertyHandle getParameterBindingPropertyHandle() {
        return this.inputElement.getPropertyHandle("paramBindings");
    }

    public void setGroupList(List groupList) {
        Assert.isNotNull((Object)groupList);
        this.groupList = groupList;
    }

    public void setExpressionProvider(ExpressionProvider provider) {
        this.expressionProvider = provider;
    }
}

