/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatStringPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormatBuilder
extends BaseDialog {
    public static final int STRING = 1;
    public static final int NUMBER = 2;
    public static final int DATETIME = 3;
    private static final String DLG_TITLE = Messages.getString((String)"FormatBuilder.Title");
    private IFormatPage page;
    private String formatCategory = null;
    private String formatPattern = null;
    private String previewText = null;
    private int style;

    public FormatBuilder(int style) {
        super(DLG_TITLE);
        Assert.isLegal((style == 1 || style == 2 || style == 3 ? 1 : 0) != 0);
        this.style = style;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        switch (this.style) {
            case 1: {
                this.page = new FormatStringPage(composite, 0, 0);
                break;
            }
            case 2: {
                this.page = new FormatNumberPage(composite, 0, 0);
                break;
            }
            case 3: {
                this.page = new FormatDateTimePage(composite, 0, 0);
            }
        }
        ((Composite)this.page).setLayoutData((Object)new GridData(1808));
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.FormatBuilder_ID");
        return composite;
    }

    public void setPreviewText(String previewText) {
        this.previewText = previewText;
    }

    public void setInputFormat(String formatCategroy, String formatPattern) {
        Assert.isLegal((!StringUtil.isBlank((String)formatCategroy) ? 1 : 0) != 0);
        this.formatCategory = formatCategroy;
        this.formatPattern = formatPattern;
    }

    protected boolean initDialog() {
        this.page.setInput(this.formatCategory, this.formatPattern);
        this.page.setPreviewText(this.previewText);
        return true;
    }

    protected void okPressed() {
        if (this.page.isFormatModified()) {
            this.setResult(new String[]{this.page.getCategory(), this.page.getPattern()});
            super.okPressed();
        } else {
            this.cancelPressed();
        }
    }
}

