/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HyperlinkBuilder
extends BaseDialog {
    private static final String TITLE = Messages.getString((String)"HyperlinkBuilder.DialogTitle");
    private static final String LABEL_SELECT_TYPE = Messages.getString((String)"HyperlinkBuilder.Label.SelectType");
    private static final String LABEL_LOCATION = Messages.getString((String)"HyperlinkBuilder.Label.Location");
    private static final String LABEL_TARGET = Messages.getString((String)"HyperlinkBuilder.Label.Target");
    private static final String LABEL_BOOKMARK = Messages.getString((String)"HyperlinkBuilder.Label.Bookmark");
    private static final String LABEL_LINKED_EXPRESSION = Messages.getString((String)"HyperlinkBuilder.Label.LinkedExpression");
    private static final String LABEL_REPORT = Messages.getString((String)"HyperlinkBuilder.Label.Report");
    private static final String LABEL_REPORT_PARAMETER = Messages.getString((String)"HyperlinkBuilder.Label.Parameters");
    private static final String LABEL_FORMAT = Messages.getString((String)"HyperlinkBuilder.Label.Format");
    private static final String RADIO_NONE = Messages.getString((String)"HyperlinkBuilder.Radio.None");
    private static final String RADIO_URI = Messages.getString((String)"HyperlinkBuilder.Radio.Uri");
    private static final String RADIO_BOOKMARK = Messages.getString((String)"HyperlinkBuilder.Radio.Bookmark");
    private static final String RADIO_DRILLTHROUGH = Messages.getString((String)"HyperlinkBuilder.Radio.DrillThrough");
    private static final String COLUMN_PARAMETER = Messages.getString((String)"HyperlinkBuilder.Column.Parameters");
    private static final String COLUMN_VALUE = Messages.getString((String)"HyperlinkBuilder.Column.Values");
    private static final String COLUMN_REQUIRED = Messages.getString((String)"HyperlinkBuilder.ParameterRequired");
    private static final Image IMAGE_OPEN_FILE = ReportPlatformUIImages.getImage("Open file");
    private static final Image REQUIRED_ICON = ReportPlatformUIImages.getImage("Default");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String ERROR_MSG_REPORT_REQUIRED = Messages.getString((String)"HyperlinkBuilder.ErrorMessage.ReportReqired");
    private static final String ERROR_MSG_INVALID_REPORT = Messages.getString((String)"HyperlinkBuilder.ErrorMessage.InvalidReport");
    private static final String TOOLTIP_BROWSE_FILE = Messages.getString((String)"HyperlinkBuilder.BrowseForFile");
    private static final String TOOLTIP_EXPRESSION = Messages.getString((String)"HyperlinkBuilder.OpenExpression");
    private static final String REQUIED_MARK = "*";
    private static final IChoiceSet CHOICESET_TARGET = DesignEngine.getMetaDataDictionary().getChoiceSet("targetNames");
    private static final IChoiceSet CHOICESET_FORMAT = DesignEngine.getMetaDataDictionary().getChoiceSet("actionFormatType");
    private static final ParamBinding dummyParameterBinding = StructureFactory.createParamBinding();
    private ActionHandle inputHandle;
    private List dataSetList;
    private Composite displayArea;
    private String selectedType;
    private Button noneRadio;
    private Button uriRadio;
    private Button bookmarkRadio;
    private Button drillRadio;
    private Combo bookmarkChooser;
    private Combo targetChooser;
    private Combo formatChooser;
    private Text bookmarkEditor;
    private Text locationEditor;
    private CLabel messageLine;
    private TableViewer paramBindingTable;
    private ComboBoxCellEditor parameterChooser;
    private ArrayList bindingList = new ArrayList();
    private ArrayList parameterList = new ArrayList();
    private Object targetReportHandle;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList elementsList = (ArrayList)list.clone();
            if (HyperlinkBuilder.this.bindingList.size() != HyperlinkBuilder.this.parameterList.size()) {
                elementsList.add(dummyParameterBinding);
            }
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            ParamBinding parameterBinding;
            boolean isRequired;
            if (columnIndex == 1 && (isRequired = HyperlinkBuilder.this.isParameterRequired((parameterBinding = (ParamBinding)element).getParamName()))) {
                return REQUIRED_ICON;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            ParamBinding parameterBinding = (ParamBinding)element;
            if (parameterBinding != dummyParameterBinding) {
                if (columnIndex == 0) {
                    text = parameterBinding.getParamName();
                } else if (columnIndex == 2) {
                    text = parameterBinding.getExpression();
                }
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return element != dummyParameterBinding || !COLUMN_VALUE.equals(property);
        }

        public Object getValue(Object element, String property) {
            ParamBinding paramBinding = (ParamBinding)element;
            Object value = null;
            if (COLUMN_VALUE.equals(property)) {
                value = paramBinding.getExpression();
                if (value == null) {
                    value = "";
                }
            } else if (COLUMN_PARAMETER.equals(property)) {
                HyperlinkBuilder.this.buildParameterChoices(paramBinding.getParamName());
                int index = -1;
                for (int i = 0; i < HyperlinkBuilder.this.parameterChooser.getItems().length; ++i) {
                    if (!HyperlinkBuilder.this.parameterChooser.getItems()[i].equals(paramBinding.getParamName())) continue;
                    index = i;
                    break;
                }
                value = new Integer(index);
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            int index;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ParamBinding paramBinding = (ParamBinding)element;
            if (COLUMN_VALUE.equals(property)) {
                paramBinding.setExpression((String)value);
            } else if (COLUMN_PARAMETER.equals(property) && (index = ((Integer)value).intValue()) != -1) {
                if (paramBinding == dummyParameterBinding) {
                    paramBinding = StructureFactory.createParamBinding();
                    HyperlinkBuilder.this.bindingList.add(paramBinding);
                }
                paramBinding.setParamName(HyperlinkBuilder.this.parameterChooser.getItems()[index]);
            }
            HyperlinkBuilder.this.paramBindingTable.refresh();
        }
    };
    private Button reportDesignButton;
    private Button reportDocumentButton;
    private Text documentEditor;
    private Button targetBookmarkButton;
    private Button tocButton;
    private Button sameWindowButton;
    private Button newWindowButton;
    private HashMap formatCheckBtns;
    private String[] supportedFormats;
    private Combo anchorChooser;
    private Group targetGroup;

    public HyperlinkBuilder(Shell parentShell) {
        super(parentShell, TITLE);
    }

    public HyperlinkBuilder() {
        this(UIUtil.getDefaultShell());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        this.displayArea = new Composite(composite, 0);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.displayArea.setLayoutData((Object)new GridData(500, shell.getBounds().height < 690 ? shell.getBounds().height - 200 : 490));
        this.displayArea.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.HyperlinkBuilder_ID");
        return composite;
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText(LABEL_SELECT_TYPE);
        this.noneRadio = new Button(composite, 16);
        this.noneRadio.setText(RADIO_NONE);
        this.addRadioListener(this.noneRadio, "none");
        UIUtil.createBlankLabel(composite);
        this.uriRadio = new Button(composite, 16);
        this.uriRadio.setText(RADIO_URI);
        this.addRadioListener(this.uriRadio, "hyperlink");
        if (!(SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof LibraryHandle)) {
            UIUtil.createBlankLabel(composite);
            this.bookmarkRadio = new Button(composite, 16);
            this.bookmarkRadio.setText(RADIO_BOOKMARK);
            this.addRadioListener(this.bookmarkRadio, "bookmark-link");
        }
        UIUtil.createBlankLabel(composite);
        this.drillRadio = new Button(composite, 16);
        this.drillRadio.setText(RADIO_DRILLTHROUGH);
        this.addRadioListener(this.drillRadio, "drill-through");
    }

    private void switchTo(String type) {
        this.selectedType = type;
        this.clearArea();
        this.closeTargetReport();
        this.displayArea.setLayout((Layout)new GridLayout(3, false));
        if ("hyperlink".equals(type)) {
            this.switchToURI();
        } else if ("bookmark-link".equals(type)) {
            this.switchToBookmark();
        } else if ("drill-through".equals(type)) {
            this.switchToDrillthrough();
        }
        this.initDisplayArea();
        this.displayArea.layout();
    }

    private void switchToURI() {
        new Label(this.displayArea, 0).setText(REQUIED_MARK + LABEL_LOCATION);
        this.locationEditor = new Text(this.displayArea, 2052);
        this.locationEditor.setLayoutData((Object)new GridData(768));
        this.locationEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkBuilder.this.updateButtons();
            }
        });
        Composite buttonArea = new Composite(this.displayArea, 0);
        buttonArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, true));
        buttonArea.setLayoutData((Object)new GridData());
        this.createBrowerButton(buttonArea, this.locationEditor, true, false);
        this.createExpressionButton(buttonArea, this.locationEditor);
        this.createTargetBar();
    }

    private void switchToBookmark() {
        this.createBookmarkBar(true);
    }

    private void switchToDrillthrough() {
        this.displayArea.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledContainer = new ScrolledComposite(this.displayArea, 768);
        Composite container = new Composite((Composite)scrolledContainer, 0);
        container.setLayout((Layout)new GridLayout());
        scrolledContainer.setContent((Control)container);
        this.messageLine = new CLabel(container, 0);
        this.messageLine.setLayoutData((Object)new GridData(768));
        this.createDrillthroughSelectTargetReport(container);
        this.createDrillthroughSelectTargetAnchor(container);
        this.createDrillthroughCreateLinkExpression(container);
        this.createDrillthroughSelectShowTarget(container);
        this.createDrillthroughSelectFormat(container);
        container.setSize(container.computeSize(-1, -1));
    }

    private void createDrillthroughSelectTargetReport(Composite container) {
        this.targetGroup = new Group(container, 0);
        this.targetGroup.setLayoutData((Object)new GridData(768));
        this.targetGroup.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughStep1"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.targetGroup.setLayout((Layout)layout);
        this.reportDesignButton = new Button((Composite)this.targetGroup, 16);
        this.reportDesignButton.setText(Messages.getString((String)"HyperlinkBuilder.ReportDesignButton"));
        this.reportDesignButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.selectRadio((Composite)HyperlinkBuilder.this.targetGroup, HyperlinkBuilder.this.reportDesignButton);
                HyperlinkBuilder.this.initTargetReport(HyperlinkBuilder.this.locationEditor.getText());
                HyperlinkBuilder.this.initParamterBindings();
                HyperlinkBuilder.this.deSelectAnchor();
                HyperlinkBuilder.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.locationEditor = new Text((Composite)this.targetGroup, 2052);
        this.locationEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkBuilder.this.closeTargetReport();
                HyperlinkBuilder.this.initTargetReport(HyperlinkBuilder.this.locationEditor.getText());
                HyperlinkBuilder.this.initParamterBindings();
                HyperlinkBuilder.this.updateButtons();
                HyperlinkBuilder.this.deSelectAnchor();
            }
        });
        this.locationEditor.setLayoutData((Object)new GridData(768));
        this.createBrowerButton((Composite)this.targetGroup, this.locationEditor, false, true);
        this.createBindingTable((Composite)this.targetGroup);
        this.reportDocumentButton = new Button((Composite)this.targetGroup, 16);
        this.reportDocumentButton.setText(Messages.getString((String)"HyperlinkBuilder.ReportDocumentButton"));
        this.reportDocumentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.selectRadio((Composite)HyperlinkBuilder.this.targetGroup, HyperlinkBuilder.this.reportDocumentButton);
                HyperlinkBuilder.this.initTargetReport(HyperlinkBuilder.this.documentEditor.getText());
                HyperlinkBuilder.this.deSelectAnchor();
                HyperlinkBuilder.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.documentEditor = new Text((Composite)this.targetGroup, 2052);
        this.documentEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HyperlinkBuilder.this.closeTargetReport();
                HyperlinkBuilder.this.initTargetReport(HyperlinkBuilder.this.documentEditor.getText());
                HyperlinkBuilder.this.updateButtons();
                HyperlinkBuilder.this.deSelectAnchor();
            }
        });
        this.documentEditor.setLayoutData((Object)new GridData(768));
        this.createBrowerButton((Composite)this.targetGroup, this.documentEditor, false, true, new String[]{"*.rptdocument"});
    }

    private void createDrillthroughSelectTargetAnchor(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughStep2"));
        group.setLayout((Layout)new GridLayout());
        this.targetBookmarkButton = new Button((Composite)group, 16);
        this.targetBookmarkButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughTargetBookmark"));
        this.targetBookmarkButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.initAnchorChooser(HyperlinkBuilder.this.targetReportHandle, false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tocButton = new Button((Composite)group, 16);
        this.tocButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughTargetToc"));
        this.tocButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.initAnchorChooser(HyperlinkBuilder.this.targetReportHandle, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.anchorChooser = new Combo((Composite)group, 2056);
        this.anchorChooser.setLayoutData((Object)new GridData(768));
        this.anchorChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperlinkBuilder.this.anchorChooser.getData() instanceof List) {
                    List value = (List)HyperlinkBuilder.this.anchorChooser.getData();
                    HyperlinkBuilder.this.bookmarkEditor.setText((String)value.get(HyperlinkBuilder.this.anchorChooser.getSelectionIndex()));
                } else {
                    HyperlinkBuilder.this.bookmarkEditor.setText(HyperlinkBuilder.this.anchorChooser.getText());
                }
                HyperlinkBuilder.this.updateButtons();
            }
        });
    }

    private void createDrillthroughCreateLinkExpression(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughStep3"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughLinkExpression"));
        this.bookmarkEditor = new Text((Composite)group, 2056);
        this.bookmarkEditor.setLayoutData((Object)new GridData(768));
        this.createExpressionButton((Composite)group, this.bookmarkEditor);
    }

    private void createDrillthroughSelectShowTarget(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughStep4"));
        group.setLayout((Layout)new GridLayout());
        this.sameWindowButton = new Button((Composite)group, 16);
        this.sameWindowButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughSamewindow"));
        this.newWindowButton = new Button((Composite)group, 16);
        this.newWindowButton.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughNewWindow"));
    }

    private void createDrillthroughSelectFormat(Composite container) {
        Group group = new Group(container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.getString((String)"HyperlinkBuilder.DrillThroughStep5"));
        group.setLayout((Layout)new GridLayout());
        ReportEngine engine = new ReportEngine(new EngineConfig());
        this.supportedFormats = engine.getSupportedFormats();
        this.formatCheckBtns = new HashMap();
        for (int i = 0; i < this.supportedFormats.length; ++i) {
            Button btn = new Button((Composite)group, 16);
            btn.setText(this.supportedFormats[i]);
            this.formatCheckBtns.put(this.supportedFormats[i], btn);
            btn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    HyperlinkBuilder.this.initAnchorChooser(HyperlinkBuilder.this.targetReportHandle, true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void createBindingTable(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LABEL_REPORT_PARAMETER);
        label.setLayoutData((Object)new GridData(130));
        this.paramBindingTable = new TableViewer(parent, 67588);
        Table table = this.paramBindingTable.getTable();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 60;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn parameterColumn = new TableColumn(table, 16384);
        parameterColumn.setText(COLUMN_PARAMETER);
        parameterColumn.setResizable(true);
        parameterColumn.setWidth(100);
        parameterColumn = new TableColumn(table, 0x1000000);
        parameterColumn.setText(COLUMN_REQUIRED);
        parameterColumn.setResizable(true);
        parameterColumn.setWidth(55);
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(COLUMN_VALUE);
        valueColumn.setResizable(true);
        valueColumn.setWidth(180);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    HyperlinkBuilder.this.deleteRow();
                }
            }
        });
        this.paramBindingTable.setColumnProperties(new String[]{COLUMN_PARAMETER, COLUMN_REQUIRED, COLUMN_VALUE});
        this.parameterChooser = new ComboBoxCellEditor((Composite)table, new String[0], 8);
        ExpressionCellEditor valueEditor = new ExpressionCellEditor((Composite)table);
        valueEditor.setExpressionProvider(new ExpressionProvider(this.inputHandle.getElementHandle()));
        this.paramBindingTable.setCellEditors(new CellEditor[]{this.parameterChooser, null, valueEditor});
        this.paramBindingTable.setContentProvider((IContentProvider)this.contentProvider);
        this.paramBindingTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.paramBindingTable.setCellModifier(this.cellModifier);
        this.paramBindingTable.setInput((Object)this.bindingList);
    }

    private void clearArea() {
        Control[] controls = this.displayArea.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].dispose();
        }
    }

    private void createExpressionButton(Composite parent, final Text text) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData());
        button.setText("...");
        button.setToolTipText(TOOLTIP_EXPRESSION);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder builder = new ExpressionBuilder(text.getText());
                HyperlinkBuilder.this.configureExpressionBuilder(builder);
                if (builder.open() == 0) {
                    text.setText(builder.getResult());
                    HyperlinkBuilder.this.updateButtons();
                }
            }
        });
    }

    protected void configureExpressionBuilder(ExpressionBuilder builder) {
        builder.setExpressionProvier(new ExpressionProvider(this.inputHandle.getElementHandle()));
    }

    private Button createBrowerButton(Composite parent, Text text, boolean needQuote, boolean needFilter) {
        List extensionList = ReportPlugin.getDefault().getReportExtensionNameList();
        String[] extensionNames = new String[extensionList.size()];
        for (int i = 0; i < extensionNames.length; ++i) {
            extensionNames[i] = "*." + extensionList.get(i);
        }
        return this.createBrowerButton(parent, text, needQuote, needFilter, extensionNames);
    }

    private Button createBrowerButton(Composite parent, final Text text, final boolean needQuote, final boolean needFilter, final String[] fileExt) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData());
        button.setImage(IMAGE_OPEN_FILE);
        button.setToolTipText(TOOLTIP_BROWSE_FILE);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(UIUtil.getDefaultShell());
                if (needFilter) {
                    dialog.setFilterExtensions(fileExt);
                }
                try {
                    String filename = dialog.open();
                    if (filename != null) {
                        File file = new File(filename);
                        if (!file.isFile() || !file.exists()) {
                            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"HyperlinkBuilder.FileNameError.Title"), Messages.getString((String)"HyperlinkBuilder.FileNameError.Message"));
                            return;
                        }
                        filename = file.toURL().toString();
                        if (needFilter && !HyperlinkBuilder.this.checkExtensions(fileExt, filename)) {
                            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"HyperlinkBuilder.FileNameError.Title"), Messages.getString((String)"HyperlinkBuilder.FileNameError.Message"));
                            return;
                        }
                        if (needFilter) {
                            filename = URIUtil.getRelativePath((String)HyperlinkBuilder.this.getBasePath(), (String)filename);
                        }
                        filename = new Path(filename).toString();
                        if (needQuote) {
                            filename = "\"" + filename + "\"";
                        }
                        text.setText(filename);
                    }
                    HyperlinkBuilder.this.updateButtons();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
            }
        });
        return button;
    }

    private void createTargetBar() {
        new Label(this.displayArea, 0).setText(LABEL_TARGET);
        this.targetChooser = new Combo(this.displayArea, 2056);
        this.targetChooser.setLayoutData((Object)new GridData(768));
        this.targetChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(CHOICESET_TARGET));
        UIUtil.createBlankLabel(this.displayArea);
    }

    private void createBookmarkBar(boolean isRequired) {
        String label = isRequired ? REQUIED_MARK + LABEL_BOOKMARK : LABEL_BOOKMARK;
        new Label(this.displayArea, 0).setText(label);
        this.bookmarkChooser = new Combo(this.displayArea, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.bookmarkChooser.setLayoutData((Object)gd);
        this.bookmarkChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkBuilder.this.bookmarkEditor.setText(HyperlinkBuilder.this.bookmarkChooser.getText());
                HyperlinkBuilder.this.updateButtons();
            }
        });
        new Label(this.displayArea, 0).setText(LABEL_LINKED_EXPRESSION);
        this.bookmarkEditor = new Text(this.displayArea, 2056);
        this.bookmarkEditor.setLayoutData((Object)new GridData(768));
        this.createExpressionButton(this.displayArea, this.bookmarkEditor);
    }

    private void createFormatBar() {
        new Label(this.displayArea, 0).setText(LABEL_FORMAT);
        this.formatChooser = new Combo(this.displayArea, 2056);
        this.formatChooser.setLayoutData((Object)new GridData(768));
        this.formatChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(CHOICESET_FORMAT));
        UIUtil.createBlankLabel(this.displayArea);
    }

    protected void okPressed() {
        try {
            this.inputHandle.setURI(null);
            this.inputHandle.setTargetBookmark(null);
            this.inputHandle.setTargetWindow(null);
            this.inputHandle.setReportName(null);
            this.inputHandle.setFormatType(null);
            this.inputHandle.getMember("paramBindings").setValue(null);
            if ("hyperlink".equals(this.selectedType)) {
                this.inputHandle.setURI(this.locationEditor.getText().trim());
                this.inputHandle.setTargetWindow(ChoiceSetFactory.getValueFromChoiceSet(this.targetChooser.getText(), CHOICESET_TARGET));
            } else if ("bookmark-link".equals(this.selectedType)) {
                this.inputHandle.setTargetBookmark(this.bookmarkEditor.getText().trim());
            } else if ("drill-through".equals(this.selectedType)) {
                if (this.reportDesignButton.getSelection()) {
                    this.inputHandle.setTargetFileType("report-design");
                    this.inputHandle.setReportName(this.locationEditor.getText().trim());
                    Iterator iter = this.bindingList.iterator();
                    while (iter.hasNext()) {
                        this.inputHandle.addParamBinding((ParamBinding)iter.next());
                    }
                } else if (this.reportDocumentButton.getSelection()) {
                    this.inputHandle.setTargetFileType("report-document");
                    this.inputHandle.setReportName(this.documentEditor.getText().trim());
                }
                if (!StringUtil.isBlank((String)this.bookmarkEditor.getText())) {
                    this.inputHandle.setTargetBookmark(this.bookmarkEditor.getText().trim());
                }
                if (this.targetBookmarkButton.getSelection()) {
                    this.inputHandle.setTargetBookmarkType("bookmark");
                } else if (this.tocButton.getSelection()) {
                    this.inputHandle.setTargetBookmarkType("toc");
                }
                if (this.sameWindowButton.getSelection()) {
                    this.inputHandle.setTargetWindow("_self");
                } else {
                    this.inputHandle.setTargetWindow("_blank");
                }
                for (int i = 0; i < this.supportedFormats.length; ++i) {
                    if (!((Button)this.formatCheckBtns.get(this.supportedFormats[i])).getSelection()) continue;
                    this.inputHandle.setFormatType(this.supportedFormats[i]);
                }
            }
            this.inputHandle.setLinkType(this.selectedType);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        this.setResult(this.inputHandle);
        super.okPressed();
    }

    public boolean close() {
        this.closeTargetReport();
        return super.close();
    }

    public void setInput(ActionHandle input) {
        this.inputHandle = input;
    }

    protected boolean initDialog() {
        this.dataSetList = DEUtil.getDataSetList((DesignElementHandle)this.inputHandle.getElementHandle());
        this.switchTo(this.inputHandle.getLinkType());
        if ("hyperlink".equals(this.selectedType)) {
            this.uriRadio.setSelection(true);
        } else if ("bookmark-link".equals(this.selectedType)) {
            this.bookmarkRadio.setSelection(true);
        } else if ("drill-through".equals(this.selectedType)) {
            this.drillRadio.setSelection(true);
        } else {
            this.noneRadio.setSelection(true);
        }
        return super.initDialog();
    }

    private void initDisplayArea() {
        if ("hyperlink".equals(this.selectedType)) {
            if (this.inputHandle.getURI() != null) {
                this.locationEditor.setText(this.inputHandle.getURI());
            }
            if (this.inputHandle.getTargetWindow() != null) {
                this.targetChooser.setText(ChoiceSetFactory.getDisplayNameFromChoiceSet(this.inputHandle.getTargetWindow(), CHOICESET_TARGET));
            } else {
                this.targetChooser.select(0);
            }
        } else if ("bookmark-link".equals(this.selectedType)) {
            if (this.inputHandle.getTargetBookmark() != null) {
                this.bookmarkEditor.setText(this.inputHandle.getTargetBookmark());
            }
            this.initBookmarkList(SessionHandleAdapter.getInstance().getReportDesignHandle());
        } else if ("drill-through".equals(this.selectedType)) {
            if ("report-document".equals(this.inputHandle.getTargetFileType())) {
                this.reportDocumentButton.setSelection(true);
                if (this.inputHandle.getReportName() != null) {
                    this.documentEditor.setText(this.inputHandle.getReportName());
                }
                this.selectRadio((Composite)this.targetGroup, this.reportDocumentButton);
            } else {
                this.reportDesignButton.setSelection(true);
                if (this.inputHandle.getReportName() != null) {
                    this.locationEditor.setText(this.inputHandle.getReportName());
                }
                this.selectRadio((Composite)this.targetGroup, this.reportDesignButton);
            }
            if (this.inputHandle.getReportName() != null) {
                this.initTargetReport(this.inputHandle.getReportName());
            }
            if ("bookmark".equals(this.inputHandle.getTargetBookmarkType())) {
                this.targetBookmarkButton.setSelection(true);
                this.initAnchorChooser(this.targetReportHandle, false);
            } else if ("toc".equals(this.inputHandle.getTargetBookmarkType())) {
                this.tocButton.setSelection(true);
                this.initAnchorChooser(this.targetReportHandle, true);
            }
            if (this.inputHandle.getTargetBookmark() != null) {
                this.bookmarkEditor.setText(this.inputHandle.getTargetBookmark());
            }
            if ("_blank".equals(this.inputHandle.getTargetWindow())) {
                this.newWindowButton.setSelection(true);
            } else {
                this.sameWindowButton.setSelection(true);
            }
            if (this.inputHandle.getFormatType() != null) {
                ((Button)this.formatCheckBtns.get(this.inputHandle.getFormatType())).setSelection(true);
            } else {
                ((Button)this.formatCheckBtns.get("html")).setSelection(true);
            }
        }
        this.updateButtons();
    }

    private void initParamterBindings() {
        if (this.targetReportHandle != null) {
            this.bindingList.clear();
            this.parameterList.clear();
            String errorMessage = null;
            String newFilename = this.locationEditor.getText().trim();
            if (newFilename.length() == 0) {
                errorMessage = ERROR_MSG_REPORT_REQUIRED;
            } else if (this.targetReportHandle instanceof ReportDesignHandle) {
                Iterator iter = ((ReportDesignHandle)this.targetReportHandle).getAllParameters().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ParameterHandle)) continue;
                    this.parameterList.add(obj);
                }
                if (newFilename.equals(this.inputHandle.getReportName())) {
                    iter = this.inputHandle.paramBindingsIterator();
                    while (iter.hasNext()) {
                        ParamBindingHandle handle = (ParamBindingHandle)iter.next();
                        this.bindingList.add(handle.getStructure());
                    }
                }
            }
            if (errorMessage != null) {
                this.messageLine.setText(errorMessage);
                this.messageLine.setImage(ERROR_ICON);
            } else {
                this.messageLine.setText("");
                this.messageLine.setImage(null);
            }
            this.paramBindingTable.refresh();
            this.paramBindingTable.getTable().setEnabled(!this.parameterList.isEmpty());
            this.updateButtons();
        }
    }

    private void initBookmarkList(Object handle) {
        this.bookmarkChooser.removeAll();
        if (handle != null && handle instanceof ReportDesignHandle) {
            this.bookmarkChooser.setItems(((ReportDesignHandle)handle).getAllBookmarks().toArray(new String[0]));
            this.bookmarkChooser.setText(this.bookmarkEditor.getText());
        }
        this.bookmarkChooser.setEnabled(this.bookmarkChooser.getItemCount() > 0);
    }

    private void initAnchorChooser(Object handle, boolean isToc) {
        this.anchorChooser.removeAll();
        if (handle instanceof ReportDesignHandle) {
            if (isToc) {
                this.anchorChooser.setItems(((ReportDesignHandle)handle).getAllTocs().toArray(new String[0]));
            } else {
                this.anchorChooser.setItems(((ReportDesignHandle)handle).getAllBookmarks().toArray(new String[0]));
            }
        } else if (handle instanceof IReportDocument) {
            if (isToc) {
                String format = "html";
                for (int i = 0; i < this.supportedFormats.length; ++i) {
                    if (!((Button)this.formatCheckBtns.get(this.supportedFormats[i])).getSelection()) continue;
                    format = this.supportedFormats[i];
                    break;
                }
                ITOCTree tocTree = ((IReportDocument)handle).getTOCTree(format, SessionHandleAdapter.getInstance().getSessionHandle().getULocale());
                TOCNode rootTocNode = tocTree.getRoot();
                this.anchorChooser.setItems(this.getAllTocDisplayString(rootTocNode).toArray(new String[0]));
            } else {
                this.anchorChooser.setItems(this.getDocumentBookmarks((IReportDocument)handle));
            }
        }
        this.bookmarkEditor.setText("");
        String bookmark = this.inputHandle.getTargetBookmark();
        String[] chooserValues = this.anchorChooser.getItems();
        if (bookmark != null && chooserValues != null) {
            for (int i = 0; i < chooserValues.length; ++i) {
                if (!bookmark.equals(chooserValues[i])) continue;
                this.anchorChooser.select(i);
                this.bookmarkEditor.setText(this.anchorChooser.getText());
            }
        }
        this.anchorChooser.setEnabled(this.anchorChooser.getItemCount() > 0);
    }

    private String[] getDocumentBookmarks(IReportDocument rdoc) {
        List bookmarks = rdoc.getBookmarks();
        String[] bookmarkArray = new String[bookmarks.size()];
        int i = 0;
        Iterator iter = bookmarks.iterator();
        while (iter.hasNext()) {
            bookmarkArray[i] = "\"" + iter.next() + "\"";
            ++i;
        }
        return bookmarkArray;
    }

    private List getAllTocDisplayString(TOCNode parent) {
        ArrayList<String> tocList = new ArrayList<String>();
        if (parent.getParent() != null) {
            tocList.add("\"" + parent.getDisplayString() + "\"");
        }
        List childToc = parent.getChildren();
        Iterator iter = childToc.iterator();
        while (iter.hasNext()) {
            TOCNode node = (TOCNode)iter.next();
            tocList.addAll(this.getAllTocDisplayString(node));
        }
        return tocList;
    }

    private void addRadioListener(Button radio, final String type) {
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HyperlinkBuilder.this.selectedType != type) {
                    HyperlinkBuilder.this.switchTo(type);
                }
            }
        });
    }

    private void updateButtons() {
        boolean okEnable = true;
        if ("hyperlink".equals(this.selectedType)) {
            okEnable = !StringUtil.isBlank((String)this.locationEditor.getText());
        } else if ("bookmark-link".equals(this.selectedType)) {
            okEnable = !StringUtil.isBlank((String)this.bookmarkEditor.getText());
        } else if ("drill-through".equals(this.selectedType)) {
            okEnable = this.targetReportHandle != null && !StringUtil.isBlank((String)this.locationEditor.getText()) || !StringUtil.isBlank((String)this.documentEditor.getText()) && this.messageLine.getImage() == null;
        }
        this.getOkButton().setEnabled(okEnable);
    }

    private void buildParameterChoices(String selectedParameter) {
        ArrayList<String> avaliavleList = new ArrayList<String>();
        Iterator iter = this.parameterList.iterator();
        while (iter.hasNext()) {
            ParameterHandle parameter = (ParameterHandle)iter.next();
            avaliavleList.add(parameter.getQualifiedName());
        }
        iter = this.bindingList.iterator();
        while (iter.hasNext()) {
            ParamBinding paramBinding = (ParamBinding)iter.next();
            if (paramBinding.getParamName().equals(selectedParameter)) continue;
            avaliavleList.remove(paramBinding.getParamName());
        }
        this.parameterChooser.setItems(avaliavleList.toArray(new String[0]));
    }

    private void deleteRow() {
        ParamBinding paramBinding = this.getSelectedBinding();
        if (paramBinding != null) {
            this.bindingList.remove(paramBinding);
            this.paramBindingTable.refresh();
        }
    }

    private ParamBinding getSelectedBinding() {
        IStructuredSelection selection = (IStructuredSelection)this.paramBindingTable.getSelection();
        if (selection.size() == 1) {
            return (ParamBinding)selection.getFirstElement();
        }
        return null;
    }

    private void closeTargetReport() {
        if (this.targetReportHandle instanceof ReportDesignHandle) {
            ((ReportDesignHandle)this.targetReportHandle).close();
        } else if (this.targetReportHandle instanceof IReportDocument) {
            ((IReportDocument)this.targetReportHandle).close();
        }
        this.targetReportHandle = null;
    }

    private void initTargetReport(String newFilename) {
        this.closeTargetReport();
        this.targetReportHandle = null;
        String errorMessage = null;
        if (newFilename.endsWith(".rptdocument")) {
            ReportEngine engine = new ReportEngine(new EngineConfig());
            try {
                this.targetReportHandle = engine.openReportDocument(URIUtil.resolveAbsolutePath((String)this.getBasePath(), (String)newFilename));
            }
            catch (EngineException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.targetReportHandle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(newFilename);
            }
            catch (DesignFileException e) {
                try {
                    this.targetReportHandle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(URIUtil.resolveAbsolutePath((String)this.getBasePath(), (String)newFilename));
                }
                catch (DesignFileException e1) {
                    errorMessage = ERROR_MSG_INVALID_REPORT;
                }
            }
        }
        if (errorMessage != null) {
            this.messageLine.setText(errorMessage);
            this.messageLine.setImage(ERROR_ICON);
        } else {
            this.messageLine.setText("");
            this.messageLine.setImage(null);
        }
    }

    private String getBasePath() {
        String baseFile = SessionHandleAdapter.getInstance().getReportDesignHandle().getFileName();
        return new File(baseFile).getParent();
    }

    public void setInputString(String input, DesignElementHandle handle) throws DesignFileException {
        this.setInput(ModuleUtil.deserializeAction((String)input, (DesignElementHandle)handle));
    }

    public String getResultString() throws IOException {
        return ModuleUtil.serializeAction((ActionHandle)((ActionHandle)this.getResult()));
    }

    private void selectRadio(Composite container, Button radio) {
        Control[] children = container.getChildren();
        boolean isChoiceChild = false;
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof Label) continue;
            if ((children[i].getStyle() & 0x10) != 0) {
                if (children[i] == radio) {
                    isChoiceChild = true;
                    continue;
                }
                isChoiceChild = false;
                continue;
            }
            if (!isChoiceChild) {
                children[i].setEnabled(false);
                continue;
            }
            children[i].setEnabled(true);
        }
    }

    private void deSelectAnchor() {
        this.targetBookmarkButton.setSelection(false);
        this.tocButton.setSelection(false);
        this.anchorChooser.removeAll();
        this.bookmarkEditor.setText("");
    }

    protected boolean isParameterRequired(String paramName) {
        if (paramName == null) {
            return false;
        }
        if (this.parameterList != null) {
            Iterator iter = this.parameterList.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ScalarParameterHandle) || !((ScalarParameterHandle)obj).getName().equals(paramName)) continue;
                return !((ScalarParameterHandle)obj).allowNull() || !((ScalarParameterHandle)obj).allowBlank();
            }
        }
        return false;
    }

    private boolean checkExtensions(String[] fileExt, String fileName) {
        for (int i = 0; i < fileExt.length; ++i) {
            String ext = fileExt[i].substring(fileExt[i].lastIndexOf(46));
            if (!fileName.toLowerCase().endsWith(ext.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

