/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.BirtImageLoader;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.DataBindingDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImageBuilder
extends BaseDialog {
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String[] IMAGE_FILEFILTERS = new String[]{"*.bmp;*.jpg;*.jpeg;*.jpe;*.jfif;*.gif;*.png;*.tif;*.tiff;*.ico;*.svg"};
    private static final String DLG_IMPORT_BUTTON = Messages.getString((String)"ImageBuilder.Button.Import");
    private static final String DLG_PREVIEW_LABEL = Messages.getString((String)"ImageBuilder.Button.Preview");
    private static final String DLG_ENTER_URI_LABEL = Messages.getString((String)"ImageBuilder.Label.EnterUri");
    private static final String DLG_ENTER_RESOURCE_FILE_LABEL = Messages.getString((String)"ImageBuilder.Label.EnterResourceFile");
    private static final String DLG_EMBEDDED_IMAGE_LABEL = Messages.getString((String)"ImageBuilder.Label.EmbededImage");
    private static final String DLG_URI_LABEL = Messages.getString((String)"ImageBuilder.Label.URI");
    private static final String DLG_SELECT_PICTURE_LABEL = Messages.getString((String)"ImageBuilder.Label.SelectFrom");
    private static final String DLG_INSERT_BUTTON_MSG = Messages.getString((String)"ImageBuilder.Button.Insert");
    public static final String DLG_TITLE_NEW = Messages.getString((String)"ImageBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"ImageBuilder.DialogTitle.Edit");
    private static final String DLG_TITLE_IMPORT_FAIL = Messages.getString((String)"ImageBuilder.DialogTitle.ImportFailed");
    private static final String DLG_TITLE_LOADING_FAIL = Messages.getString((String)"ImageBuilder.DialogTitle.LoadingFailed");
    private static final String DLG_ERROR_MSG_LOADING_FAIL = Messages.getString((String)"ImageBuilder.ErrorMessage.LoadingFailed");
    private static final String DLG_ERROR_MSG_FILE_EXISTS = Messages.getString((String)"ImageBuilder.ErrorMessage.FileLoaded");
    private ImageHandle inputImage;
    private Button embedded;
    private Button uri;
    private Button previewButton;
    private Button dynamic;
    private Button bindingButton;
    private Button resource;
    private Composite inputArea;
    private ImageCanvas previewCanvas;
    private Text uriEditor;
    private org.eclipse.swt.widgets.List embeddedImageList;
    private static final int URI_TYPE = 0;
    private static final int EMBEDDED_TYPE = 1;
    private static final int BLOB_TYPE = 2;
    private static final int FILE_TYPE = 3;
    private int selectedType = -1;
    private List dataSetList = new ArrayList();
    private List inputDataSetList = new ArrayList();

    public ImageBuilder(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public ImageBuilder(Shell parentShell, String title, List dataSetList) {
        super(parentShell, title);
        this.inputDataSetList = dataSetList;
        this.dataSetList = new ArrayList(this.inputDataSetList);
    }

    private ModuleHandle getModuleHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected Control createDialogArea(Composite parent) {
        if (this.inputImage == null) {
            this.inputImage = DesignElementFactory.getInstance().newImage(null);
            this.setOKLabel(DLG_INSERT_BUTTON_MSG);
        }
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(topCompostie);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ImageBuilder_ID");
        return topCompostie;
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(DLG_SELECT_PICTURE_LABEL);
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.uri = new Button(selectionArea, 16);
        this.uri.setText(DLG_URI_LABEL);
        this.uri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(0);
            }
        });
        this.embedded = new Button(selectionArea, 16);
        this.embedded.setText(DLG_EMBEDDED_IMAGE_LABEL);
        this.embedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(1);
            }
        });
        this.dynamic = new Button(selectionArea, 16);
        this.dynamic.setText(Messages.getString((String)"ImageBuilder.Button.Dynamic"));
        this.dynamic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(2);
            }
        });
        this.resource = new Button(selectionArea, 16);
        this.resource.setText(Messages.getString((String)"ImageBuilder.ResourceFileType"));
        this.resource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageBuilder.this.switchTo(3);
            }
        });
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(1840);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.inputArea.setLayoutData((Object)gd);
        this.inputArea.setLayout((Layout)new GridLayout());
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 300;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new ImageCanvas(previewArea);
    }

    private void switchTo(int type) {
        if (type == this.selectedType) {
            return;
        }
        this.selectedType = type;
        Control[] controls = this.inputArea.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].dispose();
        }
        this.clearPreview();
        switch (type) {
            case 0: {
                this.swtichToExprType();
                break;
            }
            case 1: {
                this.swtichToEmbeddedType();
                break;
            }
            case 2: {
                this.swtichToExprType();
                break;
            }
            case 3: {
                this.swtichToResourceType();
            }
        }
        this.inputArea.layout();
    }

    private void swtichToResourceType() {
        Label title = new Label(this.inputArea, 0);
        this.uriEditor = new Text(this.inputArea, 2060);
        this.uriEditor.setLayoutData((Object)new GridData(768));
        this.uriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageBuilder.this.updateButtons();
            }
        });
        Composite innerComp = new Composite(this.inputArea, 0);
        innerComp.setLayoutData((Object)new GridData(128));
        innerComp.setLayout((Layout)new GridLayout(2, false));
        title.setText(DLG_ENTER_RESOURCE_FILE_LABEL);
        Button inputButton = new Button(innerComp, 8);
        inputButton.setText(Messages.getString((String)"ImageBuilder.ButtonBrowser"));
        inputButton.setLayoutData((Object)new GridData(128));
        inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageBuilder.this.openResourceBrowser();
            }
        });
        this.previewButton = new Button(innerComp, 8);
        this.previewButton.setText(DLG_PREVIEW_LABEL);
        this.previewButton.setLayoutData((Object)new GridData(128));
        this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageBuilder.this.uriEditor.setText(ImageBuilder.this.uriEditor.getText().trim());
                ImageBuilder.this.preview(ImageBuilder.this.removeQuoteString(ImageBuilder.this.uriEditor.getText()));
            }
        });
        this.initURIEditor();
    }

    private void swtichToExprType() {
        Label title = new Label(this.inputArea, 0);
        this.uriEditor = new Text(this.inputArea, 2052);
        this.uriEditor.setLayoutData((Object)new GridData(768));
        this.uriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageBuilder.this.updateButtons();
            }
        });
        Composite innerComp = new Composite(this.inputArea, 0);
        innerComp.setLayoutData((Object)new GridData(128));
        if (this.selectedType == 2) {
            innerComp.setLayout((Layout)new GridLayout(3, false));
            title.setText(Messages.getString((String)"ImageBuilder.Label.EnterExpr"));
        } else {
            innerComp.setLayout((Layout)new GridLayout(2, false));
            title.setText(DLG_ENTER_URI_LABEL);
        }
        Button inputButton = new Button(innerComp, 8);
        inputButton.setText(Messages.getString((String)"ImageBuilder.Label.Open"));
        inputButton.setLayoutData((Object)new GridData(128));
        inputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageBuilder.this.openExpression();
            }
        });
        if (this.selectedType == 2) {
            this.bindingButton = new Button(innerComp, 8);
            this.bindingButton.setText(Messages.getString((String)"ImageBuilder.Label.Binding"));
            this.bindingButton.setLayoutData((Object)new GridData(128));
            this.bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ImageBuilder.this.openBidingDialog();
                }
            });
        }
        this.previewButton = new Button(innerComp, 8);
        this.previewButton.setText(DLG_PREVIEW_LABEL);
        this.previewButton.setLayoutData((Object)new GridData(128));
        this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                switch (ImageBuilder.this.selectedType) {
                    case 0: {
                        ImageBuilder.this.uriEditor.setText(ImageBuilder.this.uriEditor.getText().trim());
                        ImageBuilder.this.preview(ImageBuilder.this.removeQuoteString(ImageBuilder.this.uriEditor.getText()));
                    }
                }
            }
        });
        this.initURIEditor();
    }

    protected void openResourceBrowser() {
        ResourceSelectionValidator validator = new ResourceSelectionValidator(IMAGE_TYPES);
        ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, true, IMAGE_FILEFILTERS);
        dialog.setTitle(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Title"));
        dialog.setMessage(Messages.getString((String)"ImageBuilder.BrowserResourceDialog.Message"));
        dialog.setValidator(validator);
        if (dialog.open() == 0) {
            this.uriEditor.setText("\"" + dialog.getPath() + "\"");
        }
    }

    private String removeQuoteString(String value) {
        if (value != null && value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private void swtichToEmbeddedType() {
        this.embeddedImageList = new org.eclipse.swt.widgets.List(this.inputArea, 2820);
        this.embeddedImageList.setLayoutData((Object)new GridData(1808));
        this.embeddedImageList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageBuilder.this.preview();
                ImageBuilder.this.updateButtons();
            }
        });
        Composite buttonBar = new Composite(this.inputArea, 0);
        buttonBar.setLayoutData((Object)new GridData(768));
        buttonBar.setLayout((Layout)new GridLayout(2, false));
        Button importButton = new Button(buttonBar, 8);
        importButton.setText(DLG_IMPORT_BUTTON);
        GridData gd = new GridData(128);
        gd.grabExcessHorizontalSpace = true;
        importButton.setLayoutData((Object)gd);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileChooser = new FileDialog(ImageBuilder.this.getShell(), 4096);
                fileChooser.setText(Messages.getString((String)"ImageBuilder.Chooser.Title"));
                fileChooser.setFilterExtensions(IMAGE_FILEFILTERS);
                try {
                    String fileName;
                    String fullPath = fileChooser.open();
                    if (fullPath != null && (fileName = fileChooser.getFileName()) != null) {
                        if (ImageBuilder.this.embeddedImageList.indexOf(fileName) != -1) {
                            ExceptionHandler.openMessageBox(DLG_TITLE_IMPORT_FAIL, DLG_ERROR_MSG_FILE_EXISTS, 8);
                            return;
                        }
                        if (!ImageBuilder.this.checkExtensions(fileName)) {
                            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Title"), Messages.getString((String)"EmbeddedImagesNodeProvider.FileNameError.Message"));
                            return;
                        }
                        ImageBuilder.this.previewCanvas.loadImage(ImageManager.getInstance().loadImage(fullPath));
                        BirtImageLoader imageLoader = new BirtImageLoader();
                        EmbeddedImage image = imageLoader.save(ImageBuilder.this.getModuleHandle(), fullPath, fileName);
                        ImageBuilder.this.embeddedImageList.add(image.getName());
                        ImageBuilder.this.embeddedImageList.select(ImageBuilder.this.embeddedImageList.indexOf(image.getName()));
                        ImageBuilder.this.updateButtons();
                    }
                }
                catch (Throwable e2) {
                    GUIException e2;
                    ImageBuilder.this.preview();
                    if (e2 instanceof OutOfMemoryError) {
                        e2 = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e2);
                    }
                    ExceptionHandler.handle((Throwable)e2, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
                }
            }
        });
        this.initList();
    }

    private void preview(String uri) {
        try {
            Image image = ImageManager.getInstance().loadImage(uri);
            this.previewCanvas.loadImage(image);
        }
        catch (Exception e) {
            this.clearPreview();
            ExceptionHandler.handle(e, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
        }
    }

    private void preview() {
        if (this.embeddedImageList.getSelectionCount() > 0) {
            Image image = ImageManager.getInstance().getImage(this.inputImage.getModuleHandle(), this.embeddedImageList.getSelection()[0]);
            try {
                this.previewCanvas.loadImage(image);
                return;
            }
            catch (Exception e) {
                ExceptionHandler.handle(e, DLG_TITLE_LOADING_FAIL, DLG_ERROR_MSG_LOADING_FAIL);
            }
        }
        this.clearPreview();
    }

    private void clearPreview() {
        this.previewCanvas.clear();
    }

    protected void okPressed() {
        try {
            switch (this.selectedType) {
                case 3: {
                    this.inputImage.setFile(this.uriEditor.getText().trim());
                    break;
                }
                case 0: {
                    this.inputImage.setURL(this.uriEditor.getText().trim());
                    break;
                }
                case 1: {
                    this.inputImage.setImageName(this.embeddedImageList.getSelection()[0]);
                    break;
                }
                case 2: {
                    this.inputImage.setValueExpression(this.uriEditor.getText().trim());
                }
            }
            this.setResult(this.inputImage);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        super.okPressed();
    }

    public void setInput(Object input) {
        Assert.isTrue((boolean)(input instanceof ImageHandle));
        this.inputImage = (ImageHandle)input;
        if ("none".equals(this.inputImage.getSource())) {
            this.setOKLabel(DLG_INSERT_BUTTON_MSG);
        }
    }

    protected boolean initDialog() {
        if ("embed".equals(this.inputImage.getSource())) {
            this.embedded.setSelection(true);
            this.switchTo(1);
        } else if ("expr".equals(this.inputImage.getSource())) {
            this.dynamic.setSelection(true);
            this.switchTo(2);
        } else if ("file".equals(this.inputImage.getSource())) {
            this.resource.setSelection(true);
            this.switchTo(3);
        } else {
            this.uri.setSelection(true);
            this.switchTo(0);
        }
        return true;
    }

    private void initURIEditor() {
        String uri = "";
        if ("url".equals(this.inputImage.getSource())) {
            if (this.inputImage.getURI() != null && this.selectedType == 0) {
                uri = this.inputImage.getURI();
            }
        } else if ("file".equals(this.inputImage.getSource()) && this.inputImage.getURI() != null && this.selectedType == 3) {
            uri = this.inputImage.getURI();
        }
        if ("expr".equals(this.inputImage.getSource()) && this.selectedType == 2 && this.inputImage.getValueExpression() != null) {
            uri = this.inputImage.getValueExpression();
        }
        this.uriEditor.setText(uri);
        this.uriEditor.setFocus();
        this.clearPreview();
    }

    private void initList() {
        String imageName;
        Iterator itor = this.getModuleHandle().getVisibleImages().iterator();
        while (itor.hasNext()) {
            EmbeddedImageHandle handle = (EmbeddedImageHandle)itor.next();
            this.embeddedImageList.add(handle.getQualifiedName());
        }
        int index = -1;
        if ("embed".equals(this.inputImage.getSource()) && (imageName = this.inputImage.getImageName()) != null) {
            index = this.embeddedImageList.indexOf(imageName);
        }
        if (index != -1) {
            this.embeddedImageList.select(index);
            this.preview();
        } else {
            this.clearPreview();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean complete = false;
        switch (this.selectedType) {
            case 2: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                this.previewButton.setEnabled(false);
                if (SessionHandleAdapter.getInstance().getReportDesignHandle().getVisibleDataSets().isEmpty()) {
                    this.bindingButton.setEnabled(false);
                    break;
                }
                this.bindingButton.setEnabled(true);
                break;
            }
            case 0: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                this.previewButton.setEnabled(complete);
                break;
            }
            case 1: {
                complete = this.embeddedImageList.getSelectionCount() > 0;
                break;
            }
            case 3: {
                complete = !StringUtil.isBlank((String)this.uriEditor.getText());
                this.previewButton.setEnabled(complete);
            }
        }
        this.getOkButton().setEnabled(complete);
    }

    private void openExpression() {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.uriEditor.getText());
        this.unionDataSets();
        ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)this.inputImage);
        expressionBuilder.setExpressionProvier(provider);
        if (expressionBuilder.open() == 0) {
            this.uriEditor.setText(expressionBuilder.getResult());
        }
    }

    private void openBidingDialog() {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        ImageHandle handle = this.inputImage;
        stack.startTrans(Messages.getString((String)"DesignerActionBarContributor.menu.element.editDataBinding"));
        DataBindingDialog dialog = new DataBindingDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (DesignElementHandle)handle);
        if (dialog.open() == 0) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    private List unionDataSets() {
        this.dataSetList = new ArrayList(this.inputDataSetList);
        if (this.inputImage == null || this.inputImage.getDataSet() == null) {
            return this.dataSetList;
        }
        int i = this.inputDataSetList.indexOf(this.inputImage.getDataSet());
        if (i == -1) {
            this.dataSetList.add(this.inputImage.getDataSet());
        }
        return this.dataSetList;
    }

    private boolean checkExtensions(String fileName) {
        for (int i = 0; i < IMAGE_TYPES.length; ++i) {
            if (!fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) continue;
            return true;
        }
        return false;
    }
}

