/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.newelement;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LineHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ExtendsException;

public class DesignElementFactory
extends ElementFactory {
    ElementFactory factory = null;

    public static DesignElementFactory getInstance() {
        return new DesignElementFactory(SessionHandleAdapter.getInstance().getReportDesignHandle());
    }

    public static DesignElementFactory getInstance(ModuleHandle module) {
        return new DesignElementFactory(module);
    }

    protected DesignElementFactory(ModuleHandle module) {
        super(module.getModule());
        this.factory = new ElementFactory(module.getModule());
    }

    private String getNewName(String elementTypeName, String name) {
        if (name == null) {
            name = ReportPlugin.getDefault().getCustomName(elementTypeName);
        }
        return name;
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        String newName = this.getNewName(elementTypeName, name);
        return this.factory.newElement(elementTypeName, newName);
    }

    public FreeFormHandle newFreeForm(String name) {
        String newName = this.getNewName("FreeForm", name);
        return this.factory.newFreeForm(newName);
    }

    public DataItemHandle newDataItem(String name) {
        String newName = this.getNewName("Data", name);
        return this.factory.newDataItem(newName);
    }

    public AutoTextHandle newAutoText(String name) {
        String newName = this.getNewName("AutoText", name);
        return this.factory.newAutoText(newName);
    }

    public LabelHandle newLabel(String name) {
        String newName = this.getNewName("Label", name);
        return this.factory.newLabel(newName);
    }

    public ImageHandle newImage(String name) {
        String newName = this.getNewName("Image", name);
        return this.factory.newImage(newName);
    }

    public ListHandle newList(String name) {
        String newName = this.getNewName("List", name);
        return this.factory.newList(newName);
    }

    public GraphicMasterPageHandle newGraphicMasterPage(String name) {
        String newName = this.getNewName("GraphicMasterPage", name);
        return this.factory.newGraphicMasterPage(newName);
    }

    public SimpleMasterPageHandle newSimpleMasterPage(String name) {
        String newName = this.getNewName("SimpleMasterPage", name);
        return this.factory.newSimpleMasterPage(newName);
    }

    public ParameterGroupHandle newParameterGroup(String name) {
        String newName = this.getNewName("ParameterGroup", name);
        return this.factory.newParameterGroup(newName);
    }

    public ScalarParameterHandle newScalarParameter(String name) {
        String newName = this.getNewName("ScalarParameter", name);
        return this.factory.newScalarParameter(newName);
    }

    public SharedStyleHandle newStyle(String name) {
        String newName = this.getNewName("Style", name);
        return this.factory.newStyle(newName);
    }

    public ThemeHandle newTheme(String name) {
        String newName = this.getNewName("Theme", name);
        return this.factory.newTheme(newName);
    }

    public TextItemHandle newTextItem(String name) {
        String newName = this.getNewName("Text", name);
        return this.factory.newTextItem(newName);
    }

    public TableHandle newTableItem(String name) {
        String newName = this.getNewName("Table", name);
        return this.factory.newTableItem(newName);
    }

    public TableHandle newTableItem(String name, int columnNum) {
        String newName = this.getNewName("Table", name);
        return this.factory.newTableItem(newName, columnNum);
    }

    public TableHandle newTableItem(String name, int columnNum, int headerRow, int detailRow, int footerRow) {
        String newName = this.getNewName("Table", name);
        return this.factory.newTableItem(newName, columnNum, headerRow, detailRow, footerRow);
    }

    public GridHandle newGridItem(String name) {
        String newName = this.getNewName("Grid", name);
        return this.factory.newGridItem(newName);
    }

    public GridHandle newGridItem(String name, int columnNum, int rowNum) {
        String newName = this.getNewName("Grid", name);
        return this.factory.newGridItem(newName, columnNum, rowNum);
    }

    public LineHandle newLineItem(String name) {
        String newName = this.getNewName("Line", name);
        return this.factory.newLineItem(newName);
    }

    public RectangleHandle newRectangle(String name) {
        String newName = this.getNewName("Rectangle", name);
        return this.factory.newRectangle(newName);
    }

    public TextDataHandle newTextData(String name) {
        String newName = this.getNewName("TextData", name);
        return this.factory.newTextData(newName);
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        String newName = this.getNewName("ExtendedItem", name);
        return this.factory.newExtendedItem(newName, extensionName);
    }

    public ScriptDataSourceHandle newScriptDataSource(String name) {
        String newName = this.getNewName("ScriptDataSource", name);
        return this.factory.newScriptDataSource(newName);
    }

    public ScriptDataSetHandle newScriptDataSet(String name) {
        String newName = this.getNewName("ScriptDataSet", name);
        return this.factory.newScriptDataSet(newName);
    }

    public OdaDataSourceHandle newOdaDataSource(String name) {
        String newName = this.getNewName("OdaDataSource", name);
        return this.factory.newOdaDataSource(newName);
    }

    public OdaDataSourceHandle newOdaDataSource(String name, String extensionID) {
        String newName = this.getNewName("OdaDataSource", name);
        return this.factory.newOdaDataSource(newName, extensionID);
    }

    public OdaDataSetHandle newOdaDataSet(String name) {
        String newName = this.getNewName("OdaDataSet", name);
        return this.factory.newOdaDataSet(newName);
    }

    public OdaDataSetHandle newOdaDataSet(String name, String extensionID) {
        String newName = this.getNewName("OdaDataSet", name);
        return this.factory.newOdaDataSet(newName, extensionID);
    }

    public DesignElementHandle newElementFrom(DesignElementHandle element, String name) throws ExtendsException {
        String newName = this.getNewName(element.getElement().getElementName(), name);
        return this.factory.newElementFrom(element, newName);
    }

    public TableGroupHandle newTableGroup() {
        TableGroupHandle handle = this.factory.newTableGroup();
        try {
            handle.setHideDetail(false);
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
        return handle;
    }

    public ListGroupHandle newListGroup() {
        ListGroupHandle handle = this.factory.newListGroup();
        try {
            handle.setHideDetail(false);
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
        return handle;
    }
}

