/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IItemListViewer;
import org.eclipse.birt.report.designer.ui.preferences.ItemContent;

public class ItemContentList {
    private Vector contents = new Vector();
    private Set changeListeners = new HashSet();

    public ItemContentList() {
        this.initData();
    }

    public void clearList() {
        this.contents.clear();
    }

    private void initData() {
        String[] defaultNames = ReportPlugin.getDefault().getDefaultNamePreference();
        String[] customNames = ReportPlugin.getDefault().getCustomNamePreference();
        String[] descriptions = ReportPlugin.getDefault().getDescriptionPreference();
        String[] newElement = ReportPlugin.getDefault().getDefaultDefaultNamePreference();
        if (defaultNames.length != customNames.length || defaultNames.length != descriptions.length || customNames.length != descriptions.length) {
            defaultNames = ReportPlugin.getDefault().getDefaultDefaultNamePreference();
            customNames = ReportPlugin.getDefault().getDefaultCustomNamePreference();
            descriptions = ReportPlugin.getDefault().getDefaultDescriptionPreference();
        }
        for (int i = 0; i < defaultNames.length; ++i) {
            ItemContent content = new ItemContent(customNames[i]);
            content.setDefaultName(defaultNames[i]);
            content.setDescription(descriptions[i]);
            this.contents.add(content);
        }
        if (newElement.length != defaultNames.length) {
            this.addNewElementName(defaultNames, newElement);
        }
    }

    private void addNewElementName(String[] oldElement, String[] newElement) {
        int oldSize = oldElement.length;
        int newSize = newElement.length;
        for (int i = 0; i < newSize; ++i) {
            boolean find = false;
            for (int j = oldSize - 1; j >= 0; --j) {
                if (!newElement[i].equals(oldElement[j])) continue;
                find = true;
                break;
            }
            if (find) continue;
            ItemContent content = new ItemContent("");
            content.setDefaultName(newElement[i]);
            content.setDescription("");
            this.contents.add(content);
        }
    }

    public Vector getContents() {
        return this.contents;
    }

    public boolean setContent(int i, ItemContent itemContent) {
        if (i < 0 || i >= this.contents.size()) {
            return false;
        }
        ((ItemContent)this.contents.get(i)).setDefaultName(itemContent.getDefaultName());
        ((ItemContent)this.contents.get(i)).setCustomName(itemContent.getCustomName());
        ((ItemContent)this.contents.get(i)).setDescription(itemContent.getDescription());
        return true;
    }

    public void addContent() {
        ItemContent content = new ItemContent("New Custom Name");
        this.contents.add(this.contents.size(), content);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).addContent(content);
        }
    }

    public void addContent(ItemContent content) {
        this.contents.add(this.contents.size(), content);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).addContent(content);
        }
    }

    public void removeContent(ItemContent content) {
        this.contents.remove(content);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).removeContent(content);
        }
    }

    public void contentChanged(ItemContent content) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IItemListViewer)iterator.next()).updateContent(content);
        }
    }

    public void removeChangeListener(IItemListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IItemListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

