/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.GuiExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.IExtension;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeView;
import org.eclipse.birt.report.designer.ui.views.attributes.CategoryPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.CellPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.ColumnPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.DataPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.DefaultPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.GridPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.IPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.ImagePageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.LabelPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.ListPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.RowPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.TablePageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.TextDataPageGenerator;
import org.eclipse.birt.report.designer.ui.views.attributes.TextPageGenerator;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.swt.widgets.TabFolder;

public class AttributesBuilder {
    private IPageGenerator pageGenerator;
    private String typeInfo = Messages.getString((String)"AttributesBuilder.Label.None");
    static final /* synthetic */ boolean $assertionsDisabled;

    public void createPages(TabFolder tabFolder, List selection) {
        if (!$assertionsDisabled && tabFolder == null) {
            throw new AssertionError();
        }
        this.getPageGenerator(selection);
        this.pageGenerator.createTabItems(tabFolder, selection);
    }

    private void getPageGenerator(List selection) {
        Class pageGeneratorClass = DefaultPageGenerator.class;
        String oldTypeInfo = this.typeInfo;
        if (this.isSameType(selection)) {
            pageGeneratorClass = this.getGeneratorClass(selection.get(0));
            if (selection.get(0) instanceof ExtendedItemHandle) {
                Object obj;
                IExtension.Stub extension = new IExtension.Stub(){

                    public String getExtendsionIdentify() {
                        return "attribute";
                    }
                };
                Object element = null;
                if (!selection.isEmpty()) {
                    element = selection.get(0);
                }
                if ((obj = GuiExtensionManager.doExtension(extension, element)) instanceof IPageGenerator) {
                    this.typeInfo = Messages.getFormattedString((String)"AttributesBuilder.Label.Generic", (Object[])new String[]{GuiExtensionManager.getExtensionDisplayName(selection.get(0))});
                    IPageGenerator ng = (IPageGenerator)obj;
                    if (this.pageGenerator == null || ng != null && this.pageGenerator.getClass() != ng.getClass()) {
                        this.pageGenerator = ng;
                    }
                    return;
                }
            }
        }
        try {
            if (this.pageGenerator != null && this.pageGenerator.getClass() == pageGeneratorClass) {
                if (this.pageGenerator instanceof CategoryPageGenerator) {
                    if (this.typeInfo.equals(oldTypeInfo)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.pageGenerator = (IPageGenerator)pageGeneratorClass.newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    private Class getGeneratorClass(Object obj) {
        Class<?> type = obj.getClass();
        if (type == TableHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Table");
            return TablePageGenerator.class;
        }
        if (type == ImageHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Picture");
            return ImagePageGenerator.class;
        }
        if (type == TextItemHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Text");
            return TextPageGenerator.class;
        }
        if (type == TextDataHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.TextData");
            return TextDataPageGenerator.class;
        }
        if (type == ColumnHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Column");
            return ColumnPageGenerator.class;
        }
        if (type == RowHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Row");
            return RowPageGenerator.class;
        }
        if (type == GridHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Grid");
            return GridPageGenerator.class;
        }
        if (type == DataItemHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Data");
            return DataPageGenerator.class;
        }
        if (type == CellHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Cell");
            return CellPageGenerator.class;
        }
        if (type == ListHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.List");
            return ListPageGenerator.class;
        }
        if (type == AttributeView.ModelClassWrapper.class) {
            this.getGeneratorClass(((AttributeView.ModelClassWrapper)obj).getElement());
            return AttributeView.MessagePageGenerator.class;
        }
        if (type == LabelHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Label");
            return LabelPageGenerator.class;
        }
        if (type == SimpleMasterPageHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.MasterPage");
        } else if (type == DataSourceHandle.class || type == OdaDataSourceHandle.class || type == ScriptDataSourceHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.DataSourceHandle");
        } else if (type == DataSetHandle.class || type == OdaDataSetHandle.class || type == JointDataSetHandle.class || type == ScriptDataSetHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.DataSetHandle");
        } else if (type == ScalarParameterHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.ScalarParameterHandle");
        } else if (type == TemplateReportItemHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.TemplateReportItemHandle");
        } else if (type == ReportDesignHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Report");
        } else if (type == LibraryHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.Library");
        } else if (type == AutoTextHandle.class) {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.AutoText");
        } else {
            this.typeInfo = Messages.getString((String)"AttributesBuilder.Label.None");
            return DefaultPageGenerator.class;
        }
        return CategoryPageGenerator.class;
    }

    public String getTypeInfo() {
        return this.typeInfo;
    }

    private boolean isSameType(List selection) {
        if (selection == null || selection.size() == 0) {
            return false;
        }
        if (selection.get(0) == null) {
            return false;
        }
        Class<?> classObj = selection.get(0).getClass();
        for (int i = 1; i < selection.size(); ++i) {
            if (selection.get(i).getClass() == classObj) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !AttributesBuilder.class.desiredAssertionStatus();
    }
}

