/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.SortkeyBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class SortingModelProvider {
    private final IChoiceSet choiceSetDirection = ChoiceSetFactory.getStructChoiceSet("SortKey", "direction");
    private static final String[] EMPTY;
    private List columnList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String[] getColumnNames(String[] keys) {
        if (!$assertionsDisabled && keys == null) {
            throw new AssertionError();
        }
        String[] columnNames = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            IStructureDefn structure = DesignEngine.getMetaDataDictionary().getStructure("SortKey");
            columnNames[i] = structure.getMember(keys[i]).getDisplayName();
        }
        return columnNames;
    }

    public Object[] getElements(List input) {
        Object obj = input.get(0);
        if (!(obj instanceof DesignElementHandle)) {
            return EMPTY;
        }
        DesignElementHandle element = (DesignElementHandle)obj;
        PropertyHandle propertyHandle = element.getPropertyHandle("sort");
        Iterator iterator = propertyHandle.iterator();
        if (iterator == null) {
            return EMPTY;
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.toArray();
    }

    public String getText(Object element, String key) {
        if (!(element instanceof StructureHandle)) {
            return "";
        }
        String value = ((StructureHandle)element).getMember(key).getStringValue();
        if (value == null) {
            value = "";
        }
        if (key.equals("direction")) {
            IChoice choice = this.choiceSetDirection.findChoice(value);
            if (choice != null) {
                return choice.getDisplayName();
            }
        } else {
            return value;
        }
        return "";
    }

    public boolean setStringValue(Object item, Object element, String key, String newValue) throws SemanticException {
        String value;
        if (key.equals("key") && (value = DEUtil.getExpression((Object)this.getResultSetColumn(newValue))) != null) {
            newValue = value;
        }
        String saveValue = newValue;
        StructureHandle handle = (StructureHandle)element;
        if (key.equals("direction")) {
            IChoice choice = this.choiceSetDirection.findChoiceByDisplayName(newValue);
            saveValue = choice == null ? null : choice.getName();
        }
        handle.getMember(key).setStringValue(saveValue);
        return true;
    }

    public String[] getChoiceSet(Object item, String key) {
        if (key.equals("direction")) {
            return ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSetDirection);
        }
        if (!(item instanceof DesignElementHandle)) {
            return EMPTY;
        }
        return this.getDataSetColumns((DesignElementHandle)item);
    }

    private String[] getDataSetColumns(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
        }
        return values;
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.columnList.size(); ++i) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle("sort");
        propertyHandle.moveItem(oldPos, newPos);
        return true;
    }

    public boolean deleteItem(Object item, int pos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle("sort");
        if (propertyHandle.getAt(pos) != null) {
            propertyHandle.removeItem(pos);
        }
        return true;
    }

    public boolean doAddItem(Object item, int pos) throws SemanticException {
        if (item instanceof DesignElementHandle) {
            SortkeyBuilder dialog = new SortkeyBuilder(UIUtil.getDefaultShell(), SortkeyBuilder.DLG_TITLE_NEW);
            dialog.setHandle((DesignElementHandle)item);
            dialog.setInput(null);
            if (dialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    public boolean doEditItem(Object item, int pos) {
        if (item instanceof DesignElementHandle) {
            DesignElementHandle element = (DesignElementHandle)item;
            PropertyHandle propertyHandle = element.getPropertyHandle("sort");
            SortKeyHandle sortKeyHandle = (SortKeyHandle)propertyHandle.getAt(pos);
            if (sortKeyHandle == null) {
                return false;
            }
            SortkeyBuilder dialog = new SortkeyBuilder(UIUtil.getDefaultShell(), SortkeyBuilder.DLG_TITLE_EDIT);
            dialog.setHandle((DesignElementHandle)item);
            dialog.setInput(sortKeyHandle);
            if (dialog.open() == 1) {
                return false;
            }
        }
        return true;
    }

    static {
        $assertionsDisabled = !SortingModelProvider.class.desiredAssertionStatus();
        EMPTY = new String[0];
    }
}

