/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.ColumnBinding;
import org.eclipse.birt.core.data.ExpressionParserUtility;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.ParseIndicator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public final class ExpressionUtil {
    private static final String ROW_INDICATOR = "row";
    private static final String DATASET_ROW_INDICATOR = "dataSetRow";
    public static final String PARAMETER_INDICATOR = "params";
    private static String PREFIX;
    private static int suffix;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String createRowExpression(String rowName) {
        return "row[\"" + (rowName == null ? "" : rowName.trim()) + "\"]";
    }

    public static String createDataSetRowExpression(String rowName) {
        return "dataSetRow[\"" + (rowName == null ? "" : rowName.trim()) + "\"]";
    }

    public static String createJSRowExpression(String rowName) {
        return "row[\"" + (rowName == null ? "" : JavascriptEvalUtil.transformToJsConstants(rowName.trim())) + "\"]";
    }

    public static String createJSDataSetRowExpression(String rowName) {
        return "dataSetRow[\"" + (rowName == null ? "" : JavascriptEvalUtil.transformToJsConstants(rowName.trim())) + "\"]";
    }

    public static String createJSParameterExpression(String parameterName) {
        return "params[\"" + (parameterName == null ? "" : JavascriptEvalUtil.transformToJsConstants(parameterName.trim())) + "\"]";
    }

    public static String createRowExpression(int index) {
        return "row[" + index + "]";
    }

    public static List extractColumnExpressions(String oldExpression) throws BirtException {
        return ExpressionUtil.extractColumnExpressions(oldExpression, true);
    }

    public static String getColumnBindingName(String oldExpression) throws BirtException {
        List columnsLists = ExpressionUtil.extractColumnExpressions(oldExpression, true);
        if (columnsLists.size() != 1 || !ExpressionParserUtility.isDirectColumnRef(oldExpression, true)) {
            return null;
        }
        return ((IColumnBinding)columnsLists.get(0)).getResultSetColumnName();
    }

    public static List extractColumnExpressions(String oldExpression, boolean mode) throws BirtException {
        if (oldExpression == null || oldExpression.trim().length() == 0) {
            return new ArrayList();
        }
        return ExpressionParserUtility.compileColumnExpression(new ExpressionParserUtility(), oldExpression, mode);
    }

    public static boolean hasAggregation(String expression) {
        if (expression == null) {
            return false;
        }
        try {
            return ExpressionParserUtility.hasAggregation(expression, true);
        }
        catch (BirtException e) {
            return false;
        }
    }

    public static IColumnBinding getColumnBinding(String oldExpression) {
        return new ColumnBinding(PREFIX + ++suffix, ExpressionUtil.toNewExpression(oldExpression));
    }

    public static String toNewExpression(String oldExpression) {
        if (oldExpression == null) {
            return null;
        }
        char[] chars = oldExpression.toCharArray();
        if (chars.length < 5) {
            return oldExpression;
        }
        ParseIndicator status = new ParseIndicator(0, 0, false, false, true, true);
        for (int i = 0; i < chars.length; ++i) {
            if ((i = (status = ExpressionUtil.getParseIndicator(chars, i, status.omitNextQuote(), status.getCandidateKey1(), status.getCandidateKey2())).getNewIndex()) < status.getRetrieveSize() + 3 || !status.isCandidateKey() || chars[i - status.getRetrieveSize() - 3] != 'r' || chars[i - status.getRetrieveSize() - 2] != 'o' || chars[i - status.getRetrieveSize() - 1] != 'w' || i - status.getRetrieveSize() - 4 > 0 && !ExpressionUtil.isValidProceeding(chars[i - status.getRetrieveSize() - 4]) || chars[i] != ' ' && chars[i] != '.' && chars[i] != '[') continue;
            String firstPart = oldExpression.substring(0, i - status.getRetrieveSize() - 3);
            String secondPart = ExpressionUtil.toNewExpression(oldExpression.substring(i - status.getRetrieveSize()));
            String newExpression = firstPart + DATASET_ROW_INDICATOR + secondPart;
            return newExpression;
        }
        return oldExpression;
    }

    public static String updateParentQueryReferenceExpression(String oldExpression, boolean isParameterBinding) {
        if (oldExpression == null) {
            return null;
        }
        char[] chars = oldExpression.toCharArray();
        if (chars.length < 7) {
            return oldExpression;
        }
        ParseIndicator status = new ParseIndicator(0, 0, false, false, true, true);
        for (int i = 0; i < chars.length; ++i) {
            if ((i = (status = ExpressionUtil.getParseIndicator(chars, i, status.omitNextQuote(), status.getCandidateKey1(), status.getCandidateKey2())).getNewIndex()) < status.getRetrieveSize() + 4 || !status.isCandidateKey() || chars[i - status.getRetrieveSize() - 4] != 'r' || chars[i - status.getRetrieveSize() - 3] != 'o' || chars[i - status.getRetrieveSize() - 2] != 'w' || chars[i - status.getRetrieveSize() - 1] != 's' || i - status.getRetrieveSize() - 5 > 0 && !ExpressionUtil.isValidProceeding(chars[i - status.getRetrieveSize() - 5]) || chars[i] != ' ' && chars[i] != '.' && chars[i] != '[') continue;
            int start = i;
            int end = 1;
            do {
                ++end;
            } while (++i < chars.length && chars[i] != ']');
            String firstPart = oldExpression.substring(0, start - status.getRetrieveSize() - 4);
            String secondPart = ExpressionUtil.updateParentQueryReferenceExpression(oldExpression.substring(start - status.getRetrieveSize() + end), isParameterBinding);
            String newExpression = firstPart + (isParameterBinding ? ROW_INDICATOR : "row._outer") + secondPart;
            return newExpression;
        }
        return oldExpression;
    }

    public static boolean isScalarParamReference(String expression) {
        String PARAM_PATTERN = "params\\[\".+\\\"]";
        Pattern pattern = Pattern.compile("params\\[\".+\\\"]");
        Matcher matcher = pattern.matcher(expression);
        return matcher.matches();
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] != '\n') continue;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] != '*' || chars[i] != '/') continue;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }

    public static String[] getSourceDataSetNames(String jointColumName) {
        if (!$assertionsDisabled && jointColumName == null) {
            throw new AssertionError();
        }
        String[] result = new String[2];
        if (jointColumName.indexOf("::") != -1) {
            String[] splited = jointColumName.split("::");
            result[0] = splited[0];
            if (result[0].endsWith("1") || result[0].endsWith("2")) {
                result[1] = result[0].substring(0, result[0].length() - 1);
            }
        }
        return result;
    }

    public static String getDataSetNameWithoutPrefix(String fullDataSetName) {
        if (fullDataSetName == null) {
            return null;
        }
        String dataSetName = fullDataSetName;
        String[] temp = fullDataSetName.split("\\Q.\\E");
        if (temp.length >= 2) {
            dataSetName = temp[1].trim();
        }
        return dataSetName;
    }

    static {
        $assertionsDisabled = !ExpressionUtil.class.desiredAssertionStatus();
        PREFIX = "COLUMN_";
        suffix = 0;
    }
}

