/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.HashMap;
import org.eclipse.birt.chart.ui.swt.composites.CustomChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.ICustomChoice;
import org.eclipse.birt.chart.ui.swt.composites.TextComboChoiceCanvas;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CTextCombo
extends CustomChooserComposite {
    private Font fontBold = new Font((Device)Display.getCurrent(), "arial", 9, 1);
    private HashMap choiceMarkerMap = new HashMap(10);

    public CTextCombo(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CTextCombo.this.fontBold.dispose();
                CTextCombo.this.choiceMarkerMap.clear();
            }
        });
    }

    protected ICustomChoice createChoice(Composite parent, Object choiceValue) {
        if (choiceValue == null) {
            choiceValue = "";
        }
        TextComboChoice choice = new TextComboChoice(parent, 0, (String)choiceValue);
        if (this.choiceMarkerMap.containsKey(choiceValue)) {
            choice.setTextFont(this.fontBold);
        } else {
            choice.setTextFont(null);
        }
        return choice;
    }

    public void setText(String text) {
        this.setChoiceValue(text);
    }

    public String getText() {
        return (String)this.getChoiceValue();
    }

    public void markSelection(String text) {
        this.choiceMarkerMap.put(text, Boolean.TRUE);
    }

    public void unmarkSelection(String text) {
        this.choiceMarkerMap.remove(text);
    }

    private class TextComboChoice
    extends TextComboChoiceCanvas
    implements ICustomChoice {
        TextComboChoice(Composite parent, int iStyle, String comboText) {
            super(parent, iStyle, comboText);
        }

        public Object getValue() {
            return this.getText();
        }

        public void setValue(Object value) {
            this.setText((String)value);
            if (CTextCombo.this.choiceMarkerMap.containsKey(value)) {
                this.setTextFont(CTextCombo.this.fontBold);
            } else {
                this.setTextFont(null);
            }
        }
    }
}

